/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.common.util.admin.ManagedFile;
import org.glassfish.config.support.ConfigurationAccess;
import org.glassfish.config.support.ConfigurationPersistence;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.IndentingXMLStreamWriter;

@Service
@Scoped(value=Singleton.class)
public class DomainXmlPersistence
implements ConfigurationPersistence,
ConfigurationAccess {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    protected Logger logger;
    final XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DomainXmlPersistence.class);

    private ManagedFile getConfigFile() throws IOException {
        File location = null;
        try {
            location = this.getDestination();
            return new ManagedFile(location, 2000, -1);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, localStrings.getLocalString("InvalidLocation", "Cannot obtain configuration location {0}, configuration changes will not be persisted", new Object[]{location}), e);
            throw e;
        }
    }

    public Lock accessRead() throws IOException, TimeoutException {
        return this.getConfigFile().accessRead();
    }

    public Lock accessWrite() throws IOException, TimeoutException {
        return this.getConfigFile().accessWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(DomDocument doc) throws IOException {
        File destination = this.getDestination();
        if (destination == null) {
            this.logger.severe(localStrings.getLocalString("NoLocation", "domain.xml cannot be persisted, null destination"));
            return;
        }
        try {
            File f = File.createTempFile("domain", ".xml", destination.getParentFile());
            if (f == null) {
                throw new IOException(localStrings.getLocalString("NoTmpFile", "Cannot create temporary file when saving domain.xml"));
            }
            XMLStreamWriter writer = null;
            OutputStream fos = this.getOutputStream(f);
            try {
                writer = this.xmlFactory.createXMLStreamWriter(new BufferedOutputStream(fos));
                IndentingXMLStreamWriter indentingXMLStreamWriter = new IndentingXMLStreamWriter(writer);
                doc.writeTo(indentingXMLStreamWriter);
                indentingXMLStreamWriter.close();
            }
            catch (XMLStreamException e) {
                this.logger.log(Level.SEVERE, localStrings.getLocalString("TmpFileNotSaved", "Configuration could not be saved to temporary file"), e);
                return;
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (XMLStreamException e) {
                        this.logger.log(Level.SEVERE, localStrings.getLocalString("CloseFailed", "Cannot close configuration writer stream"), e);
                    }
                }
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            File backup = new File(this.env.getConfigDirPath(), "domain.xml.bak");
            if (backup.exists() && !backup.delete()) {
                this.logger.severe(localStrings.getLocalString("BackupDeleteFailed", "Could not delete previous backup file at {0}, configuration changes not persisted", new Object[]{backup.getAbsolutePath()}));
                return;
            }
            if (destination != null) {
                if (!destination.renameTo(backup)) {
                    this.logger.severe(localStrings.getLocalString("TmpRenameFailed", "Could not rename {0} to {1}, configuration changes not persisted", new Object[]{destination.getAbsolutePath(), backup.getAbsolutePath()}));
                    return;
                }
                if (!f.renameTo(destination)) {
                    this.logger.severe(localStrings.getLocalString("TmpRenameFailed", "Could not rename {0} to {1}, configuration changes not persisted", new Object[]{f.getAbsolutePath(), destination.getAbsolutePath()}));
                    if (!backup.renameTo(destination)) {
                        this.logger.severe(localStrings.getLocalString("RenameFailed", "Could not rename backup to {0}, configuration changes not persisted", new Object[]{destination.getAbsolutePath()}));
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, localStrings.getLocalString("ioexception", "IOException while saving the configuration, changes not persisted"), e);
        }
        this.saved(destination);
    }

    protected void saved(File destination) {
        this.logger.fine("Configuration saved at " + destination);
    }

    protected File getDestination() throws IOException {
        return new File(this.env.getConfigDirPath(), "domain.xml");
    }

    protected OutputStream getOutputStream(File destination) throws IOException {
        return new FileOutputStream(destination);
    }
}

