/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.websockets.HandShake;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.SecKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;

public class ClientHandShake
extends HandShake {
    private static final Random random = new Random();
    private SecKey key1;
    private SecKey key2;
    private byte[] key3;

    public ClientHandShake(boolean isSecure, String origin, String serverHostName, String portNumber, String path) {
        super(isSecure, origin, serverHostName, portNumber, path);
        this.key1 = SecKey.generateSecKey();
        this.key2 = SecKey.generateSecKey();
        this.key3 = new byte[8];
        random.nextBytes(this.key3);
    }

    public ClientHandShake(Request request, boolean secure) throws IOException {
        super(secure, request.requestURI().toString());
        MimeHeaders headers = request.getMimeHeaders();
        boolean upgrade = "WebSocket".equals(headers.getHeader("Upgrade"));
        boolean connection = "Upgrade".equals(headers.getHeader("Connection"));
        if (headers.getHeader("Sec-WebSocket-Key1") != null) {
            this.parse76Headers(request, headers);
        } else {
            this.parse75Headers(headers);
        }
        String header = this.readHeader(headers, "Origin");
        this.setOrigin(header != null ? header : "http://localhost");
        this.determineHostAndPort(headers);
        this.setLocation(this.buildLocation(secure));
        if (this.getServerHostName() == null || this.getOrigin() == null || !upgrade || !connection) {
            throw new IOException("Missing required headers for WebSocket negotiation");
        }
    }

    public SecKey getKey1() {
        return this.key1;
    }

    public SecKey getKey2() {
        return this.key2;
    }

    public byte[] getKey3() {
        return this.key3;
    }

    private void parse76Headers(Request request, MimeHeaders headers) throws IOException {
        this.setSubProtocol(headers.getHeader("Sec-WebSocket-Protocol"));
        this.key1 = SecKey.create(headers.getHeader("Sec-WebSocket-Key1"));
        this.key2 = SecKey.create(headers.getHeader("Sec-WebSocket-Key2"));
        if (this.key1 != null && this.key2 != null) {
            ByteChunk chunk = new ByteChunk(8);
            request.getInputBuffer().doRead(chunk, request);
            if (chunk.getEnd() - chunk.getStart() != 8) {
                throw new IllegalArgumentException("key3 length should be 8 bytes");
            }
            this.key3 = new byte[8];
            System.arraycopy(chunk.getBytes(), chunk.getStart(), this.key3, 0, 8);
        }
    }

    private void determineHostAndPort(MimeHeaders headers) {
        int i;
        String header = this.readHeader(headers, "host");
        int n = i = header == null ? -1 : header.indexOf(":");
        if (i == -1) {
            this.setServerHostName(header);
            this.setPort("80");
        } else {
            this.setServerHostName(header.substring(0, i));
            this.setPort(header.substring(i + 1));
        }
    }

    private void parse75Headers(MimeHeaders headers) {
        this.setSubProtocol(headers.getHeader("WebSocket-Protocol"));
    }

    public void validateServerResponse(byte[] key) throws HandshakeException {
        byte[] clientKey = SecKey.generateServerKey(this.key1, this.key2, this.key3);
        if (!Arrays.equals(clientKey, key)) {
            throw new HandshakeException(String.format("Security keys do not match: client '%s' vs. server '%s'", Arrays.toString(clientKey), Arrays.toString(key)));
        }
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream chunk = new ByteArrayOutputStream();
        chunk.write(String.format("GET %s HTTP/1.1\r\n", this.getResourcePath()).getBytes());
        chunk.write(String.format("Host: %s\r\n", this.getServerHostName()).getBytes());
        chunk.write(String.format("Connection: Upgrade\r\n", new Object[0]).getBytes());
        chunk.write(String.format("Upgrade: WebSocket\r\n", new Object[0]).getBytes());
        chunk.write(String.format("%s: %s\r\n", "Origin", this.getOrigin()).getBytes());
        if (this.getSubProtocol() != null) {
            chunk.write(String.format("%s: %s\r\n", "Sec-WebSocket-Protocol", this.getSubProtocol()).getBytes());
        }
        chunk.write(String.format("%s: %s\r\n", "Sec-WebSocket-Key1", this.getKey1().getSecKey()).getBytes());
        chunk.write(String.format("%s: %s\r\n", "Sec-WebSocket-Key2", this.getKey2().getSecKey()).getBytes());
        chunk.write("\r\n".getBytes());
        chunk.write(this.getKey3());
        return chunk.toByteArray();
    }
}

