/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.BaseWebSocket;
import com.sun.grizzly.websockets.ClientHandShake;
import com.sun.grizzly.websockets.ClientWebSocketApplication;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class ClientNetworkHandler
implements NetworkHandler {
    private SocketChannel channel;
    private URL url;
    private ClientWebSocketApplication app;
    private WebSocket webSocket;
    private ClientHandShake clientHS;
    private final ByteChunk chunk = new ByteChunk();
    private boolean isHeaderParsed = false;

    ClientNetworkHandler(SocketChannel channel) {
        this.channel = channel;
    }

    public ClientNetworkHandler(URL url, ClientWebSocketApplication application) throws IOException {
        this.url = url;
        this.app = application;
        this.channel = SocketChannel.open();
        this.channel.configureBlocking(false);
        this.channel.connect(new InetSocketAddress(url.getHost(), url.getPort()));
        this.channel.socket().setSoTimeout(30000);
    }

    SocketChannel getChannel() {
        return this.channel;
    }

    public void setChannel(SocketChannel channel) {
        this.channel = channel;
    }

    public void send(DataFrame frame) throws IOException {
        this.write(frame.frame());
    }

    public SelectionKey getKey() {
        return this.channel.keyFor(this.app.getSelector());
    }

    public void process(SelectionKey key) throws IOException {
        if (key.isValid()) {
            if (key.isConnectable()) {
                this.disableOp(8);
                this.doConnect(true);
                this.enableOp(1);
            } else if (key.isReadable()) {
                this.unframe();
                if (this.webSocket.isConnected()) {
                    this.enableOp(1);
                }
            }
        }
    }

    protected void doConnect(boolean finishNioConnect) throws IOException {
        String path;
        if (finishNioConnect) {
            this.channel.finishConnect();
        }
        boolean isSecure = "wss".equals(this.url.getProtocol());
        StringBuilder origin = new StringBuilder();
        origin.append(isSecure ? "https://" : "http://");
        origin.append(this.url.getHost());
        if (!isSecure && this.url.getPort() != 80 || isSecure && this.url.getPort() != 443) {
            origin.append(":").append(this.url.getPort());
        }
        if ("".equals(path = this.url.getPath())) {
            path = "/";
        }
        this.clientHS = new ClientHandShake(isSecure, origin.toString(), this.url.getHost(), String.valueOf(this.url.getPort()), path);
        this.write(this.clientHS.getBytes());
    }

    protected void write(byte[] bytes) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.channel.write(buffer);
    }

    private void unframe() throws IOException {
        int lastRead;
        while ((lastRead = this.read()) > 0) {
            if (this.webSocket.isConnected()) {
                this.readFrame();
                continue;
            }
            byte[] serverKey = this.findServerKey();
            if (serverKey == null) {
                return;
            }
            try {
                this.clientHS.validateServerResponse(serverKey);
            }
            catch (HandshakeException e) {
                throw new IOException(e.getMessage());
            }
            this.webSocket.onConnect();
        }
        if (lastRead == -1) {
            throw new EOFException();
        }
    }

    private byte[] findServerKey() throws IOException {
        if (!this.isHeaderParsed) {
            byte[] line;
            do {
                if ((line = this.readLine()) != null) continue;
                return null;
            } while (line.length != 0);
        }
        this.isHeaderParsed = true;
        return this.readN(16);
    }

    private byte[] readLine() throws IOException {
        if (this.chunk.getLength() <= 0) {
            return null;
        }
        int idx = this.chunk.indexOf('\n', 0);
        if (idx != -1) {
            int eolBytes = 1;
            int offset = this.chunk.getOffset();
            if ((idx += offset) > offset && this.chunk.getBuffer()[idx - 1] == 13) {
                --idx;
                eolBytes = 2;
            }
            int size = idx - offset;
            byte[] result = new byte[size];
            this.chunk.substract(result, 0, size);
            this.chunk.setOffset(this.chunk.getOffset() + eolBytes);
            return result;
        }
        return null;
    }

    private byte[] readN(int n) throws IOException {
        if (this.chunk.getLength() < n) {
            return null;
        }
        byte[] result = new byte[n];
        this.chunk.substract(result, 0, n);
        return result;
    }

    private void enableOp(int op) {
        SelectionKey key = this.getKey();
        int ops = key.interestOps();
        int newOp = ops | op;
        if (newOp != ops) {
            key.interestOps(newOp);
        }
    }

    private void disableOp(int op) {
        SelectionKey key = this.getKey();
        int ops = key.interestOps();
        int newOp = ops & ~op;
        if (newOp != ops) {
            key.interestOps(newOp);
        }
    }

    public void shutdown() throws IOException {
        this.getKey().cancel();
        this.channel.close();
        this.app.remove(this.webSocket);
    }

    public void setWebSocket(BaseWebSocket webSocket) {
        this.webSocket = webSocket;
        if (this.app != null) {
            this.app.register(this);
        }
    }

    protected void readFrame() throws IOException {
        while (this.read() > 0) {
            DataFrame dataFrame = DataFrame.read(this);
            if (dataFrame != null) {
                dataFrame.respond(this.webSocket);
                continue;
            }
            this.webSocket.close();
        }
    }

    private int read() throws IOException {
        int length;
        int count = this.chunk.getLength();
        if (count < 1) {
            ByteBuffer bytes = ByteBuffer.allocate(8192);
            while ((count = this.channel.read(bytes)) == 8192) {
                this.chunk.append(bytes.array(), 0, count);
            }
            if (count > 0) {
                this.chunk.append(bytes.array(), 0, count);
            }
        }
        if ((length = this.chunk.getLength()) <= 0) {
            return count;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte get() throws IOException {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            this.fill();
            return (byte)this.chunk.substract();
        }
    }

    private void fill() throws IOException {
        if (this.chunk.getLength() == 0) {
            this.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean peek(byte ... bytes) throws IOException {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            this.fill();
            return this.chunk.startsWith(bytes);
        }
    }
}

