/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-ssl")
@Scoped(value=PerLookup.class)
@I18n(value="delete.ssl")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteSsl
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteSsl.class);
    @Param(name="type", acceptableValues="network-listener, http-listener, iiop-listener, iiop-service")
    String type;
    @Param(name="listener_id", primary=true, optional=true)
    String listenerId;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    NetworkListeners networkListeners;
    @Inject
    IiopService iiopService;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Target targetUtil = (Target)this.habitat.getComponent(Target.class);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        if (!this.type.equals("iiop-service") && this.listenerId == null) {
            report.setMessage(localStrings.getLocalString("create.ssl.listenerid.missing", "Listener id needs to be specified"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            if ("http-listener".equals(this.type) || "network-listener".equals(this.type)) {
                NetworkConfig netConfig = this.config.getNetworkConfig();
                NetworkListener networkListener = netConfig.getNetworkListener(this.listenerId);
                if (networkListener == null) {
                    report.setMessage(localStrings.getLocalString("delete.ssl.http.listener.notfound", "HTTP Listener named {0} not found", new Object[]{this.listenerId}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                Protocol protocol = networkListener.findHttpProtocol();
                if (protocol.getSsl() == null) {
                    report.setMessage(localStrings.getLocalString("delete.ssl.element.doesnotexist", "Ssl element does not exist for Listener named {0}", new Object[]{this.listenerId}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                ConfigSupport.apply(new SingleConfigCode<Protocol>(){

                    @Override
                    public Object run(Protocol param) {
                        param.setSsl(null);
                        return null;
                    }
                }, networkListener.findHttpProtocol());
            } else if ("iiop-listener".equals(this.type)) {
                IiopListener iiopListener = null;
                for (IiopListener listener : this.iiopService.getIiopListener()) {
                    if (!listener.getId().equals(this.listenerId)) continue;
                    iiopListener = listener;
                }
                if (iiopListener == null) {
                    report.setMessage(localStrings.getLocalString("delete.ssl.iiop.listener.notfound", "Iiop Listener named {0} not found", new Object[]{this.listenerId}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                if (iiopListener.getSsl() == null) {
                    report.setMessage(localStrings.getLocalString("delete.ssl.element.doesnotexist", "Ssl element does not exist for Listener named {0}", new Object[]{this.listenerId}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                ConfigSupport.apply(new SingleConfigCode<IiopListener>(){

                    @Override
                    public Object run(IiopListener param) throws PropertyVetoException {
                        param.setSsl(null);
                        return null;
                    }
                }, iiopListener);
            } else if ("iiop-service".equals(this.type)) {
                if (this.config.getIiopService().getSslClientConfig() == null) {
                    report.setMessage(localStrings.getLocalString("delete.ssl.element.doesnotexistforiiop", "Ssl element does not exist for IIOP service"));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                ConfigSupport.apply(new SingleConfigCode<IiopService>(){

                    @Override
                    public Object run(IiopService param) throws PropertyVetoException {
                        param.setSslClientConfig(null);
                        return null;
                    }
                }, this.config.getIiopService());
            }
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.ssl.fail", "Deletion of Ssl in {0} failed", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

