/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.StateCommandParameters;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.VersioningDeploymentException;
import org.glassfish.deployment.common.VersioningDeploymentSyntaxException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="disable")
@I18n(value="disable.command")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
public class DisableCommand
extends StateCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableCommand.class);
    @Param(optional=true, separator=58)
    public Properties properties = null;
    @Param(optional=true)
    public Boolean keepstate;
    @Inject
    ServerEnvironment env;
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    Applications applications;
    @Inject(name="default-instance-name")
    protected Server server;
    @Inject
    VersioningService versioningService;
    @Inject
    Habitat habitat;

    public DisableCommand() {
        this.origin = OpsParams.Origin.unload;
    }

    public void execute(AdminCommandContext context) {
        ApplicationRef ref;
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        String appName = this.name();
        try {
            List matchedVersions = this.versioningService.getMatchedVersions(appName, this.target);
            if (matchedVersions == Collections.EMPTY_LIST) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return;
            }
            String enabledVersion = this.versioningService.getEnabledVersion(appName, this.target);
            if (!matchedVersions.contains(enabledVersion)) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return;
            }
            appName = enabledVersion;
        }
        catch (VersioningDeploymentSyntaxException e) {
            report.failure(logger, e.getMessage());
            return;
        }
        catch (VersioningDeploymentException e) {
            report.failure(logger, e.getMessage());
            return;
        }
        if (!this.deployment.isRegistered(appName)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{appName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!DeploymentUtils.isDomainTarget((String)this.target) && (ref = this.domain.getApplicationRefInTarget(appName, this.target)) == null) {
            report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", new Object[]{appName, this.target}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.env.isDas() && DeploymentUtils.isDomainTarget((String)this.target)) {
            List targets = this.domain.getAllReferencedTargetsForApplication(appName);
            try {
                ParameterMapExtractor extractor = new ParameterMapExtractor(new Object[]{this});
                ParameterMap paramMap = extractor.extract((Collection)Collections.EMPTY_LIST);
                paramMap.set((Object)"DEFAULT", (Object)appName);
                ClusterOperationUtil.replicateCommand((String)"disable", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, (Collection)targets, (AdminCommandContext)context, (ParameterMap)paramMap, (Habitat)this.habitat);
            }
            catch (Exception e) {
                report.failure(logger, e.getMessage());
                return;
            }
        }
        if (!this.domain.isCurrentInstanceMatchingTarget(this.target, appName, this.server.getName(), null)) {
            try {
                this.deployment.updateAppEnabledAttributeInDomainXML(appName, this.target, false);
            }
            catch (TransactionFailure e) {
                logger.warning("failed to set enable attribute for " + appName);
            }
            return;
        }
        ApplicationInfo appInfo = this.deployment.get(appName);
        try {
            Application app = this.applications.getApplication(appName);
            this.deployment.disable(appName, this.target, app, appInfo, report, logger, this.keepstate, this.properties);
            if (!report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                try {
                    this.deployment.updateAppEnabledAttributeInDomainXML(appName, this.target, false);
                }
                catch (TransactionFailure e) {
                    logger.warning("failed to set enable attribute for " + appName);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error during disabling: ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
    }
}

