/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.WebServiceEndpoint;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.NotNull;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
@RestRedirects(value={@RestRedirect(opType=RestRedirect.OpType.DELETE, commandName="undeploy"), @RestRedirect(opType=RestRedirect.OpType.POST, commandName="redeploy")})
public interface Application
extends Injectable,
ApplicationName,
PropertyBag {
    public static final String APP_LOCATION_PROP_NAME = "appLocation";
    public static final String DEPLOYMENT_PLAN_LOCATION_PROP_NAME = "deploymentPlanLocation";
    public static final String WEB_SNIFFER_TYPE = "web";
    public static final String EJB_SNIFFER_TYPE = "ejb";
    public static final String CONNECTOR_SNIFFER_TYPE = "connector";
    public static final String APPCLIENT_SNIFFER_TYPE = "appclient";
    public static final String JPA_SNIFFER_TYPE = "jpa";
    public static final String WEBSERVICE_SNIFFER_TYPE = "webservices";
    public static final String APPLICATION = "application";

    @Attribute
    public String getContextRoot();

    public void setContextRoot(String var1) throws PropertyVetoException;

    @Attribute
    public String getLocation();

    public void setLocation(String var1) throws PropertyVetoException;

    @Attribute(required=true)
    @NotNull
    public String getObjectType();

    public void setObjectType(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getEnabled();

    public void setEnabled(String var1) throws PropertyVetoException;

    @Attribute
    public String getLibraries();

    public void setLibraries(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getAvailabilityEnabled();

    public void setAvailabilityEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getAsyncReplication();

    public void setAsyncReplication(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getDirectoryDeployed();

    public void setDirectoryDeployed(String var1) throws PropertyVetoException;

    @Attribute
    public String getDescription();

    public void setDescription(String var1) throws PropertyVetoException;

    @Element
    public List<Module> getModule();

    @Element
    public List<Engine> getEngine();

    @Element
    public List<WebServiceEndpoint> getWebServiceEndpoint();

    @Element
    public Resources getResources();

    public void setResources(Resources var1) throws PropertyVetoException;

    @DuckTyped
    public Module getModule(String var1);

    @DuckTyped
    public Properties getDeployProperties();

    @DuckTyped
    public DeployCommandParameters getDeployParameters(ApplicationRef var1);

    @DuckTyped
    public Map<String, Properties> getModulePropertiesMap();

    @DuckTyped
    public boolean isStandaloneModule();

    @DuckTyped
    public boolean containsSnifferType(String var1);

    @DuckTyped
    public void recordFileLocations(File var1, File var2);

    @DuckTyped
    public File application();

    @DuckTyped
    public File deploymentPlan();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Duck {
        public static Module getModule(Application instance, String name) {
            for (Module module : instance.getModule()) {
                if (!module.getName().equals(name)) continue;
                return module;
            }
            return null;
        }

        public static Properties getDeployProperties(Application instance) {
            Properties deploymentProps = new Properties();
            for (Property prop : instance.getProperty()) {
                deploymentProps.put(prop.getName(), prop.getValue());
            }
            deploymentProps.setProperty("object-type", instance.getObjectType());
            if (instance.getContextRoot() != null) {
                deploymentProps.setProperty("context-root", instance.getContextRoot());
            }
            if (instance.getDirectoryDeployed() != null) {
                deploymentProps.setProperty("directory-deployed", instance.getDirectoryDeployed());
            }
            return deploymentProps;
        }

        public static DeployCommandParameters getDeployParameters(Application app, ApplicationRef appRef) {
            URI uri = null;
            try {
                uri = new URI(app.getLocation());
            }
            catch (URISyntaxException e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, e.getMessage(), e);
            }
            if (uri == null) {
                return null;
            }
            DeployCommandParameters deploymentParams = new DeployCommandParameters(new File(uri));
            deploymentParams.name = app.getName();
            deploymentParams.description = app.getDescription();
            deploymentParams.enabled = Boolean.valueOf(app.getEnabled()) != false && appRef != null && Boolean.valueOf(appRef.getEnabled()) != false ? Boolean.TRUE : Boolean.FALSE;
            deploymentParams.contextroot = app.getContextRoot();
            deploymentParams.libraries = app.getLibraries();
            deploymentParams.availabilityenabled = Boolean.parseBoolean(app.getAvailabilityEnabled());
            deploymentParams.asyncreplication = Boolean.parseBoolean(app.getAsyncReplication());
            if (appRef != null) {
                deploymentParams.virtualservers = appRef.getVirtualServers();
            }
            return deploymentParams;
        }

        public static Map<String, Properties> getModulePropertiesMap(Application me) {
            HashMap<String, Properties> modulePropertiesMap = new HashMap<String, Properties>();
            for (Module module : me.getModule()) {
                if (module.getProperty() == null) continue;
                Properties moduleProps = new Properties();
                for (Property property : module.getProperty()) {
                    moduleProps.put(property.getName(), property.getValue());
                }
                modulePropertiesMap.put(module.getName(), moduleProps);
            }
            return modulePropertiesMap;
        }

        public static boolean isStandaloneModule(Application me) {
            return Boolean.valueOf(me.getDeployProperties().getProperty("isComposite")) == false;
        }

        public static boolean containsSnifferType(Application app, String snifferType) {
            ArrayList<Engine> engineList = new ArrayList<Engine>();
            engineList.addAll(app.getEngine());
            for (Module module : app.getModule()) {
                engineList.addAll(module.getEngines());
            }
            for (Engine engine : engineList) {
                if (!engine.getSniffer().equals(snifferType)) continue;
                return true;
            }
            return false;
        }

        public static File application(Application instance) {
            return Duck.fileForProp(instance, Application.APP_LOCATION_PROP_NAME);
        }

        public static File deploymentPlan(Application instance) {
            return Duck.fileForProp(instance, Application.DEPLOYMENT_PLAN_LOCATION_PROP_NAME);
        }

        private static File fileForProp(Application instance, String propName) {
            for (Property p : instance.getProperty()) {
                if (!p.getName().equals(propName)) continue;
                return new File(URI.create(p.getValue()));
            }
            return null;
        }
    }
}

