/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.VersioningDeploymentException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="undeploy")
@I18n(value="undeploy.command")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class UndeployCommand
extends UndeployCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UndeployCommand.class);
    @Inject
    Deployment deployment;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Applications apps;
    @Inject
    VersioningService versioningService;
    @Inject
    ServerEnvironment env;
    @Inject
    Domain domain;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Habitat habitat;

    public UndeployCommand() {
        this.origin = OpsParams.Origin.undeploy;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        this.name = new File(this.name).getName();
        List matchedVersions = null;
        try {
            matchedVersions = this.versioningService.getMatchedVersions(this.name, this.target);
        }
        catch (VersioningDeploymentException e) {
            if (this.env.isDas()) {
                report.failure(logger, e.getMessage());
            } else {
                logger.fine(e.getMessage());
            }
            return;
        }
        if (matchedVersions.isEmpty()) {
            if (this.env.isDas()) {
                report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", new Object[]{this.name, this.target}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            } else {
                logger.fine(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", new Object[]{this.name, this.target}));
            }
            return;
        }
        for (String appName : matchedVersions) {
            ApplicationRef ref;
            ApplicationInfo info = this.deployment.get(appName);
            Application application = (Application)this.apps.getModule(Application.class, appName);
            if (application == null) {
                report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{appName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            this.deployment.validateUndeploymentTarget(this.target, appName);
            if (!DeploymentUtils.isDomainTarget((String)this.target) && (ref = this.domain.getApplicationRefInTarget(appName, this.target)) == null) {
                report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", new Object[]{appName, this.target}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ReadableArchive source = null;
            if (info == null) {
                if (application != null) {
                    URI uri = null;
                    try {
                        uri = new URI(application.getLocation());
                    }
                    catch (URISyntaxException e) {
                        logger.severe("Cannot determine original location for application : " + e.getMessage());
                    }
                    if (uri != null) {
                        File location = new File(uri);
                        if (location.exists()) {
                            try {
                                source = this.archiveFactory.openArchive(location);
                            }
                            catch (IOException e) {
                                logger.log(Level.INFO, e.getMessage(), e);
                            }
                        } else {
                            logger.warning("Originally deployed application at " + location + " not found");
                        }
                    }
                }
            } else {
                source = info.getSource();
            }
            if (source == null) {
                logger.fine("Cannot get source archive for undeployment");
                try {
                    this.deployment.unregisterAppFromDomainXML(appName, this.target);
                }
                catch (TransactionFailure e) {
                    logger.warning("Module " + appName + " not found in configuration");
                }
                return;
            }
            File sourceFile = new File(source.getURI());
            if (!source.exists()) {
                logger.log(Level.WARNING, "Cannot find application bits at " + sourceFile.getPath());
                try {
                    this.deployment.unregisterAppFromDomainXML(appName, this.target);
                }
                catch (TransactionFailure e) {
                    logger.warning("Module " + appName + " not found in configuration");
                }
                return;
            }
            this.name = appName;
            if (this.env.isDas()) {
                CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("disable", report);
                try {
                    ParameterMapExtractor extractor = new ParameterMapExtractor(new Object[]{this});
                    ParameterMap parameters = extractor.extract((Collection)Collections.EMPTY_LIST);
                    parameters.set((Object)"DEFAULT", (Object)appName);
                    parameters.add((Object)"isUndeploy", (Object)Boolean.TRUE.toString());
                    inv.parameters(parameters).execute();
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                        report.setMessage(localStrings.getLocalString("disable.command.failed", "{0} disabled failed", new Object[]{appName}));
                        return;
                    }
                    if (DeploymentUtils.isDomainTarget((String)this.target)) {
                        List targets = this.domain.getAllReferencedTargetsForApplication(appName);
                        parameters.remove((Object)"isUndeploy");
                        ClusterOperationUtil.replicateCommand((String)"undeploy", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, (Collection)targets, (AdminCommandContext)context, (ParameterMap)parameters, (Habitat)this.habitat);
                    }
                }
                catch (Exception e) {
                    report.failure(logger, e.getMessage());
                    return;
                }
            }
            ExtendedDeploymentContext deploymentContext = null;
            try {
                deploymentContext = this.deployment.getBuilder(logger, (OpsParams)this, report).source(source).build();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Cannot create context for undeployment ", e);
                report.setMessage(localStrings.getLocalString("undeploy.contextcreation.failed", "Cannot create context for undeployment : {0} ", new Object[]{e.getMessage()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            Properties appProps = deploymentContext.getAppProps();
            appProps.putAll((Map<?, ?>)application.getDeployProperties());
            if (this.properties != null) {
                appProps.putAll((Map<?, ?>)this.properties);
            }
            Artifacts generatedArtifacts = DeploymentUtils.generatedArtifacts((Application)application);
            generatedArtifacts.record((DeploymentContext)deploymentContext);
            deploymentContext.setModulePropsMap(application.getModulePropertiesMap());
            if (info != null) {
                this.deployment.undeploy(appName, deploymentContext);
            }
            boolean isDirectoryDeployed = false;
            if (application != null) {
                isDirectoryDeployed = Boolean.valueOf(application.getDirectoryDeployed());
            }
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) continue;
            try {
                this.deployment.unregisterAppFromDomainXML(appName, this.target);
            }
            catch (TransactionFailure e) {
                logger.warning("Module " + appName + " not found in configuration");
            }
            deploymentContext.clean();
            if (source == null || this.keepreposdir.booleanValue() || isDirectoryDeployed || !source.exists()) continue;
            FileUtils.whack((File)new File(source.getURI()));
        }
    }
}

