/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.server.logging.GFFileHandler;
import com.sun.enterprise.server.logging.logviewer.backend.LogFilterForInstance;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Cluster(value={RuntimeType.DAS})
@Service(name="collect-log-files")
@Scoped(value=PerLookup.class)
@I18n(value="collect.log.files")
public class CollectLogFiles
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CollectLogFiles.class);
    private static final Logger logger = LogDomains.getLogger(CollectLogFiles.class, (String)"javax.enterprise.system.core");
    @Param(optional=true)
    String target = "server";
    @Param
    private String outputFilePath;
    @Inject
    Domain domain;
    @Inject
    private Habitat habitat;
    @Inject
    GFFileHandler gf;
    @Inject
    LoggingConfigImpl loggingConfig;
    boolean zipDone = false;

    public void execute(AdminCommandContext context) {
        try {
            boolean created;
            ActionReport report = context.getActionReport();
            Properties props = this.initFileXferProps();
            Server targetServer = this.domain.getServerNamed(this.target);
            ArrayList instancesForReplication = new ArrayList();
            File outputFile = new File(this.outputFilePath);
            if (!outputFile.exists() && !(created = outputFile.mkdir())) {
                String errorMsg = localStrings.getLocalString("outputPath.notexist", "Outputfilepath Doen not exists. Please enter correct value for Outputfilepath.");
                report.setMessage(errorMsg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            if (targetServer != null && targetServer.isDas()) {
                int bytesRead;
                File file = new File(this.outputFilePath + File.separator + "server");
                file.mkdir();
                File logFile = this.gf.getCurrentLogFile();
                File toFile = new File(file, logFile.getName());
                FileInputStream from = null;
                FileOutputStream to = null;
                from = new FileInputStream(logFile);
                to = new FileOutputStream(toFile);
                byte[] buffer = new byte[4096];
                while ((bytesRead = from.read(buffer)) != -1) {
                    to.write(buffer, 0, bytesRead);
                }
                if (!toFile.exists()) {
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                }
                try {
                    String zipFile = this.loggingConfig.createZipFile(outputFile.getAbsolutePath());
                    if (zipFile == null || new File(zipFile) == null) {
                        String errorMsg = localStrings.getLocalString("download.errDownloading", "Error while creating zip file.");
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setMessage(errorMsg);
                    }
                }
                catch (Exception e) {
                    String errorMsg = localStrings.getLocalString("download.errDownloading", "Error while creating zip file.");
                    logger.log(Level.SEVERE, errorMsg, e);
                    report.setMessage(errorMsg);
                    report.setFailureCause(e);
                }
            } else {
                File tempDirectory = File.createTempFile("downloaded", "log");
                tempDirectory.delete();
                tempDirectory.mkdirs();
                com.sun.enterprise.config.serverbeans.Cluster cluster = this.domain.getClusterNamed(this.target);
                List instances = cluster.getInstances();
                for (Server instance : instances) {
                    String instanceName = instance.getName();
                    new LogFilterForInstance().getInstanceLogFile(this.habitat, instance, this.domain, logger, instanceName, tempDirectory.getAbsolutePath());
                }
                String zipFileName = this.loggingConfig.createZipFile(tempDirectory.getAbsolutePath());
                Payload.Outbound outboundPayload = context.getOutboundPayload();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "About to download artifact " + zipFileName);
                }
                File zipFile = new File(zipFileName);
                outboundPayload.attachFile("application/octet-stream", tempDirectory.toURI().relativize(zipFile.toURI()), "files", props, zipFile);
                tempDirectory.delete();
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMsg = localStrings.getLocalString("download.errDownloading", "Error while downloading generated files from one of the Instance.");
            logger.log(Level.SEVERE, errorMsg, e);
            ActionReport report = context.getActionReport();
            boolean reportErrorsInTopReport = false;
            if (!reportErrorsInTopReport) {
                report = report.addSubActionsReport();
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            report.setMessage(errorMsg);
            report.setFailureCause(e);
        }
    }

    private Properties initFileXferProps() {
        Properties props = new Properties();
        props.setProperty("file-xfer-root", this.outputFilePath.replace("\\", "/"));
        return props;
    }
}

