/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-system-properties")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.STANDALONE_INSTANCE})
@I18n(value="create.system.properties")
public class CreateSystemProperties
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateSystemProperties.class);
    @Param(optional=true, defaultValue="server")
    String target;
    @Param(name="name_value", primary=true, separator=58)
    Properties properties;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Domain spb;
        ActionReport report = context.getActionReport();
        Property domainProp = this.domain.getProperty("administrative.domain.name");
        String domainName = domainProp.getValue();
        if ("domain".equals(this.target) || this.target.equals(domainName)) {
            spb = this.domain;
        } else {
            spb = this.domain.getConfigNamed(this.target);
            if (spb == null) {
                spb = this.domain.getClusterNamed(this.target);
            }
            if (spb == null) {
                spb = this.domain.getServerNamed(this.target);
            }
        }
        if (spb == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target:{0}. Valid targets types are domain, config, cluster, default server, clustered instance, stand alone instance", new Object[]{this.target});
            report.setMessage(msg);
            return;
        }
        String sysPropName = "";
        try {
            for (Object key : this.properties.keySet()) {
                String propName;
                sysPropName = propName = (String)key;
                ConfigSupport.apply(new SingleConfigCode<SystemPropertyBag>(){

                    @Override
                    public Object run(SystemPropertyBag param) throws PropertyVetoException, TransactionFailure {
                        for (SystemProperty sysProperty : param.getSystemProperty()) {
                            if (!sysProperty.getName().equals(propName)) continue;
                            param.getSystemProperty().remove(sysProperty);
                            break;
                        }
                        SystemProperty newSysProp = (SystemProperty)param.createChild(SystemProperty.class);
                        newSysProp.setName(propName);
                        newSysProp.setValue(CreateSystemProperties.this.properties.getProperty(propName));
                        param.getSystemProperty().add(newSysProp);
                        return newSysProp;
                    }
                }, spb);
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.system.properties.failed", "System property {0} creation failed", new Object[]{sysPropName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tfe);
            return;
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.system.properties.failed", "System property {0} creation failed", new Object[]{sysPropName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
    }
}

