/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Proxy;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.external.statistics.impl.StatisticImpl;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.types.Property;

@Service(name="get")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
public class GetCommand
extends V2DottedNameSupport
implements AdminCommand {
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment serverEnv;
    @Inject
    Target targetService;
    @Inject
    Habitat habitat;
    @Param(optional=true, defaultValue="false", shortName="m")
    Boolean monitor;
    @Param(primary=true)
    String pattern;
    @Inject(optional=true)
    private MonitoringRuntimeDataRegistry mrdr;
    private final String DOTTED_NAME = ".dotted-name";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(GetCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PropsFileActionReporter reporter = (PropsFileActionReporter)report;
            reporter.useMainChildrenAttribute(true);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (this.monitor.booleanValue()) {
            this.getMonitorAttributes(report, context);
            return;
        }
        if (!(this.pattern.equals("*") || this.pattern.lastIndexOf(".") != -1 && this.pattern.lastIndexOf(".") != this.pattern.length() - 1)) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(localStrings.getLocalString("missing.dotted.name", "Missing expected dotted name part"));
            return;
        }
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, this.pattern);
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
        }
        String prefix = "";
        if (!this.pattern.startsWith(parentNodes[0].relativeName)) {
            prefix = this.pattern.substring(0, this.pattern.indexOf(parentNodes[0].relativeName));
        }
        this.pattern = parentNodes[0].relativeName;
        Map<Dom, String> matchingNodes = this.getMatchingNodes(dottedNames, this.pattern);
        if (matchingNodes.isEmpty() && this.pattern.lastIndexOf(46) != -1) {
            matchingNodes = this.getMatchingNodes(dottedNames, this.pattern.substring(0, this.pattern.lastIndexOf(".")));
        }
        if (matchingNodes.isEmpty()) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(localStrings.getLocalString("admin.get.path.notfound", "Dotted name path {0} not found.", new Object[]{prefix + this.pattern}));
            return;
        }
        List<Map.Entry> matchingNodesSorted = this.sortNodesByDottedName(matchingNodes);
        matchingNodesSorted = this.applyOverrideRules(matchingNodesSorted);
        boolean foundMatch = false;
        for (Map.Entry node : matchingNodesSorted) {
            if (Property.class.getName().equals(((Dom)node.getKey()).model.targetTypeName)) {
                if (!this.matches((String)node.getValue(), this.pattern)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(prefix + (String)node.getValue() + "=" + this.encode(((Dom)node.getKey()).attribute("value")));
                foundMatch = true;
                continue;
            }
            Map<String, String> attributes = this.getNodeAttributes((Dom)node.getKey(), this.pattern);
            TreeMap<String, String> attributesSorted = new TreeMap<String, String>(attributes);
            for (Map.Entry<String, String> name : attributesSorted.entrySet()) {
                String finalDottedName = (String)node.getValue() + "." + name.getKey();
                if (!this.matches(finalDottedName, this.pattern)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(prefix + (String)node.getValue() + "." + name.getKey() + "=" + name.getValue());
                foundMatch = true;
            }
        }
        if (!foundMatch) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(localStrings.getLocalString("admin.get.path.notfound", "Dotted name path {0} not found.", new Object[]{prefix + this.pattern}));
        }
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private void getMonitorAttributes(ActionReport report, AdminCommandContext ctxt) {
        TreeNode parent;
        if (this.pattern == null || this.pattern.equals("")) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("match pattern is invalid or null");
            report.setMessage(localStrings.getLocalString("admin.get.invalid.pattern", "Match pattern is invalid or null"));
            return;
        }
        if (this.mrdr == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(localStrings.getLocalString("admin.get.no.monitoring", "Monitoring facility not installed"));
            return;
        }
        String targetName = this.pattern.indexOf(".") == -1 ? this.pattern : this.pattern.substring(0, this.pattern.indexOf("."));
        if (this.serverEnv.isDas() && !this.serverEnv.getInstanceName().equals(targetName)) {
            this.callInstance(report, ctxt, targetName);
            return;
        }
        TreeNode tn = this.mrdr.get(targetName = targetName.equals("*") ? this.serverEnv.getInstanceName() : targetName);
        if (tn == null) {
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
        TreeMap map = new TreeMap();
        ArrayList<TreeNode> ltn = tn.getNodes(this.pattern);
        boolean singleStat = false;
        if ((ltn == null || ltn.isEmpty()) && (parent = tn.getPossibleParentNode(this.pattern)) != null) {
            ltn = new ArrayList<TreeNode>(1);
            ltn.add(parent);
            singleStat = true;
        }
        if (!singleStat) {
            this.pattern = null;
        }
        for (TreeNode tn1 : this.sortTreeNodesByCompletePathName((List<TreeNode>)ltn)) {
            if (tn1.hasChildNodes()) continue;
            this.insertNameValuePairs(map, tn1, this.pattern);
        }
        for (Object obj : map.keySet()) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(obj + " = " + map.get(obj));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void insertNameValuePairs(TreeMap map, TreeNode tn1, String exactMatch) {
        String name = tn1.getCompletePathName();
        Object value = tn1.getValue();
        if (tn1.getParent() != null) {
            map.put(tn1.getParent().getCompletePathName() + ".dotted-name", tn1.getParent().getCompletePathName());
        }
        if (value instanceof Stats) {
            for (Statistic s : ((Stats)value).getStatistics()) {
                String statisticName = s.getName();
                if (statisticName != null) {
                    statisticName = s.getName().toLowerCase();
                }
                this.addStatisticInfo(s, name + "." + statisticName, map);
            }
        } else if (value instanceof Statistic) {
            this.addStatisticInfo(value, name, map);
        } else {
            map.put(name, value);
        }
        if (exactMatch != null) {
            Object val = map.get(exactMatch);
            map.clear();
            if (val != null) {
                map.put(exactMatch, val);
            }
        }
    }

    private void addStatisticInfo(Object value, String name, TreeMap map) {
        Map statsMap = Proxy.isProxyClass(value.getClass()) ? ((StatisticImpl)Proxy.getInvocationHandler(value)).getStaticAsMap() : ((StatisticImpl)value).getStaticAsMap();
        for (String attrName : statsMap.keySet()) {
            Object attrValue = statsMap.get(attrName);
            map.put(name + "-" + attrName, attrValue);
        }
    }

    public void callInstance(ActionReport report, AdminCommandContext context, String targetName) {
        try {
            ParameterMap paramMap = new ParameterMap();
            paramMap.set("monitor", "true");
            paramMap.set("DEFAULT", this.pattern);
            List targetList = targetName.equals("*") ? this.targetService.getAllInstances() : this.targetService.getInstances(targetName);
            ClusterOperationUtil.replicateCommand((String)"get", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, (List)targetList, (AdminCommandContext)context, (ParameterMap)paramMap, (Habitat)this.habitat);
        }
        catch (Exception ex) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Failure while trying get details from instance " + targetName);
        }
    }
}

