/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.util;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.net.NetUtils;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import org.jvnet.hk2.config.TransactionFailure;

public class PortBaseHelper {
    public static final int PORT_MAX_VAL = 65535;
    public static final int PORTBASE_ADMINPORT_SUFFIX = 48;
    public static final int PORTBASE_HTTPSSL_SUFFIX = 81;
    public static final int PORTBASE_IIOPSSL_SUFFIX = 38;
    public static final int PORTBASE_IIOPMUTUALAUTH_SUFFIX = 39;
    public static final int PORTBASE_INSTANCE_SUFFIX = 80;
    public static final int PORTBASE_JMS_SUFFIX = 76;
    public static final int PORTBASE_IIOP_SUFFIX = 37;
    public static final int PORTBASE_JMX_SUFFIX = 86;
    public static final String ADMIN = "ASADMIN_LISTENER_PORT";
    public static final String HTTP = "HTTP_LISTENER_PORT";
    public static final String HTTPS = "HTTP_SSL_LISTENER_PORT";
    public static final String IIOP = "IIOP_LISTENER_PORT";
    public static final String IIOPM = "IIOP_SSL_MUTUALAUTH_PORT";
    public static final String IIOPS = "IIOP_SSL_LISTENER_PORT";
    public static final String JMS = "JMS_PROVIDER_PORT";
    public static final String JMX = "JMX_SYSTEM_CONNECTOR_PORT";
    private static final LocalStringsImpl strings = new LocalStringsImpl(PortBaseHelper.class);
    private String portBase;
    private boolean checkPorts;
    private String adminPort;
    private String instancePort;
    private String httpsPort;
    private String iiopPort;
    private String iiopmPort;
    private String iiopsPort;
    private String jmsPort;
    private String jmxPort;
    private Logger _logger;
    private Server _server;

    public PortBaseHelper(Server instance, String portbase, boolean checkports, Logger logger) {
        this.portBase = portbase;
        this.checkPorts = checkports;
        this._logger = logger;
        this._server = instance;
    }

    public void verifyPortBase() throws TransactionFailure {
        if (this.usePortBase()) {
            int portbase = this.convertPortStr(this.portBase);
            this.setOptionsWithPortBase(portbase);
        }
    }

    public String getAdminPort() {
        return this.adminPort;
    }

    public String getInstancePort() {
        return this.instancePort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public String getIiopPort() {
        return this.iiopPort;
    }

    public String getIiopsPort() {
        return this.iiopsPort;
    }

    public String getIiopmPort() {
        return this.iiopmPort;
    }

    public String getJmsPort() {
        return this.jmsPort;
    }

    public String getJmxPort() {
        return this.jmxPort;
    }

    private int convertPortStr(String port) throws TransactionFailure {
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new TransactionFailure(strings.get("InvalidPortNumber", new Object[]{port}));
        }
    }

    private boolean usePortBase() throws TransactionFailure {
        return this.portBase != null;
    }

    private void setOptionsWithPortBase(int portbase) throws TransactionFailure {
        this.verifyPortBasePortIsValid(ADMIN, portbase + 48);
        this.adminPort = String.valueOf(portbase + 48);
        this.verifyPortBasePortIsValid(HTTP, portbase + 80);
        this.instancePort = String.valueOf(portbase + 80);
        this.verifyPortBasePortIsValid(HTTPS, portbase + 81);
        this.httpsPort = String.valueOf(portbase + 81);
        this.verifyPortBasePortIsValid(IIOPS, portbase + 38);
        this.iiopsPort = String.valueOf(portbase + 38);
        this.verifyPortBasePortIsValid(IIOPM, portbase + 39);
        this.iiopmPort = String.valueOf(portbase + 39);
        this.verifyPortBasePortIsValid(JMS, portbase + 76);
        this.jmsPort = String.valueOf(portbase + 76);
        this.verifyPortBasePortIsValid(IIOP, portbase + 37);
        this.iiopPort = String.valueOf(portbase + 37);
        this.verifyPortBasePortIsValid(JMX, portbase + 86);
        this.jmxPort = String.valueOf(portbase + 86);
    }

    private void verifyPortBasePortIsValid(String portName, int portNum) throws TransactionFailure {
        if (portNum <= 0 || portNum > 65535) {
            throw new TransactionFailure(strings.get("InvalidPortBaseRange", new Object[]{portNum, portName}));
        }
        if (this.checkPorts && !NetUtils.isPortFree((int)portNum)) {
            throw new TransactionFailure(strings.get("PortBasePortInUse", new Object[]{portNum, portName}));
        }
        this._logger.finer("Port =" + portNum);
    }

    public void setPorts() throws TransactionFailure, PropertyVetoException {
        if (this.portBase != null) {
            this.setSystemProperty(ADMIN, this.getAdminPort());
            this.setSystemProperty(HTTP, this.getInstancePort());
            this.setSystemProperty(HTTPS, this.getHttpsPort());
            this.setSystemProperty(IIOP, this.getIiopPort());
            this.setSystemProperty(IIOPM, this.getIiopmPort());
            this.setSystemProperty(IIOPS, this.getIiopsPort());
            this.setSystemProperty(JMS, this.getJmsPort());
            this.setSystemProperty(JMX, this.getJmxPort());
        }
    }

    private void setSystemProperty(String name, String value) throws TransactionFailure, PropertyVetoException {
        SystemProperty sp = this._server.getSystemProperty(name);
        if (sp == null) {
            SystemProperty newSP = this._server.createChild(SystemProperty.class);
            newSP.setName(name);
            newSP.setValue(value);
            this._server.getSystemProperty().add(newSP);
        }
    }
}

