/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.module.bootstrap.ModuleStartup;
import org.glassfish.experimentalgfapi.GlassFish;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishImpl
implements GlassFish {
    private ModuleStartup gfKernel;
    private Habitat habitat;
    volatile GlassFish.Status status = GlassFish.Status.INIT;

    public GlassFishImpl(ModuleStartup gfKernel, Habitat habitat) {
        this.gfKernel = gfKernel;
        this.habitat = habitat;
    }

    @Override
    public synchronized void start() {
        if (this.status == GlassFish.Status.STARTED) {
            return;
        }
        try {
            this.status = GlassFish.Status.STARTING;
            this.gfKernel.start();
            this.status = GlassFish.Status.STARTED;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.status != GlassFish.Status.STARTED) {
            return;
        }
        try {
            this.status = GlassFish.Status.STOPPING;
            this.gfKernel.stop();
            this.status = GlassFish.Status.STOPPED;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void dispose() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized GlassFish.Status getStatus() {
        return this.status;
    }

    @Override
    public synchronized <T> T lookupService(Class<T> serviceType, String serviceName) {
        if (this.status != GlassFish.Status.STARTED) {
            throw new IllegalArgumentException("Server is not started yet. It is in " + (Object)((Object)this.status) + "state");
        }
        return serviceName != null ? this.habitat.getComponent(serviceType, serviceName) : this.habitat.getComponent(serviceType);
    }
}

