/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.cli.resources.ResourceFactory;
import org.glassfish.admin.cli.resources.ResourcesManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="add-resources")
@Scoped(value=PerLookup.class)
@I18n(value="add.resources")
public class AddResources
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AddResources.class);
    @Param(optional=true)
    private String target = "server";
    @Param(name="xml_file_name", primary=true)
    private File xmlFile;
    @Inject
    private Resources resources;
    @Inject
    private Domain domain;
    @Inject
    private ResourceFactory resourceFactory;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.xmlFile.exists()) {
            report.setMessage(localStrings.getLocalString("FileNotFound", "The system cannot find the path specified: {0}", this.xmlFile.getName()));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ArrayList results = ResourcesManager.createResources(this.resources, this.xmlFile, this.target, this.resourceFactory);
            Iterator resultsIter = results.iterator();
            report.getTopMessagePart().setChildrenType("Command");
            boolean isSuccess = false;
            while (resultsIter.hasNext()) {
                ResourceStatus rs = (ResourceStatus)resultsIter.next();
                String msgToAdd = rs.getMessage();
                if (msgToAdd != null && !msgToAdd.equals("")) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(msgToAdd);
                }
                if (rs.getStatus() != 0 && !rs.isAlreadyExists()) continue;
                isSuccess = true;
            }
            report.setActionExitCode(isSuccess ? ActionReport.ExitCode.SUCCESS : ActionReport.ExitCode.FAILURE);
            if (!isSuccess) {
                report.setMessage(localStrings.getLocalString("add.resources.failed", "add-resources <{0}> failed", this.xmlFile.getName()));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(AddResources.class.getName()).log(Level.SEVERE, "Something went wrong in add-resources", ex);
            report.setMessage(localStrings.getLocalString("add.resources.failed", "add-resources <{0}> failed", this.xmlFile.getName()));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
        }
    }
}

