/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.util.AbstractAdapter;
import org.glassfish.hk2.classmodel.reflect.util.JarArchive;

public class DirectoryArchive
extends AbstractAdapter {
    public final File directory;

    public DirectoryArchive(File directory) {
        this.directory = directory;
    }

    @Override
    public URI getURI() {
        return this.directory.toURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        File manifest = new File(this.directory, "META-INF/MANIFEST.MF");
        if (manifest.exists()) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(manifest));
            try {
                Manifest manifest2 = new Manifest(is);
                return manifest2;
            }
            finally {
                ((InputStream)is).close();
            }
        }
        return null;
    }

    @Override
    public void onSelectedEntries(ArchiveAdapter.Selector selector, ArchiveAdapter.EntryTask task, Logger logger) throws IOException {
        this.parse(this.directory, selector, task, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(File dir, ArchiveAdapter.Selector selector, ArchiveAdapter.EntryTask task, Logger logger) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(52000);
        for (File f : dir.listFiles()) {
            ArchiveAdapter.Entry ae = new ArchiveAdapter.Entry(this.mangle(f), f.length(), f.isDirectory());
            if (!f.isDirectory()) {
                if (ae.name.endsWith(".jar")) {
                    JarArchive ja = null;
                    try {
                        ja = new JarArchive(f.toURI());
                        ja.onSelectedEntries(selector, task, logger);
                        continue;
                    }
                    finally {
                        ja.close();
                    }
                }
                if (!selector.isSelected(ae)) continue;
                AbstractInterruptibleChannel fc = null;
                try {
                    try {
                        int read;
                        if ((long)buffer.capacity() < f.length()) {
                            buffer = ByteBuffer.allocate((int)f.length());
                        }
                        if ((long)(read = ((FileChannel)(fc = new FileInputStream(f).getChannel())).read(buffer)) != f.length()) {
                            logger.severe("Incorrect file length while reading " + f.getName() + " of size " + f.length() + " reported is " + read);
                        }
                        buffer.rewind();
                        task.on(ae, buffer.array());
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Exception while processing " + f.getName() + " of size " + f.length(), e);
                    }
                    continue;
                }
                finally {
                    if (fc != null) {
                        fc.close();
                    }
                }
            }
            this.parse(f, selector, task, logger);
        }
    }

    private String mangle(File f) {
        String relativePath = f.getAbsolutePath().substring(this.directory.getAbsolutePath().length() + 1);
        return relativePath.replace(File.separatorChar, '/');
    }

    @Override
    public void close() throws IOException {
    }
}

