/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.internal.runlevel;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.LazyInhabitant;
import com.sun.hk2.component.RunLevelInhabitant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.HabitatListener;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.RunLevelListener;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.RunLevelState;
import org.jvnet.hk2.component.ServiceContext;
import org.jvnet.hk2.component.internal.runlevel.Recorder;
import org.jvnet.hk2.component.internal.runlevel.RunLevelServiceStub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRunLevelService
implements RunLevelService<Void>,
RunLevelState<Void>,
InhabitantListener,
HabitatListener {
    static final boolean ASYNC_ENABLED = false;
    private final boolean asyncMode;
    private final Class<?> targetEnv;
    private ExecutorService exec;
    private final Habitat habitat;
    private RunLevelState<Void> delegate;
    private Integer current;
    private Integer planned;
    private final HashMap<Integer, Recorder> recorders;
    private Recorder activeRecorder;
    private Integer activeRunLevel;
    private Boolean upSide;
    private boolean cancelIssued;
    private Future<?> activeProceedToOp;

    public DefaultRunLevelService(Habitat habitat) {
        this(habitat, false, Void.class, new LinkedHashMap<Integer, Recorder>());
    }

    DefaultRunLevelService(Habitat habitat, boolean async, Class<?> targetEnv, HashMap<Integer, Recorder> recorders) {
        this.habitat = habitat;
        assert (null != habitat);
        this.asyncMode = async;
        if (this.asyncMode) {
            this.exec = Executors.newSingleThreadExecutor(new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    RunLevelServiceThread t = new RunLevelServiceThread(runnable);
                    return t;
                }
            });
        }
        this.targetEnv = targetEnv;
        this.recorders = recorders;
        habitat.addHabitatListener(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.current + ", " + this.planned + ", " + this.delegate + ")";
    }

    @Override
    public synchronized void proceedTo(final int runLevel) {
        if (runLevel < -1) {
            throw new IllegalArgumentException();
        }
        this.handleInterrupt(runLevel);
        this.planned = runLevel;
        if (null != this.exec) {
            this.activeProceedToOp = this.exec.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DefaultRunLevelService.this.proceedToWorker(runLevel);
                    if (Thread.currentThread().isInterrupted()) {
                        DefaultRunLevelService.this.notify(ListenerEvent.CANCEL, null, null);
                    } else {
                        DefaultRunLevelService defaultRunLevelService = DefaultRunLevelService.this;
                        synchronized (defaultRunLevelService) {
                            DefaultRunLevelService.this.notifyAll();
                        }
                    }
                }
            });
        } else {
            this.proceedToWorker(runLevel);
        }
    }

    protected void handleInterrupt(int runLevel) throws Interrupt {
        if (null != this.activeProceedToOp) {
            Logger.getAnonymousLogger().log(Level.INFO, "Cancelling activation to runLevel {0} and instead proceeding to {1}", new Object[]{this.planned, runLevel});
            this.activeProceedToOp.cancel(true);
            this.reset();
        } else if (null != this.planned) {
            if (!this.cancelIssued) {
                this.cancelIssued = true;
                this.notify(ListenerEvent.CANCEL, null, null);
            }
            this.reset();
            throw new Interrupt(runLevel);
        }
    }

    private void proceedToWorker(int runLevel) {
        try {
            int current;
            int n = current = null == this.getCurrentRunLevel() ? -2 : this.getCurrentRunLevel();
            if (runLevel > current) {
                for (int rl = current + 1; rl <= runLevel; ++rl) {
                    this.upActiveRecorder(rl);
                }
            } else if (runLevel < current) {
                for (int rl = current; rl > runLevel; --rl) {
                    this.downActiveRecorder(rl);
                }
            } else {
                this.downActiveRecorder(runLevel + 1);
            }
        }
        catch (Interrupt interrupt) {
            this.proceedToWorker(interrupt.runLevel);
        }
    }

    private void reset() {
        this.activeRecorder = null;
        this.upSide = null;
        this.activeRunLevel = null;
        this.planned = null;
        this.activeProceedToOp = null;
        this.cancelIssued = false;
    }

    private synchronized void upActiveRecorder(int runLevel) {
        this.upSide = true;
        this.activeRunLevel = runLevel;
        this.activateRunLevel();
        this.current = runLevel;
        this.activeRunLevel = null;
        if (this.planned == this.current) {
            this.reset();
        } else {
            this.activeRecorder = null;
        }
        this.notify(ListenerEvent.PROGRESS, null, null);
    }

    protected void activateRunLevel() {
        Collection<Inhabitant<?>> runLevelInhabitants = this.habitat.getAllInhabitantsByContract(RunLevel.class.getName());
        for (Inhabitant<?> i : runLevelInhabitants) {
            RunLevel rl;
            AbstractInhabitantImpl ai = (AbstractInhabitantImpl)AbstractInhabitantImpl.class.cast(i);
            if (!this.accept(ai, rl = ai.getAnnotation(RunLevel.class))) continue;
            RunLevelInhabitant rli = (RunLevelInhabitant)RunLevelInhabitant.class.cast(ai);
            this.checkBinding(rli);
            Logger.getAnonymousLogger().log(Level.FINE, "activating {0}", rli);
            try {
                rli.get();
                assert (rli.isInstantiated());
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "exception caught from activation: " + rli, e);
                this.notify(ListenerEvent.ERROR, this.serviceContext(e, rli), e);
            }
        }
    }

    protected boolean accept(Inhabitant<?> i, RunLevel rl) {
        return rl.value() == this.activeRunLevel.intValue() && rl.environment() == this.targetEnv;
    }

    protected void checkBinding(RunLevelInhabitant<?, ?> rli) {
        RunLevelState<?> state = rli.getState();
        if (state != this && RunLevelServiceStub.class.isInstance(state)) {
            RunLevelService delegate = ((RunLevelServiceStub)state).getDelegate();
            if (null != delegate) {
                assert (this == delegate);
            } else {
                ((RunLevelServiceStub)state).activate(this);
            }
        }
    }

    private synchronized void downActiveRecorder(int runLevel) {
        this.upSide = false;
        this.activeRunLevel = runLevel;
        List<Integer> downRecorders = this.getRecordersToRelease(this.recorders, runLevel);
        for (int current : downRecorders) {
            Recorder downRecorder = this.recorders.remove(current);
            if (null == downRecorder) continue;
            int pos = downRecorder.activations.size();
            while (--pos >= 0) {
                Inhabitant<?> i = downRecorder.activations.get(pos);
                try {
                    i.release();
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.WARNING, "exception caught during release: " + i, e);
                    this.notify(ListenerEvent.ERROR, this.serviceContext(e, i), e);
                }
            }
            downRecorder.activations.clear();
        }
        this.current = runLevel - 1;
        if (this.planned == this.current) {
            this.reset();
        } else {
            this.activeRunLevel = null;
        }
        this.notify(ListenerEvent.PROGRESS, null, null);
    }

    protected List<Integer> getRecordersToRelease(HashMap<Integer, Recorder> list, int runLevel) {
        ArrayList<Integer> qualifying = new ArrayList<Integer>();
        for (Map.Entry<Integer, Recorder> entry : this.recorders.entrySet()) {
            if (entry.getKey() < runLevel) continue;
            qualifying.add(entry.getKey());
        }
        Collections.sort(qualifying);
        Collections.reverse(qualifying);
        return qualifying;
    }

    private void notify(ListenerEvent event, ServiceContext context, Throwable error) {
        Interrupt lastInterrupt = null;
        Collection<RunLevelListener> activeListeners = this.habitat.getAllByContract(RunLevelListener.class);
        for (RunLevelListener listener : activeListeners) {
            try {
                if (ListenerEvent.PROGRESS == event) {
                    listener.onProgress(this);
                    continue;
                }
                if (ListenerEvent.CANCEL == event) {
                    listener.onCancelled(this, this.current);
                    continue;
                }
                listener.onError(this, context, error, true);
            }
            catch (Interrupt interrupt) {
                lastInterrupt = interrupt;
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "exception caught from listener", e);
            }
        }
        if (null != lastInterrupt) {
            throw lastInterrupt;
        }
    }

    private ServiceContext serviceContext(Exception e, final Inhabitant<?> i) {
        ServiceContext ctx = null;
        if (e instanceof ComponentException) {
            ctx = ((ComponentException)e).getFailureContext();
        }
        if (null == ctx) {
            ctx = new ServiceContext(){

                @Override
                public ClassLoader getClassLoader() {
                    ClassLoader cl = LazyInhabitant.class.isInstance(i) ? ((LazyInhabitant)i).getClassLoader() : i.getClass().getClassLoader();
                    return cl;
                }

                @Override
                public Inhabitant<?> getInhabitant() {
                    return i;
                }

                @Override
                public String getType() {
                    return i.typeName();
                }

                public String toString() {
                    return i.toString();
                }
            };
        }
        return ctx;
    }

    void setDelegate(RunLevelState<Void> stateProvider) {
        assert (this != stateProvider);
        assert (this.getEnvironment() == stateProvider.getEnvironment());
        this.delegate = stateProvider;
    }

    @Override
    public RunLevelState<Void> getState() {
        return null == this.delegate ? this : this.delegate;
    }

    @Override
    public Class getEnvironment() {
        return null == this.delegate ? this.targetEnv : this.delegate.getEnvironment();
    }

    @Override
    public Integer getCurrentRunLevel() {
        return null == this.delegate ? this.current : this.delegate.getCurrentRunLevel();
    }

    @Override
    public Integer getPlannedRunLevel() {
        return null == this.delegate ? this.planned : this.delegate.getPlannedRunLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inhabitantChanged(InhabitantListener.EventType eventType, Inhabitant<?> inhabitant) {
        if (InhabitantListener.class.isInstance(this.delegate)) {
            return ((InhabitantListener)InhabitantListener.class.cast(this.delegate)).inhabitantChanged(eventType, inhabitant);
        }
        if (null == this.activeRunLevel) {
            throw new ComponentException("problem: " + inhabitant);
        }
        if (this.upSide.booleanValue() && InhabitantListener.EventType.INHABITANT_ACTIVATED != eventType || !this.upSide.booleanValue() && InhabitantListener.EventType.INHABITANT_RELEASED != eventType) {
            throw new ComponentException("problem: " + inhabitant);
        }
        if (this.upSide.booleanValue()) {
            DefaultRunLevelService defaultRunLevelService = this;
            synchronized (defaultRunLevelService) {
                if (null == this.activeRecorder) {
                    this.activeRecorder = new Recorder(this.activeRunLevel, this.targetEnv);
                    if (null != this.recorders.put(this.activeRunLevel, this.activeRecorder)) {
                        throw new AssertionError((Object)"bad state");
                    }
                }
            }
        }
        if (null != this.activeRecorder) {
            this.activeRecorder.inhabitantChanged(eventType, inhabitant);
        }
        return true;
    }

    @Override
    public boolean inhabitantChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant) {
        if (HabitatListener.EventType.HABITAT_INITIALIZED == eventType) {
            this.proceedTo(-1);
        }
        return !habitat.isInitialized();
    }

    @Override
    public boolean inhabitantIndexChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant, String index, String name, Object service) {
        return true;
    }

    private static class Interrupt
    extends RuntimeException {
        private int runLevel;

        private Interrupt(int runLevel) {
            this.runLevel = runLevel;
        }
    }

    private static class RunLevelServiceThread
    extends Thread {
        private RunLevelServiceThread(Runnable r) {
            super(r);
            this.setDaemon(true);
            this.setName(this.getClass().getSimpleName() + "-" + System.identityHashCode(this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ListenerEvent {
        PROGRESS,
        CANCEL,
        ERROR;

    }
}

