/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.jvnet.hk2.component.Habitat;

public class LogFilterForInstance {
    public File downloadGivenInstanceLogFile(Habitat habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String domainRoot, String logFileName) throws IOException {
        int i;
        File instanceLogFile = null;
        SSHLauncher sshL = this.getSSHL(habitat);
        String sNode = targetServer.getNode();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        sshL.init(node, logger);
        SFTPClient sftpClient = sshL.getSFTPClient();
        File logFileDirectoryOnServer = new File(domainRoot + File.separator + "logs" + File.separator + instanceName);
        if (logFileDirectoryOnServer.exists()) {
            logFileDirectoryOnServer.delete();
        }
        logFileDirectoryOnServer.mkdirs();
        instanceLogFile = new File(logFileDirectoryOnServer.getAbsolutePath() + File.separator + logFileName);
        InputStream inputStream = sftpClient.read(node.getInstallDir() + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" + File.separator + logFileName);
        BufferedInputStream in = new BufferedInputStream(inputStream);
        FileOutputStream file = new FileOutputStream(instanceLogFile);
        BufferedOutputStream out = new BufferedOutputStream(file);
        while ((i = in.read()) != -1) {
            out.write(i);
        }
        out.flush();
        return instanceLogFile;
    }

    public void downloadAllInstanceLogFiles(Habitat habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String tempDirectoryOnServer) throws IOException {
        SSHLauncher sshL = this.getSSHL(habitat);
        String sNode = targetServer.getNode();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        sshL.init(node, logger);
        SCPClient scpClient = sshL.getSCPClient();
        Vector allInstanceLogFileName = this.getInstanceLogFileNames(habitat, targetServer, domain, logger, instanceName);
        File logFileDirectoryOnServer = new File(tempDirectoryOnServer + File.separator + "logs" + File.separator + instanceName);
        if (logFileDirectoryOnServer.exists()) {
            logFileDirectoryOnServer.delete();
        }
        logFileDirectoryOnServer.mkdirs();
        String[] remoteFileNames = new String[allInstanceLogFileName.size()];
        for (int i = 0; i < allInstanceLogFileName.size(); ++i) {
            remoteFileNames[i] = node.getInstallDir() + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" + File.separator + ((SFTPv3DirectoryEntry)allInstanceLogFileName.get((int)i)).filename;
        }
        scpClient.get(remoteFileNames, logFileDirectoryOnServer.getAbsolutePath());
    }

    public Vector getInstanceLogFileNames(Habitat habitat, Server targetServer, Domain domain, Logger logger, String instanceName) throws IOException {
        SSHLauncher sshL = this.getSSHL(habitat);
        String sNode = targetServer.getNode();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        sshL.init(node, logger);
        SFTPClient sftpClient = sshL.getSFTPClient();
        Vector instanceLogFileNames = sftpClient.ls(node.getInstallDir() + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs");
        for (int i = 0; i < instanceLogFileNames.size(); ++i) {
            String fileName = ((SFTPv3DirectoryEntry)instanceLogFileNames.get((int)i)).filename;
            if (!fileName.equals(".") && !fileName.equals("..")) continue;
            instanceLogFileNames.remove(i);
            --i;
        }
        return instanceLogFileNames;
    }

    private SSHLauncher getSSHL(Habitat habitat) throws IOException {
        SSHLauncher sshL = null;
        try {
            sshL = (SSHLauncher)habitat.getComponent(SSHLauncher.class);
        }
        catch (NoClassDefFoundError ex) {
            throw new IOException(ex);
        }
        return sshL;
    }
}

