/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.aggregation;

import com.sun.btrace.aggregation.AggregationValue;
import com.sun.btrace.aggregation.HistogramData;
import java.util.concurrent.atomic.AtomicLong;

class Quantize
implements AggregationValue {
    private static final int ZERO_INDEX = 32;
    private AtomicLong[] buckets = new AtomicLong[64];

    public Quantize() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new AtomicLong();
        }
    }

    @Override
    public void add(long data) {
        int pos = Quantize.getBucketIndex(data);
        this.buckets[pos].incrementAndGet();
    }

    private static int logBase2(long value) {
        int pos = 0;
        if (value >= 65536L) {
            value >>= 16;
            pos += 16;
        }
        if (value >= 256L) {
            value >>= 8;
            pos += 8;
        }
        if (value >= 16L) {
            value >>= 4;
            pos += 4;
        }
        if (value >= 4L) {
            value >>= 2;
            pos += 2;
        }
        if (value >= 2L) {
            ++pos;
        }
        return pos;
    }

    @Override
    public long getValue() {
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            long value = this.buckets[i].get();
            if (value <= 0L) continue;
            return Quantize.getBucketLabel(i);
        }
        return 0L;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].set(0L);
        }
    }

    @Override
    public HistogramData getData() {
        int minIndex = this.buckets.length;
        int maxIndex = -1;
        for (int i = 0; i < this.buckets.length; ++i) {
            if (this.buckets[i].get() == 0L) continue;
            minIndex = Math.min(i, minIndex);
            maxIndex = Math.max(i, maxIndex);
        }
        if (minIndex > maxIndex) {
            return null;
        }
        if (maxIndex < this.buckets.length - 1) {
            ++maxIndex;
        }
        if (minIndex > 0) {
            --minIndex;
        }
        int rows = maxIndex - minIndex + 1;
        long[] values = new long[rows];
        long[] counts = new long[rows];
        for (int i = 0; i < rows; ++i) {
            values[i] = Quantize.getBucketLabel(minIndex + i);
            counts[i] = this.buckets[minIndex + i].get();
        }
        return new HistogramData(values, counts);
    }

    private static int getBucketIndex(long data) {
        if (data == 0L) {
            return 32;
        }
        if (data > 0L) {
            return 33 + Quantize.logBase2(data);
        }
        if (data == Integer.MIN_VALUE) {
            return 0;
        }
        return 31 - Quantize.logBase2(0L - data);
    }

    private static long getBucketLabel(int index) {
        if (index == 32) {
            return 0L;
        }
        if (index == 0) {
            return Long.MIN_VALUE;
        }
        if (index > 32) {
            index = index - 32 - 1;
            return 1 << index;
        }
        index = 32 - index - 1;
        return 0 - (1 << index);
    }
}

