/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantFilter;
import org.jvnet.hk2.component.InhabitantTrackerContext;
import org.jvnet.hk2.component.InhabitantTrackerContextImpl;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.matcher.SimpleLdapMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InhabitantTrackerContextBuilder {
    private InhabitantFilter filter;
    private Boolean presence;
    private Set<String> classNames;

    protected InhabitantTrackerContextBuilder() {
    }

    public static InhabitantTrackerContextBuilder create(Habitat h) {
        return new InhabitantTrackerContextBuilder();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.build() + ")";
    }

    public InhabitantTrackerContextBuilder presence(Boolean presence) {
        this.presence = presence;
        return this;
    }

    public Boolean getPresence() {
        return this.presence;
    }

    public InhabitantTrackerContextBuilder classNames(String ... classNames) {
        this.classNames = new HashSet<String>(Arrays.asList(classNames));
        return this;
    }

    public InhabitantTrackerContextBuilder classNames(Set<String> classNames) {
        this.classNames = new HashSet<String>(classNames);
        return this;
    }

    public Set<String> getClassNames() {
        return Collections.unmodifiableSet(this.classNames);
    }

    public InhabitantTrackerContextBuilder filter(InhabitantFilter filter) {
        this.filter = filter;
        return this;
    }

    public InhabitantFilter getFilter() {
        return this.filter;
    }

    public InhabitantTrackerContextBuilder ldapFilter(String ldapExpression) throws ComponentException {
        SimpleLdapMatcher matcher = SimpleLdapMatcher.create(ldapExpression);
        Set<String> classNames = matcher.getTheAndSetFor("objectclass", true);
        if (classNames.isEmpty()) {
            throw new IllegalArgumentException("invalid expression");
        }
        for (String item : classNames) {
            if (!this.hasWildcard(item)) continue;
            throw new ComponentException("no wilcards permitted");
        }
        return this.filter(new AlteredLdapMatcherFilter(matcher)).classNames(classNames);
    }

    protected boolean hasWildcard(String item) {
        return item.indexOf(42) >= 0;
    }

    public InhabitantTrackerContext build() {
        if (null == this.classNames || this.classNames.isEmpty()) {
            throw new IllegalStateException();
        }
        return new InhabitantTrackerContextImpl(this.filter, this.presence, this.classNames);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AlteredLdapMatcherFilter
    implements InhabitantFilter {
        private final SimpleLdapMatcher matcher;

        protected AlteredLdapMatcherFilter(SimpleLdapMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public boolean matches(Inhabitant<?> i) {
            MultiMap<String, String> map = i.metadata();
            if (null == map || map.size() == 0) {
                return true;
            }
            return this.matcher.matches(map);
        }

        public String toString() {
            return this.matcher.toString();
        }
    }
}

