/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.EmbeddedMain;
import com.sun.enterprise.glassfish.bootstrap.NonOSGiGlassFishRuntime;
import com.sun.enterprise.glassfish.bootstrap.SingleHK2Factory;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.simpleglassfishapi.Constants;
import org.glassfish.simpleglassfishapi.GlassFishRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonOSGiGlassFishRuntimeBuilder
implements GlassFishRuntime.RuntimeBuilder {
    private static Logger logger = Util.getLogger();
    private static final String JAR_EXT = ".jar";

    @Override
    public GlassFishRuntime build(Properties properties) throws Exception {
        String installRoot = properties.getProperty("com.sun.aas.installRoot");
        List<URL> moduleJarURLs = this.getModuleJarURLs(installRoot);
        StaticClassLoader cl = new StaticClassLoader(this.getClass().getClassLoader(), moduleJarURLs);
        EmbeddedMain main = new EmbeddedMain();
        SingleHK2Factory.initialize(cl);
        ModulesRegistry modulesRegistry = AbstractFactory.getInstance().createModulesRegistry();
        modulesRegistry.setParentClassLoader(cl);
        NonOSGiGlassFishRuntime glassFishRuntime = new NonOSGiGlassFishRuntime(main);
        logger.logp(Level.FINER, this.getClass().getName(), "build", "Created GlassFishRuntime {0} with Bootstrap Properties {1}", new Object[]{glassFishRuntime, properties});
        return glassFishRuntime;
    }

    @Override
    public boolean handles(Properties properties) {
        try {
            if (!Constants.Platform.Static.toString().equals(properties.getProperty("GlassFish_Platform"))) {
                return false;
            }
            String installRoot = properties.getProperty("com.sun.aas.installRoot");
            String instanceRoot = properties.getProperty("com.sun.aas.instanceRoot");
            if (this.isValidInstallRoot(installRoot)) {
                ASMainHelper.verifyDomainRoot(new File(instanceRoot));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void destroy() throws Exception {
    }

    private List<URL> getModuleJarURLs(String installRoot) {
        File modulesDir = new File(installRoot, "modules/");
        final File autostartModulesDir = new File(modulesDir, "autostart/");
        final ArrayList<URL> moduleJarURLs = new ArrayList<URL>();
        modulesDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory() && !pathname.equals(autostartModulesDir)) {
                    pathname.listFiles(this);
                } else if (pathname.getName().endsWith(NonOSGiGlassFishRuntimeBuilder.JAR_EXT)) {
                    try {
                        moduleJarURLs.add(pathname.toURI().toURL());
                    }
                    catch (Exception ex) {
                        logger.warning(ex.getMessage());
                    }
                }
                return false;
            }
        });
        return moduleJarURLs;
    }

    private boolean isValidInstallRoot(String installRootPath) {
        if (installRootPath == null || !new File(installRootPath).exists()) {
            return false;
        }
        if (!new File(installRootPath, "modules").exists()) {
            return false;
        }
        return new File(installRootPath, "lib/dtds").exists();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StaticClassLoader
    extends URLClassLoader {
        public StaticClassLoader(ClassLoader parent, List<URL> moduleJarURLs) {
            super(moduleJarURLs.toArray(new URL[0]), parent);
        }
    }
}

