/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resource.common;

import java.util.HashMap;
import java.util.Properties;

public class Resource {
    public static final String CUSTOM_RESOURCE = "custom-resource";
    public static final String JDBC_CONNECTION_POOL = "jdbc-connection-pool";
    public static final String CONNECTOR_RESOURCE = "connector-resource";
    public static final String ADMIN_OBJECT_RESOURCE = "admin-object-resource";
    public static final String JDBC_RESOURCE = "jdbc-resource";
    public static final String RESOURCE_ADAPTER_CONFIG = "resource-adapter-config";
    public static final String MAIL_RESOURCE = "mail-resource";
    public static final String EXTERNAL_JNDI_RESOURCE = "external-jndi-resource";
    public static final String CONNECTOR_CONNECTION_POOL = "connector-connection-pool";
    public static final String PERSISTENCE_MANAGER_FACTORY_RESOURCE = "persistence-manager-factory-resource";
    public static final String CONNECTOR_SECURITY_MAP = "security-map";
    public static final String CONNECTOR_WORK_SECURITY_MAP = "work-security-map";
    private String resType;
    private HashMap attrList = new HashMap();
    private Properties props = new Properties();
    private String sDescription = null;

    public Resource(String type) {
        this.resType = type;
    }

    public String getType() {
        return this.resType;
    }

    public HashMap getAttributes() {
        return this.attrList;
    }

    public void setAttribute(String name, String value) {
        this.attrList.put(name, value);
    }

    public void setAttribute(String name, String[] value) {
        this.attrList.put(name, value);
    }

    public void setAttribute(String name, Properties value) {
        this.attrList.put(name, value);
    }

    public void setDescription(String sDescription) {
        this.sDescription = sDescription;
    }

    public String getDescription() {
        return this.sDescription;
    }

    public void setProperty(String name, String value) {
        this.props.setProperty(name, value);
    }

    public Properties getProperties() {
        return this.props;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource r = (Resource)obj;
        return r.getType().equals(this.getType()) && r.getProperties().equals(this.getProperties()) && r.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        return this.getAttributes().hashCode() + this.getProperties().hashCode() + this.getType().hashCode();
    }

    public boolean isAConflict(Resource r) {
        return this.hasSameIdentity(r) && !r.equals(this);
    }

    private boolean hasSameIdentity(Resource r) {
        String rType = r.getType();
        if (rType.equals(CUSTOM_RESOURCE) || rType.equals(EXTERNAL_JNDI_RESOURCE) || rType.equals(JDBC_RESOURCE) || rType.equals(PERSISTENCE_MANAGER_FACTORY_RESOURCE) || rType.equals(CONNECTOR_RESOURCE) || rType.equals(ADMIN_OBJECT_RESOURCE) || rType.equals(MAIL_RESOURCE)) {
            return this.isEqualAttribute(r, "jndi-name");
        }
        if (rType.equals(JDBC_CONNECTION_POOL) || rType.equals(CONNECTOR_CONNECTION_POOL)) {
            return this.isEqualAttribute(r, "name");
        }
        if (rType.equals(RESOURCE_ADAPTER_CONFIG)) {
            return this.isEqualAttribute(r, "resource-adapter-name");
        }
        if (rType.equals(CONNECTOR_WORK_SECURITY_MAP)) {
            return this.isEqualAttribute(r, "name") && this.isEqualAttribute(r, "resource-adapter-name");
        }
        return false;
    }

    private boolean isEqualAttribute(Resource r, String name) {
        return this.getAttribute(r, name).equals(this.getAttribute(this, name));
    }

    private String getAttribute(Resource r, String name) {
        return (String)r.getAttributes().get(name);
    }

    public String toString() {
        String rType = this.getType();
        String identity = "";
        if (rType.equals(CUSTOM_RESOURCE) || rType.equals(EXTERNAL_JNDI_RESOURCE) || rType.equals(JDBC_RESOURCE) || rType.equals(PERSISTENCE_MANAGER_FACTORY_RESOURCE) || rType.equals(CONNECTOR_RESOURCE) || rType.equals(ADMIN_OBJECT_RESOURCE) || rType.equals(MAIL_RESOURCE)) {
            identity = this.getAttribute(this, "jndi-name");
        } else if (rType.equals(JDBC_CONNECTION_POOL) || rType.equals(CONNECTOR_CONNECTION_POOL)) {
            identity = this.getAttribute(this, "name");
        } else if (rType.equals(RESOURCE_ADAPTER_CONFIG)) {
            identity = this.getAttribute(this, "resource-adapter-name");
        } else if (rType.equals(CONNECTOR_WORK_SECURITY_MAP)) {
            identity = this.getAttribute(this, "name");
        }
        return identity + " of type " + this.resType;
    }
}

