/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_list-app-refs")
@ExecuteOn(value={RuntimeType.DAS})
@Scoped(value=PerLookup.class)
public class ListAppRefsCommand
implements AdminCommand {
    @Param(optional=true)
    String target = "server";
    @Param(optional=true)
    String type = null;
    @Param(optional=true, defaultValue="all")
    String state;
    @Inject
    Domain domain;
    @Inject
    Applications applications;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListAppRefsCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        part.setMessage(this.target);
        part.setChildrenType("application");
        List appRefs = this.domain.getApplicationRefsInTarget(this.target);
        for (ApplicationRef appRef : appRefs) {
            if (!this.state.equals("all") && (!this.state.equals("running") || !Boolean.valueOf(appRef.getEnabled()).booleanValue()) && (!this.state.equals("non-running") || Boolean.valueOf(appRef.getEnabled()).booleanValue()) || !this.isApplicationOfThisType(appRef.getRef(), this.type)) continue;
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage(appRef.getRef());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isApplicationOfThisType(String name, String type) {
        if (type == null) {
            return true;
        }
        Application app = this.applications.getApplication(name);
        if (app != null) {
            if (!app.isStandaloneModule()) {
                return type.equals("ear");
            }
            for (Module module : app.getModule()) {
                List engineList = module.getEngines();
                for (Engine engine : engineList) {
                    if (!engine.getSniffer().equals(type)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

