/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.EmbeddedMain;
import com.sun.enterprise.glassfish.bootstrap.NonOSGiGlassFishRuntime;
import com.sun.enterprise.glassfish.bootstrap.SingleHK2Factory;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.simpleglassfishapi.BootstrapConstants;
import org.glassfish.simpleglassfishapi.BootstrapOptions;
import org.glassfish.simpleglassfishapi.GlassFishException;
import org.glassfish.simpleglassfishapi.GlassFishRuntime;
import org.glassfish.simpleglassfishapi.spi.RuntimeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedNonOSGiGlassFishRuntimeBuilder
implements RuntimeBuilder {
    private static Logger logger = Util.getLogger();
    private static final String JAR_EXT = ".jar";

    @Override
    public boolean handles(BootstrapOptions bsOptions) {
        boolean handles = false;
        if (BootstrapConstants.Platform.Static.toString().equals(bsOptions.getAllOptions().getProperty("GlassFish_Platform"))) {
            String installRoot = bsOptions.getInstallRoot();
            String instanceRoot = bsOptions.getAllOptions().getProperty("com.sun.aas.instanceRoot");
            try {
                if (!this.isValidInstallRoot(installRoot)) {
                    handles = true;
                }
            }
            catch (Exception ex) {
                handles = true;
            }
        }
        return handles;
    }

    @Override
    public GlassFishRuntime build(BootstrapOptions bsOptions) throws GlassFishException {
        try {
            Properties properties = bsOptions.getAllOptions();
            String instanceRoot = properties.getProperty("com.sun.aas.instanceRoot");
            if (instanceRoot == null) {
                instanceRoot = this.createDefaultInstanceRoot();
                properties.setProperty("com.sun.aas.instanceRoot", instanceRoot);
                properties.setProperty("com.sun.aas.instanceRootURI", new File(instanceRoot).toURI().toString());
            }
            this.provisionInstanceRoot(new File(instanceRoot), properties);
            String installRoot = bsOptions.getInstallRoot();
            if (installRoot == null) {
                installRoot = this.createDefaultInstallRoot(instanceRoot);
                properties.setProperty("com.sun.aas.installRoot", installRoot);
                properties.setProperty("com.sun.aas.installRootURI", new File(installRoot).toURI().toString());
            }
            this.provisionInstallRoot(new File(installRoot));
            this.copyConfigFile(properties.getProperty("com.sun.aas.configFileURI"), instanceRoot);
            List<URL> moduleJarURLs = this.getModuleJarURLs(installRoot);
            StaticClassLoader cl = new StaticClassLoader(this.getClass().getClassLoader(), moduleJarURLs);
            EmbeddedMain main = new EmbeddedMain();
            SingleHK2Factory.initialize(cl);
            ModulesRegistry modulesRegistry = AbstractFactory.getInstance().createModulesRegistry();
            modulesRegistry.setParentClassLoader(cl);
            NonOSGiGlassFishRuntime glassFishRuntime = new NonOSGiGlassFishRuntime(main);
            logger.logp(Level.FINER, this.getClass().getName(), "build", "Created GlassFishRuntime {0} with Bootstrap Properties {1}", new Object[]{glassFishRuntime, bsOptions.getAllOptions()});
            return glassFishRuntime;
        }
        catch (Exception ex) {
            throw new GlassFishException(ex);
        }
    }

    @Override
    public void destroy() throws GlassFishException {
    }

    private boolean isValidInstallRoot(File installRoot) {
        return installRoot == null ? false : this.isValidInstallRoot(installRoot.getAbsolutePath());
    }

    private boolean isValidInstallRoot(String installRootPath) {
        if (installRootPath == null || !new File(installRootPath).exists()) {
            System.err.println("Return false from isValidInstallRoot");
            return false;
        }
        if (!new File(installRootPath, "modules").exists()) {
            return false;
        }
        return new File(installRootPath, "lib/dtds").exists();
    }

    private String createDefaultInstanceRoot() throws Exception {
        String tmpDir = System.getProperty("glassfish.embedded.tmpdir");
        if (tmpDir == null) {
            tmpDir = System.getProperty("user.dir");
        }
        File instanceRoot = File.createTempFile("gfembed", "tmp", new File(tmpDir));
        instanceRoot.delete();
        instanceRoot.mkdir();
        return instanceRoot.getAbsolutePath();
    }

    private void provisionInstallRoot(File installRoot) {
        File discoveredInstallRoot = ASMainHelper.findInstallRoot();
        if (!discoveredInstallRoot.equals(installRoot) && this.isValidInstallRoot(discoveredInstallRoot)) {
            this.copy(discoveredInstallRoot, installRoot, "lib/dtds", "lib/schemas");
        }
    }

    private String createDefaultInstallRoot(String instanceRoot) throws Exception {
        File installRoot = ASMainHelper.findInstallRoot();
        if (!this.isValidInstallRoot(installRoot)) {
            installRoot = new File(instanceRoot);
        }
        return installRoot.getAbsolutePath();
    }

    private void provisionInstanceRoot(File instanceRoot, Properties props) {
        new File(instanceRoot, "config").mkdirs();
        new File(instanceRoot, "docroot").mkdirs();
        try {
            File discoveredInstallRoot = ASMainHelper.findInstallRoot();
            File discoveredInstanceRoot = ASMainHelper.findInstanceRoot(discoveredInstallRoot, props);
            if (!discoveredInstanceRoot.equals(instanceRoot)) {
                this.copy(discoveredInstanceRoot, instanceRoot, "config", "docroot");
            }
        }
        catch (Exception ex) {
            logger.warning(ex.getMessage());
        }
    }

    private void copy(final File srcDir, final File dstDir, final String ... subDirs) {
        srcDir.listFiles(new FileFilter(){

            public boolean accept(File path) {
                if (path.isDirectory()) {
                    path.listFiles(this);
                } else {
                    for (String subDir : subDirs) {
                        File dstFile;
                        String srcPath = new File(srcDir, subDir).getPath();
                        if (!path.getPath().startsWith(srcPath) || (dstFile = new File(dstDir, path.getPath().substring(srcDir.getPath().length()))).exists()) continue;
                        dstFile.getParentFile().mkdirs();
                        try {
                            Util.copyFile(path, dstFile);
                        }
                        catch (Exception ex) {
                            logger.warning(ex.getMessage());
                        }
                    }
                }
                return false;
            }
        });
    }

    private void copyConfigFile(String configFileURI, String instanceRoot) throws Exception {
        if (configFileURI != null && instanceRoot != null) {
            URI configFile = URI.create(configFileURI);
            InputStream stream = configFile.toURL().openConnection().getInputStream();
            File domainXml = new File(instanceRoot, "config/domain.xml");
            logger.finer("domainXML uri = " + configFileURI + ", size = " + stream.available());
            if (!domainXml.toURI().equals(configFile)) {
                Util.copy(stream, new FileOutputStream(domainXml), stream.available());
                logger.finer("Created " + domainXml);
            } else {
                logger.finer("Skipped creation of " + domainXml);
            }
        }
    }

    private List<URL> getModuleJarURLs(String installRoot) {
        File modulesDir = new File(installRoot, "modules/");
        final File autostartModulesDir = new File(modulesDir, "autostart/");
        final ArrayList<URL> moduleJarURLs = new ArrayList<URL>();
        if (modulesDir.exists()) {
            modulesDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    if (pathname.isDirectory() && !pathname.equals(autostartModulesDir)) {
                        pathname.listFiles(this);
                    } else if (pathname.getName().endsWith(EmbeddedNonOSGiGlassFishRuntimeBuilder.JAR_EXT)) {
                        try {
                            moduleJarURLs.add(pathname.toURI().toURL());
                        }
                        catch (Exception ex) {
                            logger.warning(ex.getMessage());
                        }
                    }
                    return false;
                }
            });
        }
        return moduleJarURLs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StaticClassLoader
    extends URLClassLoader {
        public StaticClassLoader(ClassLoader parent, List<URL> moduleJarURLs) {
            super(moduleJarURLs.toArray(new URL[0]), parent);
        }
    }
}

