/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.net.URI;
import java.net.URISyntaxException;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.impl.AnnotationModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.AnnotationTypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.ClassModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.FieldModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.MethodModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeBuilder;
import org.glassfish.hk2.classmodel.reflect.impl.TypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class ModelClassVisitor
implements ClassVisitor {
    private final ParsingContext ctx;
    private final TypeBuilder typeBuilder;
    private final URI definingURI;
    private final String entryName;
    TypeImpl type;
    boolean deepVisit = false;
    final VisitingContext visitingContext = new VisitingContext();
    private final ModelFieldVisitor fieldVisitor = new ModelFieldVisitor(this.visitingContext);
    private final ModelMethodVisitor methodVisitor = new ModelMethodVisitor(this.visitingContext);
    private final ModelAnnotationVisitor annotationVisitor = new ModelAnnotationVisitor(this.visitingContext);

    public ModelClassVisitor(ParsingContext ctx, URI definingURI, String entryName) {
        this.ctx = ctx;
        this.definingURI = definingURI;
        this.entryName = entryName;
        this.typeBuilder = ctx.getTypeBuilder(definingURI);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        TypeProxy<? extends Type> parent;
        String parentName = superName != null ? org.objectweb.asm.Type.getObjectType((String)superName).getClassName() : null;
        TypeProxy<? extends Type> typeProxy = parent = parentName != null ? this.typeBuilder.getHolder(parentName, this.typeBuilder.getType(access)) : null;
        if (parent != null) {
            parent.set(this.typeBuilder.getType(access, parentName, null));
        }
        String className = org.objectweb.asm.Type.getObjectType((String)name).getClassName();
        URI classDefURI = null;
        try {
            int index = this.entryName.length() - name.length() - 6;
            String newPath = index > 0 ? this.definingURI.getPath() + this.entryName.substring(0, index) : this.definingURI.getPath();
            classDefURI = new URI(this.definingURI.getScheme(), newPath, this.definingURI.getFragment());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.type = this.ctx.getTypeBuilder(classDefURI).getType(access, className, parent);
        this.deepVisit = this.ctx.getConfig().getInjectionTargetAnnotations().isEmpty();
        if (parent != null) {
            parent.getSubTypeRefs().add(this.type);
        }
        try {
            ClassModelImpl classModel = (ClassModelImpl)this.type;
            for (String intf : interfaces) {
                String interfaceName = org.objectweb.asm.Type.getObjectType((String)intf).getClassName();
                TypeProxy<InterfaceModel> typeProxy2 = this.typeBuilder.getHolder(interfaceName, InterfaceModel.class);
                classModel.isImplementing(typeProxy2);
                typeProxy2.getImplementations().add(classModel);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        desc = this.unwrap(desc);
        AnnotationTypeImpl at = (AnnotationTypeImpl)this.typeBuilder.getType(8192, desc, null);
        AnnotationModelImpl am = new AnnotationModelImpl(this.type, at);
        at.getAnnotatedElements().add(this.type);
        this.type.addAnnotation(am);
        if (this.ctx.getConfig().getInjectionTargetAnnotations().contains(desc)) {
            System.out.println("Inspecting fields of " + this.type.getName());
            this.deepVisit = true;
        }
        this.visitingContext.annotation = am;
        return this.annotationVisitor;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldModelImpl field;
        ClassModelImpl cm;
        if (!this.deepVisit) {
            return null;
        }
        try {
            cm = (ClassModelImpl)this.type;
        }
        catch (Exception e) {
            return null;
        }
        org.objectweb.asm.Type asmType = org.objectweb.asm.Type.getType((String)desc);
        TypeProxy fieldType = this.typeBuilder.getHolder(asmType.getClassName());
        this.visitingContext.field = field = this.typeBuilder.getFieldModel(name, fieldType, cm);
        fieldType.getRefs().add(field);
        cm.addField(field);
        return this.fieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        ExtensibleType cm;
        if (!this.deepVisit) {
            return null;
        }
        try {
            cm = (ExtensibleType)((Object)this.type);
        }
        catch (Exception e) {
            return null;
        }
        MethodModelImpl method = new MethodModelImpl(name, cm);
        this.type.addMethod(method);
        this.visitingContext.method = method;
        return this.methodVisitor;
    }

    public void visitEnd() {
        this.type = null;
    }

    private String unwrap(String desc) {
        return org.objectweb.asm.Type.getType((String)desc).getClassName();
    }

    private class ModelAnnotationVisitor
    extends EmptyVisitor
    implements AnnotationVisitor {
        private final VisitingContext context;

        private ModelAnnotationVisitor(VisitingContext context) {
            this.context = context;
        }

        public void visit(String name, Object value) {
            if (this.context.annotation == null) {
                return;
            }
            this.context.annotation.addValue(name, value);
        }

        public void visitEnd() {
            this.context.annotation = null;
        }
    }

    private class ModelFieldVisitor
    extends EmptyVisitor
    implements FieldVisitor {
        private final VisitingContext context;

        private ModelFieldVisitor(VisitingContext context) {
            this.context = context;
        }

        public AnnotationVisitor visitAnnotation(String s, boolean b) {
            FieldModelImpl field = this.context.field;
            AnnotationTypeImpl annotationType = (AnnotationTypeImpl)ModelClassVisitor.this.typeBuilder.getType(8192, ModelClassVisitor.this.unwrap(s), null);
            AnnotationModelImpl annotationModel = new AnnotationModelImpl(field, annotationType);
            annotationType.getAnnotatedElements().add(field);
            field.addAnnotation(annotationModel);
            this.context.annotation = annotationModel;
            return ModelClassVisitor.this.annotationVisitor;
        }

        public void visitEnd() {
            this.context.field = null;
        }
    }

    private class ModelMethodVisitor
    extends EmptyVisitor
    implements FieldVisitor {
        private final VisitingContext context;

        private ModelMethodVisitor(VisitingContext context) {
            this.context = context;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (this.context.method == null) {
                return null;
            }
            AnnotationTypeImpl annotationType = (AnnotationTypeImpl)ModelClassVisitor.this.typeBuilder.getType(8192, ModelClassVisitor.this.unwrap(desc), null);
            AnnotationModelImpl annotationModel = new AnnotationModelImpl(this.context.method, annotationType);
            annotationType.getAnnotatedElements().add(this.context.method);
            this.context.method.addAnnotation(annotationModel);
            this.context.annotation = annotationModel;
            return ModelClassVisitor.this.annotationVisitor;
        }

        public void visitEnd() {
            this.context.method = null;
        }
    }

    private static class VisitingContext {
        FieldModelImpl field;
        MethodModelImpl method;
        AnnotationModelImpl annotation;

        private VisitingContext() {
        }
    }
}

