/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.common.XMLContentActionReporter;
import com.sun.hk2.component.InjectionResolver;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Async;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandLock;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.CommandParameters;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.common.util.admin.MapInjectionResolver;
import org.glassfish.common.util.admin.UnacceptableValueException;
import org.glassfish.config.support.GenericCrudCommand;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.component.UnsatisfiedDependencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class CommandRunnerImpl
implements CommandRunner {
    private final Logger logger = LogDomains.getLogger(CommandRunnerImpl.class, (String)"javax.enterprise.system.tools.admin");
    private final InjectionManager injectionMgr = new InjectionManager();
    @Inject
    private Habitat habitat;
    @Inject
    private ServerContext sc;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private InstanceStateService state;
    @Inject
    private AdminCommandLock adminLock;
    private static final String ASADMIN_CMD_PREFIX = "AS_ADMIN_";
    private static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(CommandRunnerImpl.class);

    @Override
    public ActionReport getActionReport(String name) {
        return (ActionReport)this.habitat.getComponent(ActionReport.class, name);
    }

    @Override
    public CommandModel getModel(String commandName, Logger logger) {
        AdminCommand command = null;
        try {
            command = (AdminCommand)this.habitat.getComponent(AdminCommand.class, commandName);
        }
        catch (ComponentException e) {
            logger.log(Level.SEVERE, "Cannot instantiate " + commandName, e);
            return null;
        }
        return CommandRunnerImpl.getModel(command);
    }

    @Override
    public AdminCommand getCommand(String commandName, ActionReport report, Logger logger) {
        CommandModel model;
        AdminCommand command = null;
        try {
            command = (AdminCommand)this.habitat.getComponent(AdminCommand.class, commandName);
        }
        catch (ComponentException e) {
            e.printStackTrace();
            report.setFailureCause(e);
        }
        if (command == null) {
            String msg = !CommandRunnerImpl.ok(commandName) ? adminStrings.getLocalString("adapter.command.nocommand", "No command was specified.") : (this.habitat.getInhabitant(AdminCommand.class, commandName) == null ? adminStrings.getLocalString("adapter.command.notfound", "Command {0} not found", new Object[]{commandName}) : adminStrings.getLocalString("adapter.command.notcreated", "Implementation for the command {0} exists in the system, but it has some errors, check server.log for details", new Object[]{commandName}));
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            LogHelper.getDefaultLogger().info(msg);
            return null;
        }
        Scoped scoped = command.getClass().getAnnotation(Scoped.class);
        if (scoped == null) {
            String msg = adminStrings.getLocalString("adapter.command.noscope", "Implementation for the command {0} exists in the system,\nbut it has no @Scoped annotation", new Object[]{commandName});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            LogHelper.getDefaultLogger().info(msg);
            command = null;
        } else if (scoped.value() == Singleton.class && (model = CommandRunnerImpl.getModel(command)).getParameters().size() > 0) {
            String msg = adminStrings.getLocalString("adapter.command.hasparams", "Implementation for the command {0} exists in the system,\nbut it's a singleton that also has parameters", new Object[]{commandName});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            LogHelper.getDefaultLogger().info(msg);
            command = null;
        }
        return command;
    }

    @Override
    public CommandRunner.CommandInvocation getCommandInvocation(String name, ActionReport report) {
        return new ExecutionContext(name, report);
    }

    private ActionReport.ExitCode injectParameters(CommandModel model, AdminCommand command, InjectionResolver<Param> injector, AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionDescription(model.getCommandName() + " command");
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        try {
            GenericCrudCommand c = (GenericCrudCommand)GenericCrudCommand.class.cast(command);
            c.setInjectionResolver(injector);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            this.injectionMgr.inject((Object)command, new InjectionResolver[]{injector});
        }
        catch (UnsatisfiedDependencyException e) {
            String errorMsg;
            Param param = (Param)e.getAnnotation(Param.class);
            CommandModel.ParamModel paramModel = null;
            for (CommandModel.ParamModel pModel : model.getParameters()) {
                if (!pModel.getParam().equals(param)) continue;
                paramModel = pModel;
                break;
            }
            String usage = CommandRunnerImpl.getUsageText(command, model);
            if (paramModel != null) {
                String paramName = paramModel.getName();
                String paramDesc = paramModel.getLocalizedDescription();
                errorMsg = param.primary() ? adminStrings.getLocalString("commandrunner.operand.required", "Operand required.") : (param.password() ? adminStrings.getLocalString("adapter.param.missing.passwordfile", "{0} command requires the passwordfile parameter containing {1} entry.", new Object[]{model.getCommandName(), paramName}) : (paramDesc != null ? adminStrings.getLocalString("admin.param.missing", "{0} command requires the {1} parameter ({2})", new Object[]{model.getCommandName(), paramName, paramDesc}) : adminStrings.getLocalString("admin.param.missing.nodesc", "{0} command requires the {1} parameter", new Object[]{model.getCommandName(), paramName})));
            } else {
                errorMsg = adminStrings.getLocalString("admin.param.missing.nofound", "Cannot find {1} in {0} command model, file a bug", new Object[]{model.getCommandName(), e.getUnsatisfiedName()});
            }
            this.logger.severe(errorMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(errorMsg);
            report.setFailureCause(e);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(usage);
            return report.getActionExitCode();
        }
        catch (ComponentException e) {
            Throwable exception = e;
            Throwable cause = e.getCause();
            if (cause != null && (cause instanceof UnacceptableValueException || cause instanceof IllegalArgumentException)) {
                exception = (Exception)cause;
            }
            this.logger.log(Level.SEVERE, "invocation.exception", exception);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(exception.getMessage());
            report.setFailureCause(exception);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(CommandRunnerImpl.getUsageText(command, model));
            return report.getActionExitCode();
        }
        return report.getActionExitCode();
    }

    private ActionReport doCommand(CommandModel model, final AdminCommand command, final AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionDescription(model.getCommandName() + " AdminCommand");
        final AdminCommand wrappedComamnd = new AdminCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(AdminCommandContext context) {
                ClassLoader ccl;
                Thread thread = Thread.currentThread();
                ClassLoader origCL = thread.getContextClassLoader();
                if (origCL != (ccl = CommandRunnerImpl.this.sc.getCommonClassLoader())) {
                    try {
                        thread.setContextClassLoader(ccl);
                        command.execute(context);
                    }
                    finally {
                        thread.setContextClassLoader(origCL);
                    }
                } else {
                    command.execute(context);
                }
            }
        };
        Async async = command.getClass().getAnnotation(Async.class);
        if (async == null) {
            try {
                wrappedComamnd.execute(context);
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, adminStrings.getLocalString("adapter.exception", "Exception in command execution : ", new Object[]{e}), e);
                report.setMessage(e.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(e);
            }
        } else {
            Thread t = new Thread(){

                public void run() {
                    try {
                        wrappedComamnd.execute(context);
                    }
                    catch (RuntimeException e) {
                        CommandRunnerImpl.this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            };
            t.setPriority(async.priority());
            t.start();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(adminStrings.getLocalString("adapter.command.launch", "Command {0} was successfully initiated asynchronously.", new Object[]{model.getCommandName()}));
        }
        return context.getActionReport();
    }

    static String getUsageText(AdminCommand command, CommandModel model) {
        StringBuffer usageText = new StringBuffer();
        String usage = model.getUsageText();
        if (CommandRunnerImpl.ok(usage)) {
            usageText.append(adminStrings.getLocalString("adapter.usage", "Usage: "));
            usageText.append(usage);
            return usageText.toString();
        }
        return CommandRunnerImpl.generateUsageText(model);
    }

    private static String generateUsageText(CommandModel model) {
        StringBuffer usageText = new StringBuffer();
        usageText.append(adminStrings.getLocalString("adapter.usage", "Usage: "));
        usageText.append(model.getCommandName());
        usageText.append(" ");
        StringBuffer operand = new StringBuffer();
        for (CommandModel.ParamModel pModel : model.getParameters()) {
            Param param = pModel.getParam();
            String paramName = pModel.getName().toLowerCase(Locale.ENGLISH);
            if (paramName.startsWith("_") || param.password() || param.obsolete()) continue;
            boolean optional = param.optional();
            Class ftype = pModel.getType();
            String fvalue = null;
            String fvalueString = null;
            try {
                fvalue = param.defaultValue();
                if (fvalue != null) {
                    fvalueString = fvalue.toString();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (param.primary()) {
                if (optional) {
                    operand.append("[").append(paramName).append("] ");
                    continue;
                }
                operand.append(paramName).append(" ");
                continue;
            }
            if (optional) {
                usageText.append("[");
            }
            usageText.append("--").append(paramName);
            if (CommandRunnerImpl.ok(param.defaultValue())) {
                usageText.append("=").append(param.defaultValue());
            } else if (ftype.isAssignableFrom(String.class)) {
                if (CommandRunnerImpl.ok(fvalueString)) {
                    usageText.append("=").append(fvalueString);
                } else {
                    usageText.append("=").append(paramName);
                }
            } else if (ftype.isAssignableFrom(Boolean.class)) {
                usageText.append("=").append("true|false");
            } else {
                usageText.append("=").append(paramName);
            }
            if (optional) {
                usageText.append("] ");
                continue;
            }
            usageText.append(" ");
        }
        usageText.append(operand);
        return usageText.toString();
    }

    public void getHelp(AdminCommand command, ActionReport report) {
        CommandModel model = CommandRunnerImpl.getModel(command);
        report.setActionDescription(model.getCommandName() + " help");
        if (report instanceof XMLContentActionReporter) {
            this.getMetadata(command, model, report);
        } else {
            report.setMessage(model.getCommandName() + " - " + model.getLocalizedDescription());
            report.getTopMessagePart().addProperty("SYNOPSIS", CommandRunnerImpl.encodeManPage(new BufferedReader(new StringReader(CommandRunnerImpl.getUsageText(command, model)))));
            for (CommandModel.ParamModel param : model.getParameters()) {
                this.addParamUsage(report, param);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private void getMetadata(AdminCommand command, CommandModel model, ActionReport report) {
        String usage;
        ActionReport.MessagePart top = report.getTopMessagePart();
        ActionReport.MessagePart cmd = top.addChild();
        cmd.setChildrenType("command");
        cmd.addProperty("name", model.getCommandName());
        if (model.unknownOptionsAreOperands()) {
            cmd.addProperty("unknown-options-are-operands", "true");
        }
        if (CommandRunnerImpl.ok(usage = model.getUsageText())) {
            cmd.addProperty("usage", usage);
        }
        CommandModel.ParamModel primary = null;
        for (CommandModel.ParamModel p : model.getParameters()) {
            String paramDesc;
            Param param = p.getParam();
            if (param.primary()) {
                primary = p;
                continue;
            }
            ActionReport.MessagePart ppart = cmd.addChild();
            ppart.setChildrenType("option");
            ppart.addProperty("name", p.getName());
            ppart.addProperty("type", CommandRunnerImpl.typeOf(p));
            ppart.addProperty("optional", Boolean.toString(param.optional()));
            if (param.obsolete()) {
                ppart.addProperty("obsolete", "true");
            }
            if (CommandRunnerImpl.ok(paramDesc = p.getLocalizedDescription())) {
                ppart.addProperty("description", paramDesc);
            }
            if (CommandRunnerImpl.ok(param.shortName())) {
                ppart.addProperty("short", param.shortName());
            }
            if (CommandRunnerImpl.ok(param.defaultValue())) {
                ppart.addProperty("default", param.defaultValue());
            }
            if (CommandRunnerImpl.ok(param.acceptableValues())) {
                ppart.addProperty("acceptable-values", param.acceptableValues());
            }
            if (!CommandRunnerImpl.ok(param.alias())) continue;
            ppart.addProperty("alias", param.alias());
        }
        if (primary != null) {
            ActionReport.MessagePart primpart = cmd.addChild();
            primpart.setChildrenType("operand");
            primpart.addProperty("name", primary.getName());
            primpart.addProperty("type", CommandRunnerImpl.typeOf(primary));
            primpart.addProperty("min", primary.getParam().optional() ? "0" : "1");
            primpart.addProperty("max", primary.getParam().multiple() ? "unlimited" : "1");
            String desc = primary.getLocalizedDescription();
            if (CommandRunnerImpl.ok(desc)) {
                primpart.addProperty("description", desc);
            }
        }
    }

    private static String typeOf(CommandModel.ParamModel p) {
        Class t = p.getType();
        if (t == Boolean.class || t == Boolean.TYPE) {
            return "BOOLEAN";
        }
        if (t == File.class) {
            return "FILE";
        }
        if (t == Properties.class) {
            return "PROPERTIES";
        }
        if (p.getParam().password()) {
            return "PASSWORD";
        }
        return "STRING";
    }

    public InputStream getManPage(String commandName, AdminCommand command) {
        Class<?> clazz = command.getClass();
        Package pkg = clazz.getPackage();
        String manPage = pkg.getName().replace('.', '/');
        manPage = manPage + "/" + commandName + ".1";
        ClassLoader loader = clazz.getClassLoader();
        InputStream in = loader.getResourceAsStream(manPage);
        return in;
    }

    private void addParamUsage(ActionReport report, CommandModel.ParamModel model) {
        Param param = model.getParam();
        if (param != null) {
            String paramName = model.getName().toLowerCase(Locale.ENGLISH);
            if (paramName.startsWith("_")) {
                return;
            }
            if (param.password()) {
                return;
            }
            if (param.obsolete()) {
                return;
            }
            if (param.primary()) {
                report.getTopMessagePart().addProperty(paramName + "_operand", model.getLocalizedDescription());
            } else {
                report.getTopMessagePart().addProperty(paramName, model.getLocalizedDescription());
            }
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static void validateParameters(CommandModel model, ParameterMap parameters) throws ComponentException {
        for (Map.Entry entry : parameters.entrySet()) {
            CommandModel.ParamModel pModel;
            String key = (String)entry.getKey();
            if (key.equals("DEFAULT") || key.startsWith(ASADMIN_CMD_PREFIX) || key.equals("help") || key.equals("Xhelp")) continue;
            boolean validOption = false;
            Iterator<CommandModel.ParamModel> i$ = model.getParameters().iterator();
            while (!(!i$.hasNext() || (validOption = (pModel = i$.next()).isParamId(key)) || pModel.getParam().password() && (validOption = pModel.isParamId(ASADMIN_CMD_PREFIX + key.toUpperCase(Locale.ENGLISH))))) {
            }
            if (validOption) continue;
            throw new ComponentException(" Invalid option: " + key);
        }
    }

    static boolean skipValidation(AdminCommand command) {
        try {
            Field f = command.getClass().getDeclaredField("skipParamValidation");
            f.setAccessible(true);
            if (f.getType().isAssignableFrom(Boolean.TYPE)) {
                return f.getBoolean(command);
            }
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        return false;
    }

    private static String encodeManPage(InputStream in) {
        if (in == null) {
            return null;
        }
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
        }
        catch (UnsupportedEncodingException ex) {
            r = new BufferedReader(new InputStreamReader(in));
        }
        return CommandRunnerImpl.encodeManPage(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encodeManPage(BufferedReader br) {
        String string;
        try {
            String line;
            if (br == null) {
                String string2 = null;
                return string2;
            }
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("%%%EOL%%%");
            }
            string = sb.toString();
        }
        catch (Exception ex) {
            String string3 = null;
            return string3;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    private static CommandModel getModel(AdminCommand command) {
        if (command instanceof CommandModelProvider) {
            return ((CommandModelProvider)((Object)command)).getModel();
        }
        return new CommandModelImpl(command.getClass());
    }

    /*
     * Exception decompiling
     */
    private void doCommand(ExecutionContext inv, AdminCommand command) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isSet(ParameterMap params, String name) {
        String val = (String)params.getOne(name);
        if (val == null) {
            return false;
        }
        return val.length() == 0 || Boolean.valueOf(val) != false;
    }

    private String formatSuspendDate(Date lockTime) {
        if (lockTime != null) {
            String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            return sdf.format(lockTime);
        }
        return new String(adminStrings.getLocalString("lock.timeoutunavailable", "<<Date is unavailable>>"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UploadedFilesManager {
        private final ActionReport report;
        private final Logger logger;
        private Map<String, File> optionNameToFileMap;
        private PayloadFilesManager.Temp payloadFilesMgr = null;

        private UploadedFilesManager(ActionReport report, Logger logger, Payload.Inbound inboundPayload) throws IOException, Exception {
            this.logger = logger;
            this.report = report;
            this.extractFiles(inboundPayload);
        }

        private Map<String, File> optionNameToFileMap() {
            return this.optionNameToFileMap;
        }

        private void close() {
            if (this.payloadFilesMgr != null) {
                this.payloadFilesMgr.cleanup();
            }
        }

        private Map<String, File> extractFiles(Payload.Inbound inboundPayload) throws IOException, Exception {
            if (inboundPayload == null) {
                return Collections.EMPTY_MAP;
            }
            File uniqueSubdirUnderApplications = this.chooseTempDirParent();
            this.payloadFilesMgr = new PayloadFilesManager.Temp(uniqueSubdirUnderApplications, this.report, this.logger);
            Map payloadFiles = this.payloadFilesMgr.processPartsExtended(inboundPayload);
            this.optionNameToFileMap = new HashMap<String, File>();
            for (Map.Entry e : payloadFiles.entrySet()) {
                String optionName = ((Properties)e.getValue()).getProperty("data-request-name");
                if (optionName == null) continue;
                this.optionNameToFileMap.put(optionName, (File)e.getKey());
            }
            return this.optionNameToFileMap;
        }

        private File chooseTempDirParent() throws IOException {
            File appRoot = new File(CommandRunnerImpl.this.domain.getApplicationRoot());
            if (!appRoot.isDirectory()) {
                appRoot.mkdirs();
            }
            return appRoot;
        }

        static /* synthetic */ Map access$900(UploadedFilesManager x0) {
            return x0.optionNameToFileMap();
        }

        static /* synthetic */ void access$1100(UploadedFilesManager x0) {
            x0.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatedInjectionResolver
    extends InjectionResolver<Param> {
        private final CommandModel model;
        private final CommandParameters parameters;
        private final Map<String, File> optionNameToUploadedFileMap;

        public DelegatedInjectionResolver(CommandModel model, CommandParameters parameters, Map<String, File> optionNameToUploadedFileMap) {
            super(Param.class);
            this.model = model;
            this.parameters = parameters;
            this.optionNameToUploadedFileMap = optionNameToUploadedFileMap;
        }

        public boolean isOptional(AnnotatedElement element, Param annotation) {
            String name = CommandModel.getParamName(annotation, element);
            CommandModel.ParamModel param = this.model.getModelFor(name);
            return param.getParam().optional();
        }

        public <V> V getValue(Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Class<V> type) throws ComponentException {
            if (target instanceof Field) {
                Field targetField = (Field)target;
                try {
                    Field sourceField = this.parameters.getClass().getField(targetField.getName());
                    targetField.setAccessible(true);
                    Object paramValue = sourceField.get(this.parameters);
                    String paramFileValue = MapInjectionResolver.getUploadedFileParamValue((String)targetField.getName(), targetField.getType(), this.optionNameToUploadedFileMap);
                    if (paramFileValue != null) {
                        paramValue = new File(paramFileValue);
                    }
                    if (paramValue != null) {
                        DelegatedInjectionResolver.checkAgainstAcceptableValues(target, paramValue.toString());
                    }
                    return type.cast(paramValue);
                }
                catch (IllegalAccessException e) {
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            return null;
        }

        private static void checkAgainstAcceptableValues(AnnotatedElement target, String paramValueStr) {
            Param param = target.getAnnotation(Param.class);
            String acceptable = param.acceptableValues();
            String paramName = CommandModel.getParamName(param, target);
            if (CommandRunnerImpl.ok(acceptable) && CommandRunnerImpl.ok(paramValueStr)) {
                String[] ss;
                for (String s : ss = acceptable.split(",")) {
                    if (!paramValueStr.equals(s.trim())) continue;
                    return;
                }
                throw new UnacceptableValueException(adminStrings.getLocalString("adapter.command.unacceptableValue", "Invalid parameter: {0}.  Its value is {1} but it isn''t one of these acceptable values: {2}", new Object[]{paramName, paramValueStr, acceptable}));
            }
        }
    }

    private class ExecutionContext
    implements CommandRunner.CommandInvocation {
        protected final String name;
        protected final ActionReport report;
        protected ParameterMap params;
        protected CommandParameters paramObject;
        protected Payload.Inbound inbound;
        protected Payload.Outbound outbound;

        private ExecutionContext(String name, ActionReport report) {
            this.name = name;
            this.report = report;
        }

        public CommandRunner.CommandInvocation parameters(CommandParameters paramObject) {
            this.paramObject = paramObject;
            return this;
        }

        public CommandRunner.CommandInvocation parameters(ParameterMap params) {
            this.params = params;
            return this;
        }

        public CommandRunner.CommandInvocation inbound(Payload.Inbound inbound) {
            this.inbound = inbound;
            return this;
        }

        public CommandRunner.CommandInvocation outbound(Payload.Outbound outbound) {
            this.outbound = outbound;
            return this;
        }

        public void execute() {
            this.execute(null);
        }

        private ParameterMap parameters() {
            return this.params;
        }

        private CommandParameters typedParams() {
            return this.paramObject;
        }

        private String name() {
            return this.name;
        }

        private ActionReport report() {
            return this.report;
        }

        private Payload.Inbound inboundPayload() {
            return this.inbound;
        }

        private Payload.Outbound outboundPayload() {
            return this.outbound;
        }

        public void execute(AdminCommand command) {
            CommandRunnerImpl.this.doCommand(this, command);
        }

        static /* synthetic */ String access$300(ExecutionContext x0) {
            return x0.name();
        }

        static /* synthetic */ ActionReport access$400(ExecutionContext x0) {
            return x0.report();
        }

        static /* synthetic */ Payload.Inbound access$500(ExecutionContext x0) {
            return x0.inboundPayload();
        }

        static /* synthetic */ Payload.Outbound access$600(ExecutionContext x0) {
            return x0.outboundPayload();
        }

        static /* synthetic */ CommandParameters access$800(ExecutionContext x0) {
            return x0.typedParams();
        }

        static /* synthetic */ ParameterMap access$1000(ExecutionContext x0) {
            return x0.parameters();
        }
    }
}

