/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.classmodel;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantIntrospectionScanner;
import com.sun.hk2.component.InhabitantsParser;
import com.sun.hk2.component.InhabitantsScanner;
import com.sun.hk2.component.IntrospectionScanner;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.classmodel.InhabitantsParsingContextGenerator;

public abstract class InhabitantsFeed {
    private final Logger logger = Logger.getLogger(InhabitantsFeed.class.getName());
    private final InhabitantsParser ip;
    private Holder<ClassLoader> classLoaderHolder;

    public static InhabitantsFeed create(Habitat h, InhabitantsParser ip) {
        return new InhabitantsFeed(ip){};
    }

    protected InhabitantsFeed(InhabitantsParser ip) {
        this.ip = ip;
        this.setClassLoaderContext(this.getClass().getClassLoader());
    }

    public void setClassLoaderContext(ClassLoader cl) {
        this.classLoaderHolder = new Holder.Impl<ClassLoader>(cl);
    }

    public void populate(InhabitantsParsingContextGenerator ipcgen) {
        this.logger.log(Level.FINER, "Starting to introspect");
        ParsingContext context = ipcgen.getContext();
        InhabitantIntrospectionScanner is = new InhabitantIntrospectionScanner(context);
        try {
            this.ip.parse(is, this.classLoaderHolder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.logger.log(Level.FINER, "finished introspecting");
        this.logger.log(Level.FINER, "Starting to introspect");
        Collection<InhabitantsScanner> metaInfScanners = ipcgen.getInhabitantsScanners();
        for (InhabitantsScanner scanner : metaInfScanners) {
            try {
                this.ip.parse(scanner, this.classLoaderHolder);
                scanner.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.logger.log(Level.FINER, "finished introspecting");
        for (IntrospectionScanner s : this.ip.habitat.getAllByContract(IntrospectionScanner.class)) {
            this.logger.log(Level.FINE, "parsing with supplemental scanner {0}", s);
            s.parse(context, this.classLoaderHolder);
        }
    }
}

