/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.Configurator;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.GlassFishException;
import org.jvnet.hk2.component.Habitat;

class ConfiguratorImpl
implements Configurator {
    Habitat habitat;
    private static final Map<String, String> simpleConfigurators = new HashMap<String, String>();
    private static final String COMMA_SEPARATED_VALUE = "{0},{1}";

    public ConfiguratorImpl(Habitat habitat) {
        this.habitat = habitat;
    }

    public void configure(Properties bootstrapProps) throws GlassFishException {
        String setValues = null;
        for (String key : simpleConfigurators.keySet()) {
            String configuredVal = bootstrapProps.getProperty(key);
            if (configuredVal == null) continue;
            String formatted = MessageFormat.format(simpleConfigurators.get(key), configuredVal);
            setValues = setValues == null ? formatted : MessageFormat.format(COMMA_SEPARATED_VALUE, setValues, formatted);
        }
        if (setValues != null) {
            CommandRunner commandRunner = this.habitat.getComponent(CommandRunner.class);
            commandRunner.run("set", setValues);
        }
    }

    static {
        simpleConfigurators.put("http.port", "server.network-config.network-listeners.network-listener.http-listener-1.port={0}");
        simpleConfigurators.put("https.port", "server.network-config.network-listeners.network-listener.http-listener-2.port={0}");
    }
}

