/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp;

import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.nio.channels.SelectionKey;

public class SuspendResponseUtils {
    private static final ThreadLocal<Boolean> SUSPENDED_IN_CURRENT_THREAD = new ThreadLocal();
    private static final String SUSPENDED_RESPONSE_ATTR = "SuspendedResponse";

    public static void attach(SelectionKey selectionKey, Response.ResponseAttachment suspendedResponse) {
        Object attachment = selectionKey.attachment();
        if (attachment == null || !(attachment instanceof ThreadAttachment)) {
            attachment = SuspendResponseUtils.obtainThreadAttachment();
            selectionKey.attach(attachment);
        }
        ThreadAttachment threadAttachment = (ThreadAttachment)attachment;
        suspendedResponse.setThreadAttachment(threadAttachment);
        suspendedResponse.resetTimeout();
        threadAttachment.setIdleTimeoutDelay(suspendedResponse.getIdleTimeoutDelay());
        threadAttachment.setTimeoutListener(suspendedResponse);
        threadAttachment.setKeySelectionListener(suspendedResponse);
        threadAttachment.setAttribute(SUSPENDED_RESPONSE_ATTR, suspendedResponse);
    }

    public static void detach(SelectionKey selectionKey) {
        Object attachment = selectionKey.attachment();
        if (attachment != null && attachment instanceof ThreadAttachment) {
            ThreadAttachment threadAttachment = (ThreadAttachment)attachment;
            threadAttachment.removeAttribute(SUSPENDED_RESPONSE_ATTR);
            threadAttachment.setIdleTimeoutDelay(Long.MIN_VALUE);
            threadAttachment.setTimeoutListener(null);
            threadAttachment.setKeySelectionListener(null);
        }
    }

    public static Response.ResponseAttachment get(SelectionKey selectionKey) {
        Object attachment = selectionKey.attachment();
        if (attachment != null && attachment instanceof ThreadAttachment) {
            return (Response.ResponseAttachment)((ThreadAttachment)attachment).getAttribute(SUSPENDED_RESPONSE_ATTR);
        }
        return null;
    }

    private static ThreadAttachment obtainThreadAttachment() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof WorkerThread) {
            return ((WorkerThread)currentThread).getAttachment();
        }
        return new ThreadAttachment();
    }

    public static boolean isSuspendedInCurrentThread() {
        return SUSPENDED_IN_CURRENT_THREAD.get() == Boolean.TRUE;
    }

    public static void setSuspendedInCurrentThread() {
        SUSPENDED_IN_CURRENT_THREAD.set(Boolean.TRUE);
    }

    public static boolean removeSuspendedInCurrentThread() {
        boolean result = SUSPENDED_IN_CURRENT_THREAD.get() == Boolean.TRUE;
        SUSPENDED_IN_CURRENT_THREAD.remove();
        return result;
    }
}

