/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.store;

import com.sun.enterprise.security.store.AsadminTruststore;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.Console;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.logging.Logger;

public class AsadminSecurityUtil {
    private static AsadminSecurityUtil instance = null;
    private static final Logger logger = LogDomains.getLogger(AsadminSecurityUtil.class, "javax.enterprise.system.tools.admin");
    private AsadminTruststore asadminTruststore = null;
    private KeyStore asadminKeystore = null;
    private static final LocalStringsImpl strmgr = new LocalStringsImpl(AsadminSecurityUtil.class);

    public static synchronized AsadminSecurityUtil getInstance(char[] commandLineMasterPassword, boolean isPromptable) {
        if (instance == null) {
            instance = new AsadminSecurityUtil(commandLineMasterPassword, isPromptable);
        }
        return instance;
    }

    public static synchronized AsadminSecurityUtil getInstance(boolean isPromptable) {
        return AsadminSecurityUtil.getInstance(null, isPromptable);
    }

    public static char[] getAsadminTruststorePassword() {
        return System.getProperty("javax.net.ssl.trustStorePassword", "changeit").toCharArray();
    }

    private AsadminSecurityUtil(char[] commandLineMasterPassword, boolean isPromptable) {
        try {
            this.init(commandLineMasterPassword, isPromptable);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private char[] promptForPassword() throws IOException {
        Console cons = System.console();
        if (cons != null) {
            return cons.readPassword(strmgr.get("certificateDbPrompt"), new Object[0]);
        }
        return null;
    }

    public AsadminTruststore getAsadminTruststore() {
        return this.asadminTruststore;
    }

    public KeyStore getAsadminKeystore() {
        return this.asadminKeystore;
    }

    private void init(char[] commandLineMasterPassword, boolean isPromptable) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        char[] passwordToUse = this.chooseMasterPassword(commandLineMasterPassword);
        try {
            this.asadminKeystore = this.openKeystore(passwordToUse);
            logger.finer("Loaded keystore using command or default master password");
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof UnrecoverableKeyException) {
                if (!isPromptable) {
                    throw ex;
                }
                passwordToUse = this.promptForPassword();
                if (passwordToUse == null) {
                    throw new IllegalArgumentException();
                }
                this.asadminKeystore = this.openKeystore(passwordToUse);
                logger.finer("Loaded keystore using prompted master password");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.asadminTruststore = this.openTruststore(passwordToUse);
    }

    private AsadminTruststore openTruststore(char[] password) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        return AsadminTruststore.newInstance(password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore openKeystore(char[] candidateMasterPassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore permanentKS = KeyStore.getInstance("JKS");
        InputStream keyStoreStream = null;
        try {
            keyStoreStream = this.asadminKeyStoreStream();
            permanentKS.load(keyStoreStream, candidateMasterPassword);
            KeyStore keyStore = permanentKS;
            return keyStore;
        }
        finally {
            if (keyStoreStream != null) {
                keyStoreStream.close();
            }
        }
    }

    private char[] chooseMasterPassword(char[] commandMasterPassword) {
        return commandMasterPassword == null ? this.defaultMasterPassword() : commandMasterPassword;
    }

    private InputStream asadminKeyStoreStream() throws FileNotFoundException {
        String location = System.getProperty("javax.net.ssl.keyStore");
        return new BufferedInputStream(new FileInputStream(location));
    }

    private char[] defaultMasterPassword() {
        return System.getProperty("javax.net.ssl.trustStorePassword", "changeit").toCharArray();
    }
}

