/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.IntrospectionScanner;
import com.sun.hk2.component.LazyInhabitant;
import java.util.HashSet;
import java.util.Stack;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.FieldModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.InjectionTarget;

@Service
public class ConfiguredScanner
implements IntrospectionScanner {
    @Inject
    Habitat habitat;
    ParsingContext context;

    public void parse(ParsingContext context, Holder<ClassLoader> loader) {
        this.context = context;
        AnnotationType configured = (AnnotationType)context.getTypes().getBy(Configured.class.getName());
        if (configured == null) {
            return;
        }
        for (AnnotatedElement ae : configured.allAnnotatedTypes()) {
            if (!(ae instanceof ExtensibleType)) continue;
            MultiMap metadata = new MultiMap();
            this.parse((ExtensibleType)ae, (MultiMap<String, String>)metadata);
            AnnotationModel c = ae.getAnnotation(Configured.class.getName());
            String elementName = (String)c.getValues().get("value");
            if (elementName == null || elementName.length() == 0) {
                elementName = Dom.convertName(ae.getName().substring(ae.getName().lastIndexOf(46)));
            }
            String typeName = ae.getName() + "Injector";
            LazyInhabitant inhabitant = new LazyInhabitant(this.habitat, loader, typeName, metadata);
            this.habitat.addIndex((Inhabitant)inhabitant, InjectionTarget.class.getName(), ae.getName());
            this.habitat.addIndex((Inhabitant)inhabitant, ConfigInjector.class.getName(), elementName);
        }
    }

    private void parse(ExtensibleType<?> type, MultiMap<String, String> metadata) {
        Stack<Object> q = new Stack<Object>();
        HashSet<ExtensibleType> visited = new HashSet<ExtensibleType>();
        q.push(type);
        while (!q.isEmpty()) {
            ExtensibleType t = (ExtensibleType)q.pop();
            if (!visited.add(t)) continue;
            if (t instanceof ClassModel) {
                for (FieldModel f : ((ClassModel)t).getFields()) {
                    this.generate(f);
                }
            }
            for (MethodModel m : t.getMethods()) {
                this.generate(m, metadata);
            }
            for (InterfaceModel child : t.getInterfaces()) {
                q.add(child);
            }
            if (t.getParent() == null) continue;
            q.add(t.getParent());
        }
    }

    private void generate(FieldModel f) {
        throw new RuntimeException("Not implemented");
    }

    private void generate(MethodModel m, MultiMap<String, String> metadata) {
        AnnotationModel attribute = m.getAnnotation(Attribute.class.getName());
        AnnotationModel element = m.getAnnotation(Element.class.getName());
        if (attribute != null) {
            this.generateAttribute(attribute, m, metadata);
            if (element != null) {
                throw new RuntimeException("Cannot have both @Element and @Attribute at the same time on method " + m.getName());
            }
        } else if (element != null) {
            this.generateElement(element, m, metadata);
        }
    }

    private void generateAttribute(AnnotationModel attribute, MethodModel m, MultiMap<String, String> metadata) {
        String refTypeAsString;
        String name = Dom.convertName(m.getName());
        String xmlTokenName = '@' + name;
        boolean isRequired = Boolean.parseBoolean((String)attribute.getValues().get("isRequired"));
        metadata.add((Object)xmlTokenName, (Object)(isRequired ? "required" : "optional"));
        String defaultValue = (String)attribute.getValues().get("default");
        if (defaultValue != null && !defaultValue.isEmpty()) {
            if (defaultValue.indexOf(44) != -1) {
                metadata.add((Object)xmlTokenName, (Object)("\"default:" + defaultValue + '\"'));
            } else {
                metadata.add((Object)xmlTokenName, (Object)("default:" + defaultValue));
            }
        }
        String signature = m.getSignature();
        String[] arguments = m.getArgumentTypes();
        if (arguments.length == 0) {
            refTypeAsString = m.getReturnType();
        } else {
            if (arguments.length != 1) {
                throw new RuntimeException("@Attribute method cannot have more than 1 argument " + m.getSignature());
            }
            refTypeAsString = arguments[0];
        }
        metadata.add((Object)xmlTokenName, (Object)("datatype:" + refTypeAsString));
        Type refType = this.context.getTypes().getBy(refTypeAsString);
        boolean isReference = Boolean.parseBoolean((String)attribute.getValues().get("isReference"));
        if (refType == null || isReference) {
            metadata.add((Object)xmlTokenName, (Object)this.makeCollectionIfNecessary(refTypeAsString, "leaf"));
        } else {
            metadata.add((Object)xmlTokenName, (Object)this.makeCollectionIfNecessary(refTypeAsString, refTypeAsString));
        }
        Boolean isKey = (Boolean)attribute.getValues().get("key");
        if (isKey != null && isKey.booleanValue()) {
            metadata.add((Object)"key", (Object)xmlTokenName);
            metadata.add((Object)"keyed-as", (Object)m.getDeclaringType().getName());
        }
    }

    private String makeCollectionIfNecessary(String type, String value) {
        if (type.startsWith("List")) {
            return "collection:" + value;
        }
        return value;
    }

    private void generateElement(AnnotationModel element, MethodModel m, MultiMap<String, String> metadata) {
        String refTypeAsString;
        String name = Dom.convertName(m.getName());
        String xmlTokenName = "<" + name + ">";
        String[] arguments = m.getArgumentTypes();
        if (arguments.length == 0) {
            refTypeAsString = m.getReturnType();
        } else {
            if (arguments.length != 1) {
                throw new RuntimeException("@Element method cannot have more than 1 argument " + m.getSignature());
            }
            refTypeAsString = arguments[0];
        }
        boolean isReference = Boolean.parseBoolean((String)element.getValues().get("isReference"));
        Type refType = this.context.getTypes().getBy(refTypeAsString);
        if (refType == null || isReference) {
            metadata.add((Object)xmlTokenName, (Object)this.makeCollectionIfNecessary(refTypeAsString, "leaf"));
        } else {
            metadata.add((Object)xmlTokenName, (Object)this.makeCollectionIfNecessary(refTypeAsString, refTypeAsString));
        }
    }
}

