/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.Configurator;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.GlassFishException;
import org.jvnet.hk2.component.Habitat;

class ConfiguratorImpl
implements Configurator {
    Habitat habitat;
    private static final Map<String, String[]> httpListeners = new HashMap<String, String[]>();

    public ConfiguratorImpl(Habitat habitat) {
        this.habitat = habitat;
    }

    public void configure(Properties bootstrapProps) throws GlassFishException {
        CommandRunner commandRunner = this.habitat.getComponent(CommandRunner.class);
        for (String key : httpListeners.keySet()) {
            String configuredVal = bootstrapProps.getProperty(key);
            if (configuredVal == null) continue;
            String[] values = httpListeners.get(key);
            values[0] = MessageFormat.format(values[0], configuredVal);
            commandRunner.run("create-http-listener", values);
        }
    }

    static {
        httpListeners.put("http.port", new String[]{"--listenerport={0}", "--listeneraddress=0.0.0.0", "--defaultvs=server", "listener_id=embedded-listener-__1__"});
        httpListeners.put("https.port", new String[]{"--listenerport={0}", "--listeneraddress=0.0.0.0", "--defaultvs=server", "--securityenabled=true", "listener_id=embedded-listener-__2__"});
    }
}

