/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class SecurityUpgradeService
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Configs configs;
    @Inject
    ServerEnvironment env;
    private static final String DIR_GENERATED_POLICY = "generated" + File.separator + "policy";

    public void postConstruct() {
        File[] applicationDirs;
        for (Config config : this.configs.getConfig()) {
            SecurityService service = config.getSecurityService();
            if (service == null) continue;
            this.upgradeJACCProvider(service);
        }
        String instanceRoot = this.env.getInstanceRoot().getAbsolutePath();
        File genPolicyDir = new File(instanceRoot, DIR_GENERATED_POLICY);
        if (genPolicyDir != null && (applicationDirs = genPolicyDir.listFiles()) != null) {
            for (File policyDir : applicationDirs) {
                this.deleteFile(genPolicyDir);
            }
        }
    }

    private void upgradeJACCProvider(SecurityService securityService) {
        try {
            List<JaccProvider> jaccProviders = securityService.getJaccProvider();
            for (JaccProvider jacc : jaccProviders) {
                if (!"com.sun.enterprise.security.jacc.provider.SimplePolicyConfigurationFactory".equals(jacc.getPolicyConfigurationFactoryProvider())) continue;
                return;
            }
            ConfigSupport.apply(new SingleConfigCode<SecurityService>(){

                @Override
                public Object run(SecurityService secServ) throws PropertyVetoException, TransactionFailure {
                    JaccProvider jacc = secServ.createChild(JaccProvider.class);
                    jacc.setName("simple");
                    jacc.setPolicyConfigurationFactoryProvider("com.sun.enterprise.security.jacc.provider.SimplePolicyConfigurationFactory");
                    jacc.setPolicyProvider("com.sun.enterprise.security.jacc.provider.SimplePolicyProvider");
                    secServ.getJaccProvider().add(jacc);
                    return secServ;
                }
            }, securityService);
        }
        catch (TransactionFailure ex) {
            Logger.getAnonymousLogger().log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private boolean deleteFile(File path) {
        if (path != null && path.exists()) {
            if (path.isDirectory()) {
                File[] files;
                for (File file : files = path.listFiles()) {
                    if (file.isDirectory()) {
                        this.deleteFile(file);
                        file.delete();
                        continue;
                    }
                    file.delete();
                }
            }
            path.delete();
        }
        return true;
    }
}

