/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.classmodel;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;

public abstract class ClassPath {
    public LinkedHashSet<String> classPathEntries = new LinkedHashSet();
    public LinkedHashSet<String> expandedClassPathEntries = new LinkedHashSet();

    public static ClassPath create(Habitat h, boolean allowTestClassPath) {
        return new ClassPath(allowTestClassPath){};
    }

    public static ClassPath create(Habitat h, String classPath) {
        return new ClassPath(classPath){};
    }

    public static ClassPath create(Habitat h, Collection<File> classPath) {
        return new ClassPath((Collection)classPath){};
    }

    protected ClassPath(boolean allowTestClassPath) {
        String classPath;
        String string = classPath = allowTestClassPath ? System.getProperty("surefire.test.class.path") : null;
        if (null == classPath) {
            classPath = System.getProperty("java.class.path");
        }
        this.initialize(classPath);
    }

    public ClassPath(String classPath) {
        this.initialize(classPath);
    }

    public ClassPath(Collection<File> classPath) {
        if (null != classPath) {
            for (File file : classPath) {
                this.initialize(file.getAbsolutePath());
            }
        }
    }

    protected void initialize(String classPath) {
        if (classPath != null) {
            String[] filenames;
            for (String filename : filenames = classPath.split(File.pathSeparator)) {
                if (filename.equals("")) continue;
                File classpathEntry = new File(filename);
                this.classPathEntries.add(classpathEntry.getAbsolutePath());
                ClassPath.addTransitiveJars(this.expandedClassPathEntries, classpathEntry);
            }
        }
    }

    public String toString() {
        return "ClassPath-" + System.identityHashCode(this) + "=" + this.getEntries();
    }

    public Set<String> getEntries() {
        return Collections.unmodifiableSet(this.expandedClassPathEntries);
    }

    public Set<File> getFileEntries() {
        LinkedHashSet<File> fileEntries = new LinkedHashSet<File>();
        Logger logger = Logger.getAnonymousLogger();
        for (String fileName : this.expandedClassPathEntries) {
            File file = new File(fileName);
            if (!file.exists()) {
                logger.log(Level.FINE, "warning: {0} does not exist.", fileName);
            }
            fileEntries.add(file);
        }
        return Collections.unmodifiableSet(fileEntries);
    }

    public URL[] getRawURLs() throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>(this.classPathEntries.size());
        Logger logger = Logger.getAnonymousLogger();
        for (String fileName : this.classPathEntries) {
            File file = new File(fileName);
            if (file.exists()) {
                urls.add(file.toURL());
                continue;
            }
            logger.log(Level.FINE, "warning: {0} does not exist.", fileName);
        }
        return urls.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTransitiveJars(Set<String> cpSet, File classpathFile) {
        block9: {
            cpSet.add(classpathFile.getAbsolutePath());
            if (classpathFile.exists()) {
                try {
                    String additionalClasspath;
                    Manifest mf;
                    if (!classpathFile.isFile()) break block9;
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(classpathFile);
                        mf = jarFile.getManifest();
                    }
                    finally {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    if (mf != null && (additionalClasspath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
                        for (String classpathEntry : additionalClasspath.split(" ")) {
                            File mfClasspathFile;
                            if (classpathEntry.equals("") || !(mfClasspathFile = new File(classpathFile.getParent(), classpathEntry.trim())).exists() || cpSet.contains(mfClasspathFile.getAbsolutePath())) continue;
                            ClassPath.addTransitiveJars(cpSet, mfClasspathFile);
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getAnonymousLogger().log(Level.FINE, "an error occurred", ex);
                }
            }
        }
    }
}

