/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.glassfish;

import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASenvPropertyReader {
    private Map<String, String> envToPropMap = new HashMap<String, String>();
    private Map<String, String> props = new HashMap<String, String>();
    private File configDir;
    private File installDir;

    public ASenvPropertyReader() {
        this(GFLauncherUtils.getInstallDir());
    }

    public ASenvPropertyReader(File installDir) {
        try {
            this.installDir = SmartFile.sanitize(installDir);
            this.configDir = SmartFile.sanitize(new File(installDir, "config"));
            this.getBusy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = this.props.keySet();
        for (String key : keys) {
            sb.append(key).append("=").append(this.props.get(key)).append('\n');
        }
        return sb.toString();
    }

    private void getBusy() {
        this.setEnvToPropMap();
        this.props.put("com.sun.aas.installRoot", this.installDir.getPath());
        this.props.put("com.sun.aas.configRoot", this.configDir.getPath());
        this.setProperties();
        this.postProcess();
        File installRoot = new File(this.props.get("com.sun.aas.installRoot"));
        this.props.put("com.sun.aas.productRoot", installRoot.getParent());
    }

    private void postProcess() {
        Map<String, String> env = System.getenv();
        HashMap<String, String> all = new HashMap<String, String>(env);
        all.putAll(this.props);
        TokenResolver tr = new TokenResolver(all);
        tr.resolve(this.props);
        this.absolutize();
        this.setJavaRoot();
    }

    private void absolutize() {
        Set<String> keys = this.props.keySet();
        for (String key : keys) {
            String value = this.props.get(key);
            if (!GFLauncherUtils.isRelativePath(value)) continue;
            File f = value.startsWith(".") ? SmartFile.sanitize(new File(this.configDir, value)) : SmartFile.sanitize(new File(value));
            this.props.put(key, f.getPath());
        }
    }

    private void setJavaRoot() {
        String javaRootName = this.props.get("com.sun.aas.javaRoot");
        if (this.isValidJavaRoot(javaRootName)) {
            return;
        }
        javaRootName = System.getenv("JAVA_HOME");
        if (this.isValidJavaRoot(javaRootName)) {
            javaRootName = SmartFile.sanitize(new File(javaRootName)).getPath();
            this.props.put("com.sun.aas.javaRoot", javaRootName);
            return;
        }
        javaRootName = System.getProperty("java.home") + "/..";
        if (this.isValidJavaRoot(javaRootName)) {
            javaRootName = SmartFile.sanitize(new File(javaRootName)).getPath();
            this.props.put("com.sun.aas.javaRoot", javaRootName);
            return;
        }
        javaRootName = System.getProperty("java.home");
        if (this.isValidJavaRoot(javaRootName)) {
            javaRootName = SmartFile.sanitize(new File(javaRootName)).getPath();
            this.props.put("com.sun.aas.javaRoot", javaRootName);
            return;
        }
        this.props.put("com.sun.aas.javaRoot", null);
    }

    private boolean isValidJavaRoot(String javaRootName) {
        if (!GFLauncherUtils.ok(javaRootName)) {
            return false;
        }
        File f = new File(javaRootName);
        f = GFLauncherUtils.isWindows() ? new File(f, "bin/java.exe") : new File(f, "bin/java");
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperties() {
        String hostname = "localhost";
        try {
            hostname = GFLauncherUtils.getCanonicalHostName();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.props.put("com.sun.aas.hostName", hostname);
        File asenv = GFLauncherUtils.isWindows() ? new File(this.configDir, "asenv.bat") : new File(this.configDir, "asenv.conf");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(asenv));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.setProperty(line);
            }
        }
        catch (Exception ex) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    private void setProperty(String line) {
        int pos = line.indexOf("=");
        if (pos > 0) {
            String lhs = line.substring(0, pos).trim();
            String rhs = line.substring(pos + 1).trim();
            if (GFLauncherUtils.isWindows()) {
                lhs = lhs.substring(3).trim();
            } else {
                pos = rhs.indexOf("\"");
                if (pos != -1 && (pos = (rhs = rhs.substring(pos + 1).trim()).indexOf("\"")) != -1) {
                    rhs = rhs.substring(0, pos).trim();
                }
            }
            String systemPropertyName = this.envToPropMap.get(lhs);
            if (systemPropertyName != null) {
                this.props.put(systemPropertyName, rhs);
            }
        }
    }

    private void setEnvToPropMap() {
        this.envToPropMap.put("AS_DERBY_INSTALL", "com.sun.aas.derbyRoot");
        this.envToPropMap.put("AS_IMQ_LIB", "com.sun.aas.imqLib");
        this.envToPropMap.put("AS_IMQ_BIN", "com.sun.aas.imqBin");
        this.envToPropMap.put("AS_CONFIG", "com.sun.aas.configRoot");
        this.envToPropMap.put("AS_INSTALL", "com.sun.aas.installRoot");
        this.envToPropMap.put("AS_JAVA", "com.sun.aas.javaRoot");
        this.envToPropMap.put("AS_DEF_DOMAINS_PATH", "com.sun.aas.domainsRoot");
        this.envToPropMap.put("AS_DEF_NODES_PATH", "com.sun.aas.agentRoot");
    }
}

