/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.glassfish;

import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFLauncherUtils {
    private static File installDir;

    private GFLauncherUtils() {
    }

    public static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean safeExists(File f) {
        return f != null && f.exists();
    }

    public static boolean safeIsDirectory(File f) {
        return f != null && f.isDirectory();
    }

    public static synchronized File getInstallDir() {
        GFLauncherUtils.setInstallDirFromSystemProp();
        if (installDir == null) {
            String resourceName = GFLauncherUtils.class.getName().replace(".", "/") + ".class";
            URL resource = GFLauncherUtils.class.getClassLoader().getResource(resourceName);
            if (resource == null) {
                return null;
            }
            if (!resource.getProtocol().equals("jar")) {
                return null;
            }
            try {
                JarURLConnection c = (JarURLConnection)resource.openConnection();
                URL jarFile = c.getJarFileURL();
                File f = SmartFile.sanitize(new File(jarFile.toURI()));
                f = f.getParentFile();
                if (f == null) {
                    return null;
                }
                if ((f = f.getParentFile()) == null) {
                    return null;
                }
                installDir = SmartFile.sanitize(f);
            }
            catch (Exception e) {
                installDir = null;
            }
        }
        return installDir;
    }

    public static boolean isWindows() {
        String osname = System.getProperty("os.name");
        if (osname == null || osname.length() <= 0) {
            return false;
        }
        return (osname = osname.toLowerCase()).indexOf("windows") >= 0;
    }

    @Deprecated
    public static String getCanonicalHostName() throws UnknownHostException {
        return NetUtils.getCanonicalHostName();
    }

    public static String replace(String s, String token, String replace) {
        if (s == null || s.length() <= 0 || token == null || token.length() <= 0) {
            return s;
        }
        int index = s.indexOf(token);
        if (index < 0) {
            return s;
        }
        int tokenLength = token.length();
        String ret = s.substring(0, index);
        ret = ret + replace;
        ret = ret + s.substring(index + tokenLength);
        return ret;
    }

    public static boolean isRelativePath(String path) {
        if (!GFLauncherUtils.ok(path)) {
            return false;
        }
        if (path.startsWith(".")) {
            return true;
        }
        if (path.indexOf("/.") >= 0) {
            return true;
        }
        return path.indexOf("\\.") >= 0;
    }

    public static List<File> stringToFiles(String cp) {
        ArrayList<File> list = new ArrayList<File>();
        if (GFLauncherUtils.ok(cp)) {
            String[] ss;
            cp = SmartFile.sanitizePaths(cp);
            for (String s : ss = cp.split(File.pathSeparator)) {
                list.add(new File(s));
            }
        }
        return list;
    }

    public static String fileListToPathString(List<File> files) {
        StringBuilder sb = new StringBuilder();
        boolean firstFile = true;
        for (File f : files) {
            if (firstFile) {
                firstFile = false;
            } else {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(f.getPath().replace('\\', '/'));
        }
        return sb.toString();
    }

    private static void setInstallDirFromSystemProp() {
        String installRootDirName = System.getProperty("com.sun.aas.installRoot");
        if (!GFLauncherUtils.ok(installRootDirName)) {
            return;
        }
        File f = SmartFile.sanitize(new File(installRootDirName));
        if (f.isDirectory()) {
            installDir = f;
        }
    }
}

