/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.DirectoryClassLoader;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.JDK;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.component.Habitat;

public class AsadminMain {
    private static String classPath;
    private static String className;
    private static String command;
    private static ProgramOptions po;
    private static Habitat habitat;
    private static Logger logger;
    private static final int ERROR = 1;
    private static final int CONNECTION_ERROR = 2;
    private static final int INVALID_COMMAND_ERROR = 3;
    private static final int SUCCESS = 0;
    private static final int WARNING = 4;
    private static final String ADMIN_CLI_LOGGER = "com.sun.enterprise.admin.cli";
    private static final String DEBUG_FLAG = "Debug";
    private static final String ENV_DEBUG_FLAG = "AS_DEBUG";
    private static final LocalStringsImpl strings;

    public static void main(String[] args) {
        int minor = JDK.getMinor();
        if (minor < 6) {
            System.err.println(strings.get("OldJdk", new Object[]{"" + minor}));
            System.exit(1);
        }
        String sys = System.getProperty(DEBUG_FLAG);
        boolean env = Boolean.parseBoolean(System.getenv(ENV_DEBUG_FLAG));
        boolean trace = Boolean.parseBoolean(System.getenv("AS_TRACE"));
        boolean debug = sys != null || env;
        logger = Logger.getLogger(ADMIN_CLI_LOGGER);
        if (trace) {
            logger.setLevel(Level.FINEST);
        } else if (debug) {
            logger.setLevel(Level.FINER);
        } else {
            logger.setLevel(Level.FINE);
        }
        logger.setUseParentHandlers(false);
        CLILoggerHandler h = new CLILoggerHandler();
        h.setLevel(logger.getLevel());
        logger.addHandler(h);
        Logger rlogger = Logger.getLogger("");
        rlogger.setUseParentHandlers(false);
        for (Handler lh : rlogger.getHandlers()) {
            rlogger.removeHandler(lh);
        }
        rlogger.addHandler(h);
        if (CLIConstants.debugMode) {
            System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
            logger.finer("CLASSPATH= " + System.getProperty("java.class.path") + "\nCommands: " + Arrays.toString(args));
        }
        ClassLoader ecl = AsadminMain.class.getClassLoader();
        try {
            File inst = new File(System.getProperty("com.sun.aas.installRoot"));
            File ext = new File(new File(inst, "lib"), "asadmin");
            logger.finer("asadmin extension directory: " + ext);
            if (ext.isDirectory()) {
                ecl = new DirectoryClassLoader(ext, ecl);
            } else {
                logger.info(strings.get("ExtDirMissing", new Object[]{ext}));
            }
        }
        catch (IOException ex) {
            logger.info(strings.get("ExtDirFailed", new Object[]{ex}));
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader(ecl);
        StaticModulesRegistry registry = new StaticModulesRegistry(ecl);
        habitat = registry.createHabitat("default");
        classPath = SmartFile.sanitizePaths((String)System.getProperty("java.class.path"));
        className = AsadminMain.class.getName();
        if (args.length == 0) {
            args = new String[]{"multimode"};
        }
        if (args[0].equals("-V")) {
            args = new String[]{"version"};
        }
        command = args[0];
        int exitCode = AsadminMain.executeCommand(args);
        switch (exitCode) {
            case 0: {
                if (po.isTerse()) break;
                logger.fine(strings.get("CommandSuccessful", new Object[]{command}));
                break;
            }
            case 4: {
                logger.fine(strings.get("CommandSuccessfulWithWarnings", new Object[]{command}));
                exitCode = 0;
                break;
            }
            case 1: {
                logger.fine(strings.get("CommandUnSuccessful", new Object[]{command}));
                break;
            }
            case 3: {
                logger.fine(strings.get("CommandUnSuccessful", new Object[]{command}));
                break;
            }
            case 2: {
                logger.fine(strings.get("CommandUnSuccessful", new Object[]{command}));
            }
        }
        CLIUtil.writeCommandToDebugLog(args, exitCode);
        System.exit(exitCode);
    }

    public static int executeCommand(String[] argv) {
        CLICommand cmd = null;
        Environment env = new Environment();
        try {
            if (argv.length > 0 && argv[0].startsWith("-")) {
                Parser rcp = new Parser(argv, 0, ProgramOptions.getValidOptions(), false);
                ParameterMap params = rcp.getOptions();
                po = new ProgramOptions(params, env);
                List<String> operands = rcp.getOperands();
                argv = operands.toArray(new String[operands.size()]);
            } else {
                po = new ProgramOptions(env);
            }
            po.toEnvironment(env);
            po.setClassPath(classPath);
            po.setClassName(className);
            if (argv.length == 0) {
                argv = po.isHelp() ? new String[]{"help"} : new String[]{"multimode"};
            }
            command = argv[0];
            habitat.addComponent("environment", (Object)env);
            habitat.addComponent("program-options", (Object)po);
            cmd = CLICommand.getCommand(habitat, command);
            return cmd.execute(argv);
        }
        catch (CommandValidationException cve) {
            logger.severe(cve.getMessage());
            if (cmd == null) {
                AsadminMain.printUsage();
            } else {
                logger.severe(cmd.getUsage());
            }
            return 1;
        }
        catch (InvalidCommandException ice) {
            logger.severe(ice.getMessage());
            try {
                CLIUtil.displayClosestMatch(command, CLIUtil.getAllCommands(habitat, po, env), strings.get("ClosestMatchedLocalAndRemoteCommands"));
            }
            catch (InvalidCommandException e) {
                // empty catch block
            }
            return 1;
        }
        catch (CommandException ce) {
            if (ce.getCause() instanceof ConnectException) {
                logger.severe(ce.getMessage());
                try {
                    CLIUtil.displayClosestMatch(command, CLIUtil.getLocalCommands(habitat), strings.get("ClosestMatchedLocalCommands"));
                }
                catch (InvalidCommandException e) {
                    logger.info(strings.get("InvalidRemoteCommand", new Object[]{command}));
                }
            } else {
                logger.severe(ce.getMessage());
            }
            return 1;
        }
    }

    private static void printUsage() {
        logger.severe(strings.get("Asadmin.usage"));
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static {
        strings = new LocalStringsImpl(AsadminMain.class);
        Map systemProps = new ASenvPropertyReader().getProps();
        String ir = "com.sun.aas.installRoot";
        String cr = "com.sun.aas.configRoot";
        String irVal = (String)systemProps.get("com.sun.aas.installRoot");
        String crVal = (String)systemProps.get("com.sun.aas.configRoot");
        if (AsadminMain.ok(irVal)) {
            System.setProperty("com.sun.aas.installRoot", irVal);
        }
        if (AsadminMain.ok(crVal)) {
            System.setProperty("com.sun.aas.configRoot", crVal);
        }
    }

    private static class CLILoggerHandler
    extends ConsoleHandler {
        private CLILoggerHandler() {
        }

        public void publish(LogRecord logRecord) {
            if (!this.isLoggable(logRecord)) {
                return;
            }
            if (logRecord.getLevel() == Level.SEVERE) {
                System.err.println(logRecord.getMessage());
            } else {
                System.out.println(logRecord.getMessage());
            }
        }
    }
}

