/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.bootstrap.ArgumentManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Properties;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;

public class GlassFishMain {
    public static void main(String[] args) throws Exception {
        ASMainHelper.checkJdkVersion();
        Properties argsAsProps = ArgumentManager.argsToMap(args);
        String platform = ASMainHelper.whichPlatform();
        System.out.println("Launching GlassFish on " + platform + " platform");
        System.setProperty("GlassFish_Platform", platform);
        File installRoot = ASMainHelper.findInstallRoot();
        File instanceRoot = ASMainHelper.findInstanceRoot(installRoot, argsAsProps);
        Properties ctx = ASMainHelper.buildStartupContext(platform, installRoot, instanceRoot, args);
        ClassLoader launcherCL = ASMainHelper.createLauncherCL(ctx, ClassLoader.getSystemClassLoader().getParent());
        Class<?> launcherClass = launcherCL.loadClass(Launcher.class.getName());
        Object launcher = launcherClass.newInstance();
        Method method = launcherClass.getMethod("launch", Properties.class);
        method.invoke(launcher, ctx);
    }

    public static class Launcher {
        private static volatile GlassFish gf;
        private static volatile GlassFishRuntime gfr;

        public void launch(Properties ctx) throws Exception {
            Launcher.addShutdownHook();
            gfr = GlassFishRuntime.bootstrap(new BootstrapProperties(ctx), this.getClass().getClassLoader());
            gf = gfr.newGlassFish(new GlassFishProperties(ctx));
            if (Boolean.valueOf(Util.getPropertyOrSystemProperty(ctx, "GlassFish_Interactive", "false")).booleanValue()) {
                this.startConsole();
            } else {
                gf.start();
            }
        }

        private void startConsole() throws IOException {
            String command;
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while ((command = this.readCommand(reader)) != null) {
                try {
                    String[] tokens;
                    Deployer deployer;
                    System.out.println("command = " + command);
                    if ("start".equalsIgnoreCase(command)) {
                        if (gf.getStatus() != GlassFish.Status.STARTED || gf.getStatus() == GlassFish.Status.STOPPING || gf.getStatus() == GlassFish.Status.STARTING) {
                            gf.start();
                            continue;
                        }
                        System.out.println("Already started or stopping or starting");
                        continue;
                    }
                    if ("stop".equalsIgnoreCase(command)) {
                        if (gf.getStatus() != GlassFish.Status.STARTED) {
                            System.out.println("GlassFish is not started yet. Please execute start first.");
                            continue;
                        }
                        gf.stop();
                        continue;
                    }
                    if (command.startsWith("deploy")) {
                        if (gf.getStatus() != GlassFish.Status.STARTED) {
                            System.out.println("GlassFish is not started yet. Please execute start first.");
                            continue;
                        }
                        deployer = gf.getService(Deployer.class, null);
                        tokens = command.split("\\s");
                        if (tokens.length < 2) {
                            System.out.println("Syntax: deploy <options> file");
                            continue;
                        }
                        File file = new File(tokens[tokens.length - 1]);
                        String[] params = Arrays.copyOfRange(tokens, 1, tokens.length - 1);
                        String name = deployer.deploy(file.toURI(), params);
                        System.out.println("Deployed = " + name);
                        continue;
                    }
                    if (command.startsWith("undeploy")) {
                        if (gf.getStatus() != GlassFish.Status.STARTED) {
                            System.out.println("GlassFish is not started yet. Please execute start first.");
                            continue;
                        }
                        deployer = gf.getService(Deployer.class, null);
                        String name = command.substring(command.indexOf(" ")).trim();
                        deployer.undeploy(name, new String[0]);
                        System.out.println("Undeployed = " + name);
                        continue;
                    }
                    if ("quit".equalsIgnoreCase(command)) {
                        System.exit(0);
                        continue;
                    }
                    if (gf.getStatus() != GlassFish.Status.STARTED) {
                        System.out.println("GlassFish is not started yet. Please execute start first.");
                        continue;
                    }
                    CommandRunner cmdRunner = gf.getCommandRunner();
                    tokens = command.split("\\s");
                    CommandResult result = cmdRunner.run(tokens[0], Arrays.copyOfRange(tokens, 1, tokens.length));
                    System.out.println((Object)result.getExitStatus());
                    System.out.println(result.getOutput());
                    if (result.getFailureCause() == null) continue;
                    result.getFailureCause().printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private String readCommand(BufferedReader reader) throws IOException {
            this.prompt();
            String command = null;
            while ((command = reader.readLine()) != null && command.isEmpty()) {
            }
            return command;
        }

        private void prompt() {
            System.out.print("Enter any of the following commands: start, stop, quit, deploy <path to file>, undeploy <name of app>\nglassfish$ ");
            System.out.flush();
        }

        private static void addShutdownHook() {
            Runtime.getRuntime().addShutdownHook(new Thread("GlassFish Shutdown Hook"){

                public void run() {
                    try {
                        if (gf != null) {
                            gf.stop();
                        }
                        gfr.shutdown();
                    }
                    catch (Exception ex) {
                        System.err.println("Error stopping framework: " + ex);
                        ex.printStackTrace();
                    }
                }
            });
        }
    }
}

