/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractWombImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Factory;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;

public class FactoryWomb<T>
extends AbstractWombImpl<T> {
    private static final Logger logger = Logger.getLogger(FactoryWomb.class.getName());
    private final Inhabitant<? extends Factory> factory;

    public FactoryWomb(Class<T> type, Class<? extends Factory> factory, Habitat habitat, MultiMap<String, String> metadata) {
        this(type, habitat.getInhabitantByType(factory), habitat, metadata);
    }

    public FactoryWomb(Class<T> type, Inhabitant<? extends Factory> factory, Habitat habitat, MultiMap<String, String> metadata) {
        super(type, habitat, metadata);
        assert (factory != null);
        assert (habitat != null);
        this.factory = factory;
    }

    @Override
    public T create(Inhabitant onBehalfOf) throws ComponentException {
        logger.log(Level.FINER, "factory {0} invoked", this.factory);
        Object t = this.type.cast(this.factory.get().getObject());
        logger.log(Level.FINER, "factory created object {0}", t);
        this.inject(this.habitat, t, onBehalfOf);
        return t;
    }
}

