/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.EventPublishingInhabitant;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.LazyInhabitant;
import com.sun.hk2.component.RunLevelInhabitant;
import com.sun.hk2.component.ScopedInhabitant;
import com.sun.hk2.component.SingletonInhabitant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.Scope;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.component.Womb;
import org.jvnet.hk2.component.Wombs;
import org.jvnet.hk2.component.internal.runlevel.RunLevelServices;

public class Inhabitants {
    private static final RunLevelServices runLevelServices = new RunLevelServices();

    public static Inhabitant<?> createInhabitant(Habitat habitat, Holder<ClassLoader> classLoader, String typeName, MultiMap<String, String> metadata, Inhabitant<?> lead, Set<String> indicies) {
        EventPublishingInhabitant i = new LazyInhabitant(habitat, classLoader, typeName, metadata, lead);
        if (Inhabitants.contains(indicies, RunLevel.class.getName())) {
            RunLevel rl = i.getAnnotation(RunLevel.class);
            assert (null != rl) : typeName + " is a problem; " + i + " has no RunLevel annotation";
            assert (!i.isInstantiated()) : "inhabitant should not be active: " + i;
            RunLevelService<?> rls = runLevelServices.get(habitat, rl);
            InhabitantListener listener = InhabitantListener.class.isInstance(rls) ? (InhabitantListener)InhabitantListener.class.cast(rls) : null;
            int runLevel = rl.value();
            i = new RunLevelInhabitant(i, runLevel, rls.getState(), listener);
        }
        return i;
    }

    private static boolean contains(Set<String> indicies, String name) {
        if (null != indicies) {
            if (indicies.contains(name)) {
                return true;
            }
            name = name + ":";
            for (String index : indicies) {
                if (!index.startsWith(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Inhabitant<T> create(T instance) {
        return new ExistingSingletonInhabitant<T>(instance);
    }

    public static <T> Inhabitant<T> create(Class<T> c, Habitat habitat, MultiMap<String, String> metadata) {
        return Inhabitants.wrapByScope(c, Wombs.create(c, habitat, metadata), habitat);
    }

    public static <T> Inhabitant<T> wrapByScope(Class<T> c, Womb<T> womb, Habitat habitat) {
        Scoped scoped = c.getAnnotation(Scoped.class);
        if (scoped == null) {
            return new SingletonInhabitant<T>(womb);
        }
        Class<? extends Scope> scopeClass = scoped.value();
        return Inhabitants.wrapByScope(womb, habitat, scopeClass);
    }

    public static <T> Inhabitant<T> wrapByScope(Womb<T> womb, Habitat habitat, Class<? extends Scope> scopeClass) {
        if (scopeClass == PerLookup.class) {
            return womb;
        }
        if (scopeClass == Singleton.class) {
            return new SingletonInhabitant<T>(womb);
        }
        Scope scope = habitat.getByType(scopeClass);
        if (scope == null) {
            throw new ComponentException("Failed to look up %s", scopeClass);
        }
        return new ScopedInhabitant<T>(womb, scope);
    }

    public static <T> Collection<String> getNamesFor(Inhabitant<T> i, String indexName) {
        return new ArrayList<String>(i.metadata().get(indexName));
    }

    static void validate(Object target, Object injectedVal) {
        if (null != injectedVal) {
            RunLevel targetRL = AbstractInhabitantImpl.getAnnotation(target.getClass(), RunLevel.class);
            RunLevel injectedValRL = AbstractInhabitantImpl.getAnnotation(injectedVal.getClass(), RunLevel.class);
            if (null == targetRL && null != injectedValRL) {
                throw new ComponentException("invalid dependency from a non-RunLevel instance " + targetRL + " to a RunLevel instance " + injectedVal);
            }
        }
    }
}

