/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.lang.reflect.Proxy;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.WriteableView;

public interface ConfigBeanProxy {
    @DuckTyped
    public ConfigBeanProxy getParent();

    @DuckTyped
    public <T extends ConfigBeanProxy> T getParent(Class<T> var1);

    @DuckTyped
    public <T extends ConfigBeanProxy> T createChild(Class<T> var1) throws TransactionFailure;

    @DuckTyped
    public ConfigBeanProxy deepCopy(ConfigBeanProxy var1) throws TransactionFailure;

    public static class Duck {
        public static ConfigBeanProxy getParent(ConfigBeanProxy self) {
            Dom dom = Dom.unwrap(self);
            return dom.parent().createProxy();
        }

        public static <T extends ConfigBeanProxy> T getParent(ConfigBeanProxy self, Class<T> c) {
            Dom dom = Dom.unwrap(self);
            return dom.parent().createProxy(c);
        }

        public static <T extends ConfigBeanProxy> T createChild(ConfigBeanProxy self, Class<T> c) throws TransactionFailure {
            try {
                WriteableView bean = (WriteableView)WriteableView.class.cast(Proxy.getInvocationHandler(Proxy.class.cast(self)));
                return bean.allocateProxy(c);
            }
            catch (ClassCastException e) {
                throw new TransactionFailure("Must use a locked parent config object for instantiating new config object", e);
            }
        }

        public static ConfigBeanProxy deepCopy(ConfigBeanProxy self, ConfigBeanProxy parent) throws TransactionFailure {
            ConfigBean configBean = (ConfigBean)Dom.unwrap(self);
            Transaction t = Transaction.getTransaction(parent);
            if (t == null) {
                throw new TransactionFailure("Must use a locked parent config object for copying new config object");
            }
            ConfigBean copy = configBean.copy(configBean.parent());
            return t.enroll(copy.createProxy());
        }
    }
}

