/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.GlassFishImpl;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.jvnet.hk2.component.Habitat;

public class StaticGlassFishRuntime
extends GlassFishRuntime {
    private Main main;
    private HashMap gfMap = new HashMap();
    private static Logger logger = Util.getLogger();
    private static final String autoDelete = "org.glassfish.embeddable.autoDelete";

    public StaticGlassFishRuntime(Main main) {
        this.main = main;
    }

    public synchronized GlassFish newGlassFish(GlassFishProperties glassFishProperties) throws GlassFishException {
        try {
            Properties cloned = new Properties();
            cloned.putAll((Map<?, ?>)glassFishProperties.getProperties());
            final GlassFishProperties gfProps = new GlassFishProperties(cloned);
            this.setEnv(gfProps);
            StartupContext startupContext = new StartupContext(gfProps.getProperties());
            ModulesRegistry modulesRegistry = AbstractFactory.getInstance().createModulesRegistry();
            Habitat habitat = this.main.createHabitat(modulesRegistry, startupContext);
            ModuleStartup gfKernel = this.main.findStartupService(modulesRegistry, habitat, null, startupContext);
            GlassFishImpl gfImpl = new GlassFishImpl(gfKernel, habitat, gfProps.getProperties()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dispose() throws GlassFishException {
                    try {
                        super.dispose();
                    }
                    finally {
                        if ("true".equalsIgnoreCase(gfProps.getProperties().getProperty(StaticGlassFishRuntime.autoDelete)) && gfProps.getInstanceRoot() != null) {
                            Util.deleteRecursive(new File(gfProps.getInstanceRoot()));
                        }
                    }
                }
            };
            this.gfMap.put(gfProps.getInstanceRoot(), gfImpl);
            return gfImpl;
        }
        catch (Exception e) {
            throw new GlassFishException(e);
        }
    }

    public synchronized void shutdown() throws GlassFishException {
        for (Object gf : this.gfMap.values()) {
            try {
                ((GlassFish)gf).dispose();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.gfMap.clear();
        try {
            StaticGlassFishRuntime.shutdownInternal();
        }
        catch (GlassFishException ex) {
            logger.info(ex.getMessage());
        }
    }

    private void setEnv(GlassFishProperties gfProps) throws Exception {
        String instanceRootValue = gfProps.getInstanceRoot();
        if (instanceRootValue == null) {
            instanceRootValue = this.createTempInstanceRoot(gfProps);
            gfProps.setInstanceRoot(instanceRootValue);
        }
        File instanceRoot = new File(instanceRootValue);
        System.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
        System.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        String installRootValue = System.getProperty("com.sun.aas.installRoot");
        if (installRootValue == null) {
            installRootValue = instanceRoot.getAbsolutePath();
        }
        File installRoot = new File(installRootValue);
        System.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
        System.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        gfProps.getProperties().setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
        gfProps.getProperties().setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
    }

    private String createTempInstanceRoot(GlassFishProperties gfProps) throws Exception {
        String tmpDir = System.getProperty("glassfish.embedded.tmpdir");
        if (tmpDir == null) {
            tmpDir = System.getProperty("user.dir");
        }
        File instanceRoot = File.createTempFile("gfembed", "tmp", new File(tmpDir));
        instanceRoot.delete();
        instanceRoot.mkdir();
        try {
            String configDir = "config/";
            String[] resources = new String[]{"keyfile", "server.policy", "cacerts.jks", "keystore.jks", "login.conf", "admin-keyfile"};
            new File(instanceRoot, configDir).mkdirs();
            new File(instanceRoot, "docroot").mkdirs();
            ClassLoader cl = this.getClass().getClassLoader();
            for (String resource : resources) {
                String resourceName = configDir + resource;
                StaticGlassFishRuntime.copy(cl.getResource(resourceName), new File(instanceRoot.getAbsolutePath(), resourceName), false);
            }
            String configFileURI = gfProps.getConfigFileURI();
            URL configFileRL = configFileURI == null ? this.getClass().getClassLoader().getResource("org/glassfish/embed/domain.xml") : URI.create(configFileURI).toURL();
            StaticGlassFishRuntime.copy(configFileRL, new File(instanceRoot, configDir + "domain.xml"), false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        gfProps.getProperties().setProperty(autoDelete, "true");
        return instanceRoot.getAbsolutePath();
    }

    public static void copy(URL u, File destFile, boolean overwrite) {
        if (u == null || destFile == null) {
            return;
        }
        try {
            if (!(destFile.exists() && !overwrite || destFile.toURI().equals(u.toURI()))) {
                InputStream stream = u.openStream();
                destFile.getParentFile().mkdirs();
                Util.copy(stream, new FileOutputStream(destFile), stream.available());
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Copied " + u.toURI() + " to " + destFile.toURI());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

