/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.util.AbstractAdapter;

public class ReadableArchiveScannerAdapter
extends AbstractAdapter {
    final ReadableArchive archive;
    final Parser parser;
    final URI uri;

    public ReadableArchiveScannerAdapter(Parser parser, ReadableArchive archive) {
        this.archive = archive;
        this.parser = parser;
        this.uri = archive.getURI();
    }

    private ReadableArchiveScannerAdapter(Parser parser, ReadableArchive archive, URI uri) {
        this.archive = archive;
        this.parser = parser;
        this.uri = uri == null ? archive.getURI() : uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public Manifest getManifest() throws IOException {
        return this.archive.getManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSelectedEntries(ArchiveAdapter.Selector selector, ArchiveAdapter.EntryTask entryTask, final Logger logger) throws IOException {
        Enumeration<String> entries = this.archive.entries();
        while (entries.hasMoreElements()) {
            ReadableArchive subArchive;
            String explodedName;
            final String name = entries.nextElement();
            ArchiveAdapter.Entry entry = new ArchiveAdapter.Entry(name, this.archive.getEntrySize(name), false);
            if (selector.isSelected(entry)) {
                InputStream is = null;
                try {
                    try {
                        is = this.archive.getEntry(name);
                        entryTask.on(entry, is);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Exception while processing " + entry.name + " inside " + this.archive.getName() + " of size " + entry.size, e);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            if (!name.endsWith(".jar") || this.archive.exists(explodedName = name.replaceAll("[/ ]", "__").replace(".jar", "_jar")) || (subArchive = this.archive.getSubArchive(name)) == null) continue;
            ReadableArchiveScannerAdapter adapter = new ReadableArchiveScannerAdapter(this.parser, subArchive);
            this.parser.parse(adapter, new Runnable(){

                public void run() {
                    try {
                        subArchive.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Cannot close sub archive" + name, e);
                    }
                }
            });
        }
    }

    public void close() throws IOException {
    }
}

