/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.StringUtils;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.Strings;
import com.sun.enterprise.util.OS;
import java.io.File;
import java.lang.management.ManagementFactory;

public final class ProcessUtils {
    private static final int pid;
    private static final String[] paths;
    private static boolean debug;

    private ProcessUtils() {
    }

    public static void main(String[] args) {
        debug = true;
        for (String s : args) {
            System.out.println(s + " ===> " + ProcessUtils.isProcessRunning(Integer.parseInt(s)));
        }
    }

    public static File getExe(String name) {
        for (String path : paths) {
            File f = new File(path + "/" + name);
            if (!f.canExecute()) continue;
            return SmartFile.sanitize(f);
        }
        return null;
    }

    public static final int getPid() {
        return pid;
    }

    public static String kill(int pid) {
        try {
            String cmdline;
            String pidString = Integer.toString(pid);
            ProcessManager pm = null;
            if (OS.isWindowsForSure()) {
                pm = new ProcessManager("taskkill", "/F", "/T", "/pid", pidString);
                cmdline = "taskkill /F /T /pid " + pidString;
            } else {
                pm = new ProcessManager("kill", "-9", "" + pidString);
                cmdline = "kill -9 " + pidString;
            }
            pm.setEcho(false);
            pm.execute();
            int exitValue = pm.getExitValue();
            if (exitValue == 0) {
                return null;
            }
            return Strings.get("ProcessUtils.killerror", cmdline, pm.getStderr() + pm.getStdout(), "" + exitValue);
        }
        catch (ProcessManagerException ex) {
            return ex.getMessage();
        }
    }

    public static final Boolean isProcessRunning(int aPid) {
        try {
            if (OS.isWindowsForSure()) {
                return ProcessUtils.isProcessRunningWindows(aPid);
            }
            return ProcessUtils.isProcessRunningUnix(aPid);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isProcessRunningWindows(int aPid) throws ProcessManagerException {
        String pidString = Integer.toString(aPid);
        ProcessManager pm = new ProcessManager("tasklist", "/FI", "\"pid eq " + pidString + "\"");
        pm.setEcho(false);
        pm.execute();
        String out = pm.getStdout() + pm.getStderr();
        if (debug) {
            System.out.println("------------   Output from tasklist   ----------");
            System.out.println(out);
            System.out.println("------------------------------------------------");
        }
        if (StringUtils.ok(out)) {
            return out.indexOf("" + aPid) >= 0;
        }
        throw new ProcessManagerException("unknown");
    }

    private static Boolean isProcessRunningUnix(int aPid) throws ProcessManagerException {
        ProcessManager pm = new ProcessManager("kill", "-0", "" + aPid);
        pm.setEcho(false);
        pm.execute();
        int retval = pm.getExitValue();
        return retval == 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    static {
        int tempPid = -1;
        try {
            String pids = ManagementFactory.getRuntimeMXBean().getName();
            int index = -1;
            if (StringUtils.ok(pids) && (index = pids.indexOf(64)) >= 0) {
                tempPid = Integer.parseInt(pids.substring(0, index));
            }
        }
        catch (Exception e) {
            tempPid = -1;
        }
        pid = tempPid;
        String tempPaths = null;
        if (OS.isWindows()) {
            tempPaths = System.getenv("Path");
            if (!StringUtils.ok(tempPaths)) {
                tempPaths = System.getenv("PATH");
            }
        } else {
            tempPaths = System.getenv("PATH");
        }
        paths = StringUtils.ok(tempPaths) ? tempPaths.split(File.pathSeparator) : new String[0];
    }
}

