/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.AppServerStartup;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.enterprise.v3.server.ReadableArchiveScannerAdapter;
import com.sun.enterprise.v3.server.SnifferManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.ApplicationMetaDataProvider;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.monitor.DeploymentLifecycleProbeProvider;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ApplicationLifecycle
implements Deployment,
PostConstruct {
    private static final String[] UPLOADED_GENERATED_DIRS = new String[]{"policy", "xml", "ejb", "jsp"};
    @Inject
    protected SnifferManagerImpl snifferManager;
    @Inject
    Habitat habitat;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    public ApplicationRegistry appRegistry;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    protected Applications applications;
    @Inject(name="default-instance-name")
    Server server;
    @Inject
    protected Domain domain;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Events events;
    @Inject
    ConfigSupport configSupport;
    protected Logger logger = LogDomains.getLogger(AppServerStartup.class, (String)"javax.enterprise.system.core");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationLifecycle.class);
    protected DeploymentLifecycleProbeProvider deploymentLifecycleProbeProvider = null;
    private ExecutorService executorService = null;

    protected <T extends Container, U extends ApplicationContainer> Deployer<T, U> getDeployer(EngineInfo<T, U> engineInfo) {
        return engineInfo.getDeployer();
    }

    public void postConstruct() {
        this.executorService = this.createExecutorService();
        this.deploymentLifecycleProbeProvider = new DeploymentLifecycleProbeProvider();
    }

    public ArchiveHandler getArchiveHandler(ReadableArchive archive) throws IOException {
        return this.getArchiveHandler(archive, null);
    }

    public ArchiveHandler getArchiveHandler(ReadableArchive archive, String type) throws IOException {
        for (CompositeHandler handler : this.habitat.getAllByContract(CompositeHandler.class)) {
            if ((type == null || !type.equals("osgi")) && "osgi".equals(handler.getClass().getAnnotation(Service.class).name()) || !handler.handles(archive)) continue;
            return handler;
        }
        LinkedList<ArchiveHandler> handlerList = new LinkedList<ArchiveHandler>();
        for (ArchiveHandler handler : this.habitat.getAllByContract(ArchiveHandler.class)) {
            if (handler instanceof CompositeHandler || "DEFAULT".equals(handler.getClass().getAnnotation(Service.class).name())) continue;
            if ("connector".equals(handler.getClass().getAnnotation(Service.class).name())) {
                handlerList.addLast(handler);
                continue;
            }
            handlerList.addFirst(handler);
        }
        for (ArchiveHandler handler : handlerList) {
            if (!handler.handles(archive)) continue;
            return handler;
        }
        return (ArchiveHandler)this.habitat.getComponent(ArchiveHandler.class, "DEFAULT");
    }

    public ApplicationInfo deploy(ExtendedDeploymentContext context) {
        return this.deploy(null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApplicationInfo deploy(Collection<Sniffer> sniffers, final ExtendedDeploymentContext context) {
        block44: {
            block43: {
                operationStartTime = Calendar.getInstance().getTimeInMillis();
                this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_START, context));
                report = context.getActionReport();
                commandParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
                appName = commandParams.name();
                if (commandParams.origin == OpsParams.Origin.deploy && this.appRegistry.get(appName) != null) {
                    report.setMessage(ApplicationLifecycle.localStrings.getLocalString("appnamenotunique", "Application name {0} is already in use. Please pick a different name.", new Object[]{appName}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return null;
                }
                if (commandParams.virtualservers == null) {
                    commandParams.virtualservers = this.getVirtualServers(commandParams.target);
                }
                if (commandParams.enabled == null) {
                    commandParams.enabled = Boolean.TRUE;
                }
                tracker = new ProgressTracker(){

                    public void actOn(Logger logger) {
                        for (EngineRef module : this.get("started", EngineRef.class)) {
                            try {
                                module.stop((ApplicationContext)context);
                            }
                            catch (Exception e) {}
                        }
                        try {
                            ((PreDestroy)PreDestroy.class.cast(context)).preDestroy();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        for (EngineRef module : this.get("loaded", EngineRef.class)) {
                            try {
                                module.unload(context);
                            }
                            catch (Exception e) {}
                        }
                        try {
                            ApplicationInfo appInfo = ApplicationLifecycle.this.appRegistry.get(appName);
                            if (appInfo != null) {
                                ApplicationLifecycle.this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.APPLICATION_DISABLED, appInfo));
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        for (EngineRef module : this.get("prepared", EngineRef.class)) {
                            try {
                                module.clean(context);
                            }
                            catch (Exception e) {}
                        }
                        if (!commandParams.keepfailedstubs.booleanValue()) {
                            try {
                                context.clean();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ApplicationLifecycle.this.appRegistry.remove(appName);
                    }
                };
                context.addTransientAppMetaData("tracker", (Object)tracker);
                context.setPhase(ExtendedDeploymentContext.Phase.PREPARE);
                appInfo = null;
                handler = context.getArchiveHandler();
                if (handler == null) {
                    handler = this.getArchiveHandler(context.getSource(), commandParams.type);
                    context.setArchiveHandler(handler);
                }
                if ((tracing = (DeploymentTracing)context.getModuleMetaData(DeploymentTracing.class)) != null) {
                    tracing.addMark(DeploymentTracing.Mark.ARCHIVE_HANDLER_OBTAINED);
                }
                if (handler != null) ** GOTO lbl47
                report.setMessage(ApplicationLifecycle.localStrings.getLocalString("unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{context.getSourceDir()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                var12_12 = null;
                if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                    this.events.send(new EventListener.Event<Object>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                    operationTime = Calendar.getInstance().getTimeInMillis() - operationStartTime;
                    if (appInfo == null) return var12_12;
                }
                ** GOTO lbl45
                {
                    catch (Exception e) {
                        report.failure(this.logger, ApplicationLifecycle.localStrings.getLocalString("error.deploying.app", "Exception while deploying the app [{0}]", new Object[]{appName}), null);
                        report.setFailureCause(e);
                        this.logger.log(Level.SEVERE, e.getMessage(), e);
                        tracker.actOn(this.logger);
                        return null;
                    }
                    catch (Throwable var23_31) {
                        throw var23_31;
                    }
                    this.deploymentLifecycleProbeProvider.applicationDeployedEvent(appName, this.getApplicationType(appInfo), String.valueOf(operationTime));
                    return var12_12;
lbl45:
                    // 1 sources

                    this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                    return var12_12;
lbl47:
                    // 1 sources

                    clh = (ClassLoaderHierarchy)this.habitat.getByContract(ClassLoaderHierarchy.class);
                    if (tracing != null) {
                        tracing.addMark(DeploymentTracing.Mark.CLASS_LOADER_HIERARCHY);
                    }
                    context.createDeploymentClassLoader(clh, handler);
                    if (tracing != null) {
                        tracing.addMark(DeploymentTracing.Mark.CLASS_LOADER_CREATED);
                    }
                    this.getDeployableTypes((DeploymentContext)context);
                    if (tracing != null) {
                        tracing.addMark(DeploymentTracing.Mark.PARSING_DONE);
                    }
                    cloader = context.getClassLoader();
                    currentCL = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(cloader);
                        if (sniffers != null && this.logger.isLoggable(Level.FINE)) {
                            for (Sniffer sniffer : sniffers) {
                                this.logger.fine("Before Sorting" + sniffer.getModuleType());
                            }
                        }
                        sortedEngineInfos = this.setupContainerInfos(handler, sniffers, (DeploymentContext)context);
                        if (tracing != null) {
                            tracing.addMark(DeploymentTracing.Mark.CONTAINERS_SETUP_DONE);
                        }
                        if (this.logger.isLoggable(Level.FINE)) {
                            for (EngineInfo info : sortedEngineInfos) {
                                this.logger.fine("After Sorting " + info.getSniffer().getModuleType());
                            }
                        }
                        if (sortedEngineInfos == null || sortedEngineInfos.isEmpty()) {
                            report.failure(this.logger, ApplicationLifecycle.localStrings.getLocalString("unknowncontainertype", "There is no installed container capable of handling this application {0}", new Object[]{context.getSource().getName()}));
                            tracker.actOn(this.logger);
                            i$ = null;
                            Thread.currentThread().setContextClassLoader(currentCL);
                            if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) break block43;
                            this.events.send(new EventListener.Event<Object>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                            operationTime = Calendar.getInstance().getTimeInMillis() - operationStartTime;
                            if (appInfo == null) return i$;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var22_30) {}
                    {
                        Thread.currentThread().setContextClassLoader(currentCL);
                        throw var22_30;
                    }
                }
                this.deploymentLifecycleProbeProvider.applicationDeployedEvent(appName, this.getApplicationType(appInfo), String.valueOf(operationTime));
                return i$;
            }
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
            return i$;
lbl-1000:
            // 1 sources

            {
                tempAppInfo = new ApplicationInfo(this.events, context.getSource(), appName);
                for (E m : context.getModuleMetadata()) {
                    tempAppInfo.addMetaData(m);
                }
                tempAppInfo.setIsJavaEEApp(sortedEngineInfos);
                this.appRegistry.add(appName, tempAppInfo);
                this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_BEFORE_CLASSLOADER_CREATION, context), false);
                context.createApplicationClassLoader(clh, handler);
                if (tracing != null) {
                    tracing.addMark(DeploymentTracing.Mark.CLASS_LOADER_CREATED);
                }
                moduleInfo = null;
                try {
                    moduleInfo = this.prepareModule(sortedEngineInfos, appName, (DeploymentContext)context, tracker);
                }
                catch (Exception prepareException) {
                    report.failure(this.logger, "Exception while preparing the app", null);
                    report.setFailureCause(prepareException);
                    tracker.actOn(this.logger);
                    var19_25 = null;
                    Thread.currentThread().setContextClassLoader(currentCL);
                    if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                        this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                        operationTime = Calendar.getInstance().getTimeInMillis() - operationStartTime;
                        if (appInfo == null) return var19_25;
                        this.deploymentLifecycleProbeProvider.applicationDeployedEvent(appName, this.getApplicationType(appInfo), String.valueOf(operationTime));
                        return var19_25;
                    }
                    this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                    return var19_25;
                }
            }
            {
                appInfo = (ApplicationInfo)context.getModuleMetaData(ApplicationInfo.class);
                if (appInfo == null) {
                    appInfo = new ApplicationInfo(this.events, context.getSource(), appName);
                    appInfo.addModule(moduleInfo);
                    for (E m : context.getModuleMetadata()) {
                        moduleInfo.addMetaData(m);
                        appInfo.addMetaData(m);
                    }
                } else {
                    for (EngineRef ref : moduleInfo.getEngineRefs()) {
                        appInfo.add(ref);
                    }
                }
                this.appRegistry.remove(appName);
                appInfo.setIsJavaEEApp(sortedEngineInfos);
                this.appRegistry.add(appName, appInfo);
                if (tracing != null) {
                    tracing.addMark(DeploymentTracing.Mark.PREPARED);
                }
                context.setPhase(ExtendedDeploymentContext.Phase.PREPARED);
                Thread.currentThread().setContextClassLoader(context.getClassLoader());
                this.installTransformers(context);
                this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.APPLICATION_PREPARED, context), false);
                if (!this.loadOnCurrentInstance((DeploymentContext)context)) ** GOTO lbl-1000
                appInfo.setLibraries(commandParams.libraries());
                try {
                    appInfo.load(context, tracker);
                    appInfo.start(context, tracker);
                }
                catch (Exception loadException) {
                    report.failure(this.logger, "Exception while loading the app", null);
                    report.setFailureCause(loadException);
                    tracker.actOn(this.logger);
                    ref = null;
                    Thread.currentThread().setContextClassLoader(currentCL);
                    if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                        this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                        operationTime = Calendar.getInstance().getTimeInMillis() - operationStartTime;
                        if (appInfo == null) return ref;
                        this.deploymentLifecycleProbeProvider.applicationDeployedEvent(appName, this.getApplicationType(appInfo), String.valueOf(operationTime));
                        return ref;
                    }
                    this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                    return ref;
                }
            }
lbl-1000:
            // 2 sources

            {
                var18_22 = appInfo;
                Thread.currentThread().setContextClassLoader(currentCL);
                if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) break block44;
                this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                operationTime = Calendar.getInstance().getTimeInMillis() - operationStartTime;
                if (appInfo == null) return var18_22;
            }
            this.deploymentLifecycleProbeProvider.applicationDeployedEvent(appName, this.getApplicationType(appInfo), String.valueOf(operationTime));
            return var18_22;
        }
        this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
        return var18_22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Types getDeployableTypes(DeploymentContext context) throws IOException {
        DeploymentContext deploymentContext = context;
        synchronized (deploymentContext) {
            Types types = context.getModuleMetaData(Types.class);
            if (types != null) {
                return types;
            }
            try {
                ParsingContext parsingContext = new ParsingContext.Builder().logger(context.getLogger()).executorService(this.executorService).build();
                Parser parser = new Parser(parsingContext);
                ReadableArchiveScannerAdapter scannerAdapter = new ReadableArchiveScannerAdapter(parser, context.getSource());
                parser.parse(scannerAdapter, null);
                for (ReadableArchive externalLibArchive : this.getExternalLibraries(context)) {
                    ReadableArchiveScannerAdapter libAdapter = null;
                    try {
                        libAdapter = new ReadableArchiveScannerAdapter(parser, externalLibArchive);
                        parser.parse(libAdapter, null);
                    }
                    finally {
                        if (libAdapter == null) continue;
                        libAdapter.close();
                    }
                }
                parser.awaitTermination();
                scannerAdapter.close();
                context.addModuleMetaData(parsingContext.getTypes());
                context.addModuleMetaData(parser);
                return parsingContext.getTypes();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    private List<ReadableArchive> getExternalLibraries(DeploymentContext context) throws IOException {
        ArrayList<ReadableArchive> externalLibArchives = new ArrayList<ReadableArchive>();
        String skipScanExternalLibProp = context.getAppProps().getProperty("skipScanExternalLib");
        if (Boolean.valueOf(skipScanExternalLibProp).booleanValue()) {
            return Collections.EMPTY_LIST;
        }
        List externalLibs = DeploymentUtils.getExternalLibraries((ReadableArchive)context.getSource());
        for (URI externalLib : externalLibs) {
            externalLibArchives.add(this.archiveFactory.openArchive(new File(externalLib.getPath())));
        }
        return externalLibArchives;
    }

    public boolean suspend(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.suspend(this.logger);
        }
        return isSuccess;
    }

    public boolean resume(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.resume(this.logger);
        }
        return isSuccess;
    }

    public List<EngineInfo> setupContainerInfos(DeploymentContext context) throws Exception {
        return this.setupContainerInfos(null, null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EngineInfo> setupContainerInfos(ArchiveHandler handler, Collection<? extends Sniffer> sniffers, DeploymentContext context) throws Exception {
        ActionReport report = context.getActionReport();
        if (sniffers == null) {
            if (handler instanceof CompositeHandler) {
                context.getAppProps().setProperty("isComposite", "true");
                sniffers = this.snifferManager.getCompositeSniffers(context);
            } else {
                sniffers = this.snifferManager.getSniffers(context);
            }
        }
        DeploymentTracing tracing = context.getModuleMetaData(DeploymentTracing.class);
        if (sniffers.size() == 0) {
            report.failure(this.logger, localStrings.getLocalString("deploy.unknownmoduletpe", "Module type not recognized for module {0}", new Object[]{context.getSourceDir()}));
            return null;
        }
        this.snifferManager.validateSniffers(sniffers, context);
        LinkedHashMap containerInfosByDeployers = new LinkedHashMap();
        for (Sniffer sniffer : sniffers) {
            String msg;
            EngineInfo engineInfo;
            if (sniffer.getContainersNames() == null || sniffer.getContainersNames().length == 0) {
                report.failure(this.logger, "no container associated with application of type : " + sniffer.getModuleType(), null);
                return null;
            }
            com.sun.enterprise.module.Module snifferModule = this.modulesRegistry.find(sniffer.getClass());
            if (snifferModule == null) {
                report.failure(this.logger, "cannot find container module from service implementation " + sniffer.getClass(), null);
                return null;
            }
            String containerName = sniffer.getContainersNames()[0];
            if (tracing != null) {
                tracing.addContainerMark(DeploymentTracing.ContainerMark.SNIFFER_DONE, containerName);
            }
            if ((engineInfo = this.containerRegistry.getContainer(containerName)) == null) {
                Collection<EngineInfo> containersInfo = null;
                ContainerRegistry containerRegistry = this.containerRegistry;
                synchronized (containerRegistry) {
                    if (this.containerRegistry.getContainer(containerName) == null) {
                        if (tracing != null) {
                            tracing.addContainerMark(DeploymentTracing.ContainerMark.BEFORE_CONTAINER_SETUP, containerName);
                        }
                        containersInfo = this.setupContainer(sniffer, snifferModule, this.logger, context);
                        if (tracing != null) {
                            tracing.addContainerMark(DeploymentTracing.ContainerMark.AFTER_CONTAINER_SETUP, containerName);
                        }
                        if (containersInfo == null || containersInfo.size() == 0) {
                            String msg2 = "Cannot start container(s) associated to application of type : " + sniffer.getModuleType();
                            report.failure(this.logger, msg2, null);
                            throw new Exception(msg2);
                        }
                    }
                }
                if (!this.startContainers(containersInfo, this.logger, context)) {
                    msg = "Aborting, Failed to start container " + containerName;
                    report.failure(this.logger, msg, null);
                    throw new Exception(msg);
                }
            }
            engineInfo = this.containerRegistry.getContainer(sniffer.getContainersNames()[0]);
            if (tracing != null) {
                tracing.addContainerMark(DeploymentTracing.ContainerMark.GOT_CONTAINER, containerName);
            }
            if (engineInfo == null) {
                String msg3 = "Aborting, Failed to start container " + containerName;
                report.failure(this.logger, msg3, null);
                throw new Exception(msg3);
            }
            Deployer deployer = this.getDeployer(engineInfo);
            if (deployer == null) {
                if (!this.startContainers(Collections.singleton(engineInfo), this.logger, context)) {
                    msg = "Aborting, Failed to start container " + containerName;
                    report.failure(this.logger, msg, null);
                    throw new Exception(msg);
                }
                deployer = this.getDeployer(engineInfo);
                if (deployer == null) {
                    report.failure(this.logger, "Got a null deployer out of the " + engineInfo.getContainer().getClass() + " container, is it annotated with @Service ?");
                    return null;
                }
            }
            if (tracing != null) {
                tracing.addContainerMark(DeploymentTracing.ContainerMark.GOT_DEPLOYER, containerName);
            }
            containerInfosByDeployers.put(deployer, engineInfo);
        }
        LinkedList providers = new LinkedList();
        providers.addAll(this.habitat.getAllByContract(ApplicationMetaDataProvider.class));
        ArrayList<EngineInfo> arrayList = new ArrayList<EngineInfo>();
        HashMap<Class, ApplicationMetaDataProvider> typeByProvider = new HashMap<Class, ApplicationMetaDataProvider>();
        for (ApplicationMetaDataProvider provider : this.habitat.getAllByContract(ApplicationMetaDataProvider.class)) {
            if (provider.getMetaData() == null) continue;
            for (Class provided : provider.getMetaData().provides()) {
                typeByProvider.put(provided, provider);
            }
        }
        for (ApplicationMetaDataProvider provider : this.habitat.getAllByContract(ApplicationMetaDataProvider.class)) {
            if (provider.getMetaData() == null) continue;
            for (Class dependency : provider.getMetaData().requires()) {
                if (typeByProvider.containsKey(dependency)) continue;
                this.logger.warning("ApplicationMetaDataProvider " + provider + " requires " + dependency + " but no other ApplicationMetaDataProvider provides it");
            }
        }
        HashMap<Class, Deployer> typeByDeployer = new HashMap<Class, Deployer>();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class provided : deployer.getMetaData().provides()) {
                typeByDeployer.put(provided, deployer);
            }
        }
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class dependency : deployer.getMetaData().requires()) {
                if (typeByDeployer.containsKey(dependency) || typeByProvider.containsKey(dependency)) continue;
                Service s = deployer.getClass().getAnnotation(Service.class);
                String serviceName = s != null && s.name() != null && s.name().length() > 0 ? s.name() : deployer.getClass().getSimpleName();
                report.failure(this.logger, serviceName + " deployer requires " + dependency + " but no other deployer provides it", null);
                return null;
            }
        }
        ArrayList<Deployer> orderedDeployers = new ArrayList<Deployer>();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Keyed Deployer " + deployer.getClass());
            }
            this.loadDeployer(orderedDeployers, deployer, typeByDeployer, typeByProvider, context);
        }
        for (Deployer deployer : orderedDeployers) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Ordered Deployer " + deployer.getClass());
            }
            MetaData metadata = deployer.getMetaData();
            try {
                if (metadata != null) {
                    if (metadata.provides() == null || metadata.provides().length == 0) {
                        deployer.loadMetaData(null, context);
                    } else {
                        for (Class provide : metadata.provides()) {
                            if (context.getModuleMetaData(provide) != null) continue;
                            context.addModuleMetaData(deployer.loadMetaData(provide, context));
                        }
                    }
                } else {
                    deployer.loadMetaData(null, context);
                }
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e);
                throw e;
            }
            arrayList.add((EngineInfo)containerInfosByDeployers.get(deployer));
        }
        return arrayList;
    }

    private void loadDeployer(List<Deployer> results, Deployer deployer, Map<Class, Deployer> typeByDeployer, Map<Class, ApplicationMetaDataProvider> typeByProvider, DeploymentContext dc) throws IOException {
        if (results.contains(deployer)) {
            return;
        }
        results.add(deployer);
        if (deployer.getMetaData() != null) {
            for (Class required : deployer.getMetaData().requires()) {
                if (dc.getModuleMetaData(required) != null) continue;
                if (typeByDeployer.containsKey(required)) {
                    this.loadDeployer(results, typeByDeployer.get(required), typeByDeployer, typeByProvider, dc);
                    continue;
                }
                ApplicationMetaDataProvider provider = typeByProvider.get(required);
                if (provider == null) {
                    this.logger.severe("I don't get it, file a bug, no-one is providing " + required + " yet it passed validation");
                    continue;
                }
                LinkedList<ApplicationMetaDataProvider> providers = new LinkedList<ApplicationMetaDataProvider>();
                this.addRecursively(providers, typeByProvider, provider);
                for (ApplicationMetaDataProvider p : providers) {
                    dc.addModuleMetaData(p.load(dc));
                }
            }
        }
    }

    private void addRecursively(LinkedList<ApplicationMetaDataProvider> results, Map<Class, ApplicationMetaDataProvider> providers, ApplicationMetaDataProvider provider) {
        results.addFirst(provider);
        for (Class type : provider.getMetaData().requires()) {
            if (!providers.containsKey(type)) continue;
            this.addRecursively(results, providers, providers.get(type));
        }
    }

    public ModuleInfo prepareModule(List<EngineInfo> sortedEngineInfos, String moduleName, DeploymentContext context, ProgressTracker tracker) throws Exception {
        String isComposite;
        ActionReport report = context.getActionReport();
        ArrayList<EngineRef> addedEngines = new ArrayList<EngineRef>();
        DeploymentTracing tracing = context.getModuleMetaData(DeploymentTracing.class);
        if (tracing != null) {
            tracing.addModuleMark(DeploymentTracing.ModuleMark.PREPARE, moduleName);
        }
        for (EngineInfo engineInfo : sortedEngineInfos) {
            Deployer deployer = engineInfo.getDeployer();
            try {
                if (tracing != null) {
                    tracing.addContainerMark(DeploymentTracing.ContainerMark.PREPARE, engineInfo.getSniffer().getModuleType());
                }
                deployer.prepare(context);
                if (tracing != null) {
                    tracing.addContainerMark(DeploymentTracing.ContainerMark.PREPARED, engineInfo.getSniffer().getModuleType());
                }
                EngineRef engineRef = new EngineRef(engineInfo, null);
                addedEngines.add(engineRef);
                tracker.add("prepared", EngineRef.class, (Object)engineRef);
                tracker.add(Deployer.class, (Object)deployer);
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e);
                throw e;
            }
        }
        if (tracing != null) {
            tracing.addModuleMark(DeploymentTracing.ModuleMark.PREPARE_EVENTS, moduleName);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event<DeploymentContext>(Deployment.MODULE_PREPARED, context), false);
        }
        if (tracing != null) {
            tracing.addModuleMark(DeploymentTracing.ModuleMark.PREPARED, moduleName);
        }
        if ((isComposite = context.getAppProps().getProperty("isComposite")) != null) {
            context.getModuleProps().setProperty("isComposite", isComposite);
        }
        ModuleInfo mi = new ModuleInfo(this.events, moduleName, addedEngines, context.getModuleProps());
        ApplicationConfigInfo savedAppConfig = new ApplicationConfigInfo(context.getAppProps());
        for (EngineRef er : mi.getEngineRefs()) {
            ApplicationConfig c = savedAppConfig.get(mi.getName(), er.getContainerInfo().getSniffer().getModuleType());
            if (c == null) continue;
            er.setApplicationConfig(c);
        }
        return mi;
    }

    protected Collection<EngineInfo> setupContainer(Sniffer sniffer, com.sun.enterprise.module.Module snifferModule, Logger logger, DeploymentContext context) {
        ActionReport report = context.getActionReport();
        ContainerStarter starter = (ContainerStarter)this.habitat.getComponent(ContainerStarter.class);
        Collection<EngineInfo> containersInfo = starter.startContainer(sniffer, snifferModule);
        if (containersInfo == null || containersInfo.size() == 0) {
            report.failure(logger, "Cannot start container(s) associated to application of type : " + sniffer.getModuleType(), null);
            return null;
        }
        return containersInfo;
    }

    protected boolean startContainers(Collection<EngineInfo> containersInfo, Logger logger, DeploymentContext context) {
        ActionReport report = context.getActionReport();
        for (EngineInfo engineInfo : containersInfo) {
            Container container;
            try {
                container = engineInfo.getContainer();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot start container  " + engineInfo.getSniffer().getModuleType(), e);
                return false;
            }
            Class<? extends Deployer> deployerClass = container.getDeployer();
            try {
                Deployer deployer = (Deployer)this.habitat.getComponent(deployerClass);
                engineInfo.setDeployer(deployer);
            }
            catch (ComponentException e) {
                report.failure(logger, "Cannot instantiate or inject " + deployerClass, e);
                engineInfo.stop(logger);
                return false;
            }
            catch (ClassCastException e) {
                engineInfo.stop(logger);
                report.failure(logger, deployerClass + " does not implement " + " the org.jvnet.glassfish.api.deployment.Deployer interface", e);
                return false;
            }
        }
        return true;
    }

    protected void stopContainers(EngineInfo[] ctrInfos, Logger logger) {
        for (EngineInfo ctrInfo : ctrInfos) {
            try {
                ctrInfo.stop(logger);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Cannot release container " + ctrInfo.getSniffer().getModuleType(), e);
            }
        }
    }

    protected ApplicationInfo unload(ApplicationInfo info, ExtendedDeploymentContext context) {
        ActionReport report = context.getActionReport();
        if (info == null) {
            report.failure(context.getLogger(), "Application not registered", null);
            return null;
        }
        if (info.isLoaded()) {
            info.stop(context, context.getLogger());
            info.unload(context);
            this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.APPLICATION_DISABLED, info));
        }
        return info;
    }

    public void undeploy(String appName, ExtendedDeploymentContext context) {
        ActionReport report = context.getActionReport();
        UndeployCommandParameters params = (UndeployCommandParameters)context.getCommandParameters(UndeployCommandParameters.class);
        ApplicationInfo info = this.appRegistry.get(appName);
        if (info == null) {
            report.failure(context.getLogger(), "Application " + appName + " not registered", null);
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_FAILURE, context));
            return;
        }
        this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_VALIDATION, context), false);
        if (report.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
            return;
        }
        this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.UNDEPLOYMENT_START, info));
        if (DeploymentUtils.isDASTarget((String)params.target)) {
            this.unload(info, context);
        }
        try {
            info.clean(context);
        }
        catch (Exception e) {
            report.failure(context.getLogger(), "Exception while cleaning application artifacts", e);
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_FAILURE, context));
            return;
        }
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_SUCCESS, context));
            this.deploymentLifecycleProbeProvider.applicationUndeployedEvent(appName, this.getApplicationType(info));
        } else {
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_FAILURE, context));
        }
        this.appRegistry.remove(appName);
        info = null;
    }

    public Transaction prepareAppConfigChanges(DeploymentContext context) throws TransactionFailure {
        Properties appProps = context.getAppProps();
        DeployCommandParameters deployParams = context.getCommandParameters(DeployCommandParameters.class);
        Transaction t = new Transaction();
        try {
            ConfigBean newBean = ((ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)this.applications)).allocate(Application.class);
            Application app = (Application)newBean.createProxy();
            Application app_w = (Application)t.enroll((ConfigBeanProxy)app);
            this.setInitialAppAttributes(app_w, deployParams, appProps, context);
            context.addTransientAppMetaData("application", app_w);
        }
        catch (TransactionFailure e) {
            t.rollback();
            throw e;
        }
        catch (Exception e) {
            t.rollback();
            throw new TransactionFailure(e.getMessage(), (Throwable)e);
        }
        return t;
    }

    public void registerAppInDomainXML(ApplicationInfo applicationInfo, DeploymentContext context, Transaction t) throws TransactionFailure {
        this.registerAppInDomainXML(applicationInfo, context, t, false);
    }

    public void registerAppInDomainXML(ApplicationInfo applicationInfo, DeploymentContext context, Transaction t, boolean appRefOnly) throws TransactionFailure {
        Properties appProps = context.getAppProps();
        DeployCommandParameters deployParams = context.getCommandParameters(DeployCommandParameters.class);
        if (t != null) {
            try {
                if (!appRefOnly) {
                    Application app_w = context.getTransientAppMetaData("application", Application.class);
                    this.setRestAppAttributes(app_w, appProps);
                    Applications apps_w = (Applications)t.enroll((ConfigBeanProxy)this.applications);
                    apps_w.getModules().add(app_w);
                    if (applicationInfo != null) {
                        applicationInfo.save(app_w);
                    }
                }
                List targets = new ArrayList<String>();
                if (!DeploymentUtils.isDomainTarget((String)deployParams.target)) {
                    targets.add(deployParams.target);
                } else {
                    List previousTargets = context.getTransientAppMetaData("previousTargets", List.class);
                    if (previousTargets == null) {
                        previousTargets = this.domain.getAllReferencedTargetsForApplication(deployParams.name);
                    }
                    targets = previousTargets;
                }
                String origVS = deployParams.virtualservers;
                Boolean origEnabled = deployParams.enabled;
                Properties previousVirtualServers = context.getTransientAppMetaData("previousVirtualServers", Properties.class);
                Properties previousEnabledAttributes = context.getTransientAppMetaData("previousEnabledAttributes", Properties.class);
                for (String target : targets) {
                    Cluster cluster;
                    Server servr;
                    deployParams.virtualservers = origVS;
                    deployParams.enabled = origEnabled;
                    if (DeploymentUtils.isDomainTarget((String)deployParams.target)) {
                        String enabledAttr;
                        String vs = previousVirtualServers.getProperty(target);
                        if (vs != null) {
                            deployParams.virtualservers = vs;
                        }
                        if ((enabledAttr = previousEnabledAttributes.getProperty(target)) != null) {
                            deployParams.enabled = Boolean.valueOf(enabledAttr);
                        }
                    }
                    if (deployParams.enabled == null) {
                        deployParams.enabled = Boolean.TRUE;
                    }
                    if ((servr = this.domain.getServerNamed(target)) != null) {
                        ConfigBeanProxy servr_w = t.enroll((ConfigBeanProxy)servr);
                        ApplicationRef appRef = (ApplicationRef)servr_w.createChild(ApplicationRef.class);
                        this.setAppRefAttributes(appRef, deployParams);
                        ((Server)servr_w).getApplicationRef().add(appRef);
                    }
                    if ((cluster = this.domain.getClusterNamed(target)) == null) continue;
                    ConfigBeanProxy cluster_w = t.enroll((ConfigBeanProxy)cluster);
                    ApplicationRef appRef = (ApplicationRef)cluster_w.createChild(ApplicationRef.class);
                    this.setAppRefAttributes(appRef, deployParams);
                    ((Cluster)cluster_w).getApplicationRef().add(appRef);
                    for (Server svr : cluster.getInstances()) {
                        ConfigBeanProxy svr_w = t.enroll((ConfigBeanProxy)svr);
                        ApplicationRef appRef2 = (ApplicationRef)svr_w.createChild(ApplicationRef.class);
                        this.setAppRefAttributes(appRef2, deployParams);
                        ((Server)svr_w).getApplicationRef().add(appRef2);
                    }
                }
            }
            catch (TransactionFailure e) {
                t.rollback();
                throw e;
            }
            catch (Exception e) {
                t.rollback();
                throw new TransactionFailure(e.getMessage(), (Throwable)e);
            }
            try {
                t.commit();
            }
            catch (RetryableException e) {
                System.out.println("Retryable...");
                t.rollback();
            }
            catch (TransactionFailure e) {
                t.rollback();
                throw e;
            }
        }
    }

    private void setInitialAppAttributes(Application app, DeployCommandParameters deployParams, Properties appProps, DeploymentContext context) throws PropertyVetoException {
        Properties previousEnabledAttributes = context.getTransientAppMetaData("previousEnabledAttributes", Properties.class);
        app.setName(deployParams.name);
        if (deployParams.libraries != null) {
            app.setLibraries(deployParams.libraries);
        }
        if (deployParams.description != null) {
            app.setDescription(deployParams.description);
        }
        app.setEnabled(String.valueOf(true));
        if (appProps.getProperty("location") != null) {
            String enabledAttr;
            app.setLocation(appProps.getProperty("location"));
            if (DeploymentUtils.isDomainTarget((String)deployParams.target) && previousEnabledAttributes != null && (enabledAttr = previousEnabledAttributes.getProperty("domain")) != null) {
                app.setEnabled(enabledAttr);
            }
            app.setAvailabilityEnabled(deployParams.availabilityenabled.toString());
            app.setAsyncReplication(deployParams.asyncreplication.toString());
        }
        if (appProps.getProperty("object-type") != null) {
            app.setObjectType(appProps.getProperty("object-type"));
        }
        if (appProps.getProperty("directory-deployed") != null) {
            app.setDirectoryDeployed(appProps.getProperty("directory-deployed"));
        }
    }

    private void setRestAppAttributes(Application app, Properties appProps) throws PropertyVetoException, TransactionFailure {
        if (appProps.getProperty("context-root") != null) {
            app.setContextRoot(appProps.getProperty("context-root"));
        }
        for (String string : appProps.keySet()) {
            if (string.equals("location") || string.equals("context-root") || string.equals("object-type") || string.equals("directory-deployed") || string.startsWith("appConfig")) continue;
            Property prop = (Property)app.createChild(Property.class);
            app.getProperty().add(prop);
            prop.setName(string);
            prop.setValue(appProps.getProperty(string));
        }
    }

    public void unregisterAppFromDomainXML(String appName, String target) throws TransactionFailure {
        this.unregisterAppFromDomainXML(appName, target, false);
    }

    public void unregisterAppFromDomainXML(final String appName, final String tgt, final boolean appRefOnly) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction((ConfigBeanProxy)param);
                if (t != null) {
                    List<String> targets = new ArrayList<String>();
                    if (!tgt.equals("domain")) {
                        targets.add(tgt);
                    } else {
                        targets = ApplicationLifecycle.this.domain.getAllReferencedTargetsForApplication(appName);
                    }
                    for (String target : targets) {
                        Cluster cluster;
                        Server servr = ((Domain)param).getServerNamed(target);
                        if (servr != null) {
                            ConfigBeanProxy servr_w = t.enroll((ConfigBeanProxy)servr);
                            for (ApplicationRef appRef : servr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ((Server)servr_w).getApplicationRef().remove(appRef);
                                break;
                            }
                        }
                        if ((cluster = ((Domain)param).getClusterNamed(target)) == null) continue;
                        ConfigBeanProxy cluster_w = t.enroll((ConfigBeanProxy)cluster);
                        for (ApplicationRef appRef : cluster.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            ((Cluster)cluster_w).getApplicationRef().remove(appRef);
                            break;
                        }
                        block3: for (Server svr : cluster.getInstances()) {
                            ConfigBeanProxy svr_w = t.enroll((ConfigBeanProxy)svr);
                            for (ApplicationRef appRef : svr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ((Server)svr_w).getApplicationRef().remove(appRef);
                                continue block3;
                            }
                        }
                    }
                    if (!appRefOnly) {
                        Applications apps = ((Domain)param).getApplications();
                        ConfigBeanProxy apps_w = t.enroll((ConfigBeanProxy)apps);
                        for (ApplicationName module : apps.getModules()) {
                            if (!module.getName().equals(appName)) continue;
                            ((Applications)apps_w).getModules().remove(module);
                            break;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy)this.domain);
    }

    public void updateAppEnabledAttributeInDomainXML(final String appName, final String target, final boolean enabled) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction((ConfigBeanProxy)param);
                if (t != null) {
                    if (enabled || DeploymentUtils.isDomainTarget((String)target)) {
                        Application app = ((Domain)param).getApplications().getApplication(appName);
                        ConfigBeanProxy app_w = t.enroll((ConfigBeanProxy)app);
                        ((Application)app_w).setEnabled(String.valueOf(enabled));
                    }
                    List<String> targets = new ArrayList<String>();
                    if (!DeploymentUtils.isDomainTarget((String)target)) {
                        targets.add(target);
                    } else {
                        targets = ApplicationLifecycle.this.domain.getAllReferencedTargetsForApplication(appName);
                    }
                    for (String target2 : targets) {
                        Cluster cluster;
                        Server servr = ((Domain)param).getServerNamed(target2);
                        if (servr != null) {
                            for (ApplicationRef appRef : servr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef);
                                ((ApplicationRef)appRef_w).setEnabled(String.valueOf(enabled));
                                break;
                            }
                            ApplicationLifecycle.this.updateClusterAppRefWithInstanceUpdate(t, servr, appName, enabled);
                        }
                        if ((cluster = ((Domain)param).getClusterNamed(target2)) == null) continue;
                        for (ApplicationRef appRef : cluster.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef);
                            ((ApplicationRef)appRef_w).setEnabled(String.valueOf(enabled));
                            break;
                        }
                        block3: for (Server svr : cluster.getInstances()) {
                            for (ApplicationRef appRef : svr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef);
                                ((ApplicationRef)appRef_w).setEnabled(String.valueOf(enabled));
                                continue block3;
                            }
                        }
                    }
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy)this.domain);
    }

    public boolean isRegistered(String appName) {
        return this.applications.getApplication(appName) != null;
    }

    public ApplicationInfo get(String appName) {
        return this.appRegistry.get(appName);
    }

    public Deployment.DeploymentContextBuilder getBuilder(Logger logger, OpsParams params, ActionReport report) {
        return new DeploymentContextBuidlerImpl(logger, params, report);
    }

    private void updateClusterAppRefWithInstanceUpdate(Transaction t, Server servr, String appName, boolean isNewInstanceAppRefStateEnabled) throws TransactionFailure, PropertyVetoException {
        Cluster clusterContainingInstance = servr.getCluster();
        if (clusterContainingInstance != null) {
            boolean isAppRefEnabledOnAnyClusterInstance = false;
            for (Server inst : clusterContainingInstance.getInstances()) {
                isAppRefEnabledOnAnyClusterInstance |= servr.getName().equals(inst.getName()) ? isNewInstanceAppRefStateEnabled : Boolean.parseBoolean(inst.getApplicationRef(appName).getEnabled());
            }
            ApplicationRef clusterAppRef = clusterContainingInstance.getApplicationRef(appName);
            if (Boolean.parseBoolean(clusterAppRef.getEnabled()) != isAppRefEnabledOnAnyClusterInstance) {
                ((ApplicationRef)t.enroll((ConfigBeanProxy)clusterAppRef)).setEnabled(String.valueOf(isAppRefEnabledOnAnyClusterInstance));
            }
        }
    }

    private ReadableArchive getArchive(Deployment.DeploymentContextBuilder builder) throws IOException {
        ReadableArchive archive = builder.sourceAsArchive();
        if (archive == null && builder.sourceAsFile() == null) {
            throw new IOException("Source archive or file not provided to builder");
        }
        if (archive == null && builder.sourceAsFile() != null && (archive = ((ArchiveFactory)this.habitat.getComponent(ArchiveFactory.class)).openArchive(builder.sourceAsFile())) == null) {
            throw new IOException("Invalid archive type : " + builder.sourceAsFile().getAbsolutePath());
        }
        return archive;
    }

    private ExtendedDeploymentContext getContext(ExtendedDeploymentContext initial, Deployment.DeploymentContextBuilder builder) throws IOException {
        ArchiveHandler archiveHandler;
        DeploymentContextBuidlerImpl copy = new DeploymentContextBuidlerImpl(builder);
        ReadableArchive archive = this.getArchive(copy);
        copy.source(archive);
        if (initial == null) {
            initial = new DeploymentContextImpl((Deployment.DeploymentContextBuilder)copy, (ServerEnvironment)this.env);
        }
        if ((archiveHandler = copy.archiveHandler()) == null) {
            String type = null;
            OpsParams params = builder.params();
            if (params != null && params instanceof DeployCommandParameters) {
                type = ((DeployCommandParameters)params).type;
            }
            archiveHandler = this.getArchiveHandler(archive, type);
        }
        File sourceFile = new File(archive.getURI().getSchemeSpecificPart());
        initial.getAppProps().put("defaultAppName", DeploymentUtils.getDefaultEEName((String)sourceFile.getName()));
        if (!sourceFile.isDirectory()) {
            String repositoryBitName = copy.params().name();
            try {
                repositoryBitName = VersioningUtils.getRepositoryName((String)repositoryBitName);
            }
            catch (VersioningSyntaxException e) {
                ActionReport report = copy.report();
                report.setMessage(e.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            File expansionDir = new File(this.domain.getApplicationRoot(), repositoryBitName);
            if (!expansionDir.mkdirs()) {
                this.logger.fine(localStrings.getLocalString("deploy.cannotcreateexpansiondir", "Error while creating directory for jar expansion: {0}", new Object[]{expansionDir}));
            }
            try {
                Long start = System.currentTimeMillis();
                archiveHandler.expand(archive, this.archiveFactory.createArchive(expansionDir), (DeploymentContext)initial);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Deployment expansion took " + (System.currentTimeMillis() - start));
                }
                try {
                    archive.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, localStrings.getLocalString("deploy.errorclosingarchive", "Error while closing deployable artifact {0}", new Object[]{archive.getURI().getSchemeSpecificPart()}), e);
                    throw e;
                }
                archive = this.archiveFactory.openArchive(expansionDir);
                initial.setSource(archive);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, localStrings.getLocalString("deploy.errorexpandingjar", "Error while expanding archive file"), e);
                throw e;
            }
        }
        initial.setArchiveHandler(archiveHandler);
        return initial;
    }

    private String getVirtualServers(String target) {
        List hosts;
        HttpService httpService;
        if (this.env.isDas() && DeploymentUtils.isDomainTarget((String)target)) {
            target = "server";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Server server = this.domain.getServerNamed(target);
        Config config = null;
        if (server != null) {
            config = this.domain.getConfigs().getConfigByName(server.getConfigRef());
        } else {
            Cluster cluster = this.domain.getClusterNamed(target);
            if (cluster != null) {
                config = this.domain.getConfigs().getConfigByName(cluster.getConfigRef());
            }
        }
        if (config != null && (httpService = config.getHttpService()) != null && (hosts = httpService.getVirtualServer()) != null) {
            for (VirtualServer host : hosts) {
                if ("__asadmin".equals(host.getId())) continue;
                if (first) {
                    sb.append(host.getId());
                    first = false;
                    continue;
                }
                sb.append(",");
                sb.append(host.getId());
            }
        }
        return sb.toString();
    }

    private void setAppRefAttributes(ApplicationRef appRef, DeployCommandParameters deployParams) throws PropertyVetoException {
        appRef.setRef(deployParams.name);
        if (deployParams.virtualservers != null) {
            appRef.setVirtualServers(deployParams.virtualservers);
        } else {
            appRef.setVirtualServers(this.getVirtualServers(deployParams.target));
        }
        if (deployParams.lbenabled != null) {
            appRef.setLbEnabled(deployParams.lbenabled);
        } else {
            String lbEnabledDefault = System.getProperty("org.glassfish.lb-enabled-default");
            if (lbEnabledDefault != null) {
                appRef.setLbEnabled(lbEnabledDefault);
            }
        }
        appRef.setEnabled(deployParams.enabled.toString());
    }

    public List<Sniffer> prepareSniffersForOSGiDeployment(String type, DeploymentContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        StringTokenizer st = new StringTokenizer(type);
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        while (st.hasMoreTokens()) {
            String aType = st.nextToken();
            Sniffer sniffer = this.snifferManager.getSniffer(aType);
            if (sniffer == null) {
                report.failure(logger, localStrings.getLocalString("deploy.unknowncontainer", "{0} is not a recognized container ", (Object[])new String[]{aType}));
                return sniffers;
            }
            if (!this.snifferManager.canBeIsolated(sniffer)) {
                report.failure(logger, localStrings.getLocalString("deploy.isolationerror", "container {0} does not support other components containers to be turned off, --type {0} is forbidden", (Object[])new String[]{aType}));
                return sniffers;
            }
            sniffers.add(sniffer);
        }
        return sniffers;
    }

    public ParameterMap prepareInstanceDeployParamMap(DeploymentContext dc) throws Exception {
        Properties previousEnabledAttributes;
        DeployCommandParameters params = dc.getCommandParameters(DeployCommandParameters.class);
        ArrayList<String> excludedParams = new ArrayList<String>();
        excludedParams.add("path");
        excludedParams.add("deploymentplan");
        excludedParams.add("upload");
        ParameterMapExtractor extractor = new ParameterMapExtractor(new Object[]{params});
        ParameterMap paramMap = extractor.extract(excludedParams);
        this.prepareGeneratedContent(dc, paramMap);
        Application application = this.applications.getApplication(params.name);
        Properties appProperties = application.getDeployProperties();
        String archiveLocation = appProperties.getProperty("appLocation");
        File archiveFile = new File(new URI(archiveLocation));
        paramMap.set("DEFAULT", archiveFile.getAbsolutePath());
        String planLocation = appProperties.getProperty("deploymentPlanLocation");
        if (planLocation != null) {
            File actualPlan = new File(new URI(planLocation));
            paramMap.set("deploymentplan", actualPlan.getAbsolutePath());
        }
        paramMap.set("upload", "true");
        if (params.previousContextRoot != null) {
            paramMap.set("preservedcontextroot", params.previousContextRoot);
        }
        Properties appProps = dc.getAppProps();
        appProps.remove("appConfig");
        paramMap.set("appprops", extractor.propertiesValue(appProps, ':'));
        Properties previousVirtualServers = dc.getTransientAppMetaData("previousVirtualServers", Properties.class);
        if (previousVirtualServers != null) {
            paramMap.set("previousVirtualServers", extractor.propertiesValue(previousVirtualServers, ':'));
        }
        if ((previousEnabledAttributes = dc.getTransientAppMetaData("previousEnabledAttributes", Properties.class)) != null) {
            paramMap.set("previousEnabledAttributes", extractor.propertiesValue(previousEnabledAttributes, ':'));
        }
        return paramMap;
    }

    private void prepareGeneratedContent(DeploymentContext dc, ParameterMap paramMap) throws IOException {
        File generatedContentZip = this.createGeneratedContentZip();
        ZipOutputStream zipOS = null;
        File baseDir = dc.getScratchDir("xml").getParentFile().getParentFile();
        for (String scratchType : UPLOADED_GENERATED_DIRS) {
            zipOS = this.addScratchContentIfPresent(dc, baseDir, zipOS, generatedContentZip, scratchType);
        }
        if (zipOS != null) {
            zipOS.close();
            paramMap.set("generatedcontent", generatedContentZip.getAbsolutePath());
        }
    }

    private File createGeneratedContentZip() throws IOException {
        File tempFile = File.createTempFile("gendContent", ".zip");
        tempFile.deleteOnExit();
        return tempFile;
    }

    private ZipOutputStream addScratchContentIfPresent(DeploymentContext dc, File baseDir, ZipOutputStream zipOS, File generatedContentZip, String scratchDirName) throws IOException {
        File genDir = dc.getScratchDir(scratchDirName);
        if (genDir.isDirectory()) {
            if (zipOS == null) {
                zipOS = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(generatedContentZip)));
            }
            this.addFileToZip(zipOS, baseDir, genDir);
        }
        return zipOS;
    }

    private void addFileToZip(ZipOutputStream zipOS, File baseDir, File f) throws IOException {
        String entryName = baseDir.toURI().relativize(f.toURI()).getPath();
        ZipEntry entry = new ZipEntry(entryName);
        zipOS.putNextEntry(entry);
        if (!f.isDirectory()) {
            int bytesRead;
            byte[] buffer = new byte[1024];
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
            while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                zipOS.write(buffer, 0, bytesRead);
            }
            ((InputStream)is).close();
            zipOS.closeEntry();
        } else {
            zipOS.closeEntry();
            for (File subFile : f.listFiles()) {
                this.addFileToZip(zipOS, baseDir, subFile);
            }
        }
    }

    public void validateDeploymentTarget(String target, String name, boolean isRedeploy) {
        List referencedTargets = this.domain.getAllReferencedTargetsForApplication(name);
        if (referencedTargets.isEmpty()) {
            if (this.isRegistered(name)) {
                if (!isRedeploy && target.equals("domain")) {
                    throw new IllegalArgumentException(localStrings.getLocalString("application.alreadyreg.redeploy", "Application with name {0} is already registered. Either specify that redeployment must be forced, or redeploy the application. Or if this is a new deployment, pick a different name.", new Object[]{name}));
                }
                throw new IllegalArgumentException(localStrings.getLocalString("use.create_app_ref_2", "Application {0} is already deployed in this domain. Please use create application ref to create application reference on target {1}.", new Object[]{name, target}));
            }
            return;
        }
        if (!isRedeploy) {
            if (target.equals("domain")) {
                throw new IllegalArgumentException(localStrings.getLocalString("application.deploy_domain", "Application with name {0} is already referenced by other target(s). Please specify force option to redeploy to domain.", new Object[]{name}));
            }
            if (referencedTargets.size() == 1 && referencedTargets.contains(target)) {
                throw new IllegalArgumentException(localStrings.getLocalString("application.alreadyreg.redeploy", "Application with name {0} is already registered. Either specify that redeployment must be forced, or redeploy the application. Or if this is a new deployment, pick a different name.", new Object[]{name}));
            }
            throw new IllegalArgumentException(localStrings.getLocalString("use.create_app_ref", "Application {0} is already referenced by other target(s). Please use create application ref to create application reference on target {1}.", new Object[]{name, target}));
        }
        if (referencedTargets.size() == 1 && referencedTargets.contains(target)) {
            return;
        }
        if (!target.equals("domain")) {
            throw new IllegalArgumentException(localStrings.getLocalString("redeploy_on_multiple_targets", "Application {0} is referenced by more than one targets. Please remove other references or specify all targets (or domain target if using asadmin command line) before attempting redeploy operation.", new Object[]{name}));
        }
    }

    public void validateUndeploymentTarget(String target, String name) {
        List referencedTargets = this.domain.getAllReferencedTargetsForApplication(name);
        if (referencedTargets.size() > 1) {
            Application app = this.applications.getApplication(name);
            if (!target.equals("domain")) {
                if (app.isLifecycleModule()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("delete_lifecycle_on_multiple_targets", "Lifecycle module {0} is referenced by more than one targets. Please remove other references before attempting delete operation.", new Object[]{name}));
                }
                throw new IllegalArgumentException(localStrings.getLocalString("undeploy_on_multiple_targets", "Application {0} is referenced by more than one targets. Please remove other references or specify all targets (or domain target if using asadmin command line) before attempting undeploy operation.", new Object[]{name}));
            }
        }
    }

    public boolean isAppEnabled(Application app) {
        ApplicationRef appRef;
        return Boolean.valueOf(app.getEnabled()) != false && (appRef = this.server.getApplicationRef(app.getName())) != null && Boolean.valueOf(appRef.getEnabled()) != false;
    }

    public void disable(UndeployCommandParameters commandParams, Application app, ApplicationInfo appInfo, ActionReport report, Logger logger) throws Exception {
        if (appInfo == null || !appInfo.isLoaded()) {
            return;
        }
        ExtendedDeploymentContext deploymentContext = this.getBuilder(logger, commandParams, report).source(appInfo.getSource()).build();
        if (app != null) {
            deploymentContext.getAppProps().putAll((Map<?, ?>)app.getDeployProperties());
            deploymentContext.setModulePropsMap(app.getModulePropertiesMap());
        }
        if (commandParams.properties != null) {
            deploymentContext.getAppProps().putAll((Map<?, ?>)commandParams.properties);
        }
        this.unload(appInfo, deploymentContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable(String target, Application app, ApplicationRef appRef, ActionReport report, Logger logger) throws Exception {
        Archive archive = null;
        try {
            DeployCommandParameters commandParams = app.getDeployParameters(appRef);
            ApplicationInfo appInfo = this.appRegistry.get(commandParams.name);
            if (appInfo != null && appInfo.isLoaded()) {
                return;
            }
            commandParams.origin = OpsParams.Origin.load;
            commandParams.target = target;
            commandParams.enabled = Boolean.TRUE;
            if (app.containsSnifferType("osgi")) {
                commandParams.type = "osgi";
            }
            Properties contextProps = app.getDeployProperties();
            Map modulePropsMap = app.getModulePropertiesMap();
            ApplicationConfigInfo savedAppConfig = new ApplicationConfigInfo(app);
            URI uri = new URI(app.getLocation());
            File file = new File(uri);
            if (!file.exists()) {
                throw new Exception(localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
            }
            archive = this.archiveFactory.openArchive(file);
            ExtendedDeploymentContext deploymentContext = this.getBuilder(logger, commandParams, report).source((ReadableArchive)archive).build();
            Properties appProps = deploymentContext.getAppProps();
            appProps.putAll((Map<?, ?>)contextProps);
            savedAppConfig.store(appProps);
            if (modulePropsMap != null) {
                deploymentContext.setModulePropsMap(modulePropsMap);
            }
            this.deploy(this.getSniffersFromApp(app), deploymentContext);
        }
        finally {
            try {
                if (archive != null) {
                    archive.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private void installTransformers(ExtendedDeploymentContext appContext) throws Exception {
        this.installTransformersOnModule(appContext, true);
        Map moduleContexts = appContext.getModuleDeploymentContexts();
        for (String moduleUri : moduleContexts.keySet()) {
            ExtendedDeploymentContext context = (ExtendedDeploymentContext)moduleContexts.get(moduleUri);
            this.installTransformersOnModule(context, false);
        }
    }

    private void installTransformersOnModule(ExtendedDeploymentContext context, boolean isAppLevel) throws Exception {
        ActionReport report = context.getActionReport();
        if (!context.getTransformers().isEmpty()) {
            try {
                InstrumentableClassLoader icl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(context.getFinalClassLoader());
                String isComposite = context.getAppProps().getProperty("isComposite");
                if (Boolean.valueOf(isComposite).booleanValue() && icl instanceof URLClassLoader) {
                    URLClassLoader urlCl = (URLClassLoader)((Object)icl);
                    if (isAppLevel) {
                        icl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(urlCl.getParent().getParent());
                    } else {
                        ClassLoader libCl = urlCl.getParent().getParent();
                        if (!(libCl instanceof URLClassLoader)) {
                            libCl = libCl.getParent();
                        }
                        if (libCl instanceof URLClassLoader) {
                            InstrumentableClassLoader libIcl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(libCl);
                            for (ClassFileTransformer transformer : context.getTransformers()) {
                                libIcl.addTransformer(transformer);
                            }
                        }
                    }
                }
                for (ClassFileTransformer transformer : context.getTransformers()) {
                    icl.addTransformer(transformer);
                }
            }
            catch (Exception e) {
                report.failure(this.logger, "Class loader used for loading application cannot handle bytecode enhancer", e);
                throw e;
            }
        }
    }

    private boolean loadOnCurrentInstance(DeploymentContext context) {
        DeployCommandParameters commandParams = context.getCommandParameters(DeployCommandParameters.class);
        Properties appProps = context.getAppProps();
        if (commandParams.enabled.booleanValue()) {
            String objectType;
            if (this.domain.isCurrentInstanceMatchingTarget(commandParams.target, commandParams.name(), this.server.getName(), context.getTransientAppMetaData("previousTargets", List.class))) {
                return true;
            }
            if (this.server.isDas() && (objectType = appProps.getProperty("object-type")) != null && (objectType.equals("system-admin") || objectType.equals("system-all"))) {
                return true;
            }
        }
        return false;
    }

    private String getApplicationType(ApplicationInfo appInfo) {
        StringBuffer sb = new StringBuffer();
        if (appInfo.getSniffers().size() > 0) {
            for (Sniffer sniffer : appInfo.getSniffers()) {
                if (!sniffer.isUserVisible()) continue;
                sb.append(sniffer.getModuleType() + ", ");
            }
        }
        if (sb.length() > 2) {
            return sb.substring(0, sb.length() - 2);
        }
        return sb.toString();
    }

    public List<Sniffer> getSniffersFromApp(Application app) {
        ArrayList<String> snifferTypes = new ArrayList<String>();
        for (Module module : app.getModule()) {
            for (Engine engine : module.getEngines()) {
                snifferTypes.add(engine.getSniffer());
            }
        }
        if (snifferTypes.isEmpty()) {
            return null;
        }
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        if (app.isStandaloneModule()) {
            for (String snifferType : snifferTypes) {
                Sniffer sniffer = this.snifferManager.getSniffer(snifferType);
                if (sniffer != null) {
                    sniffers.add(sniffer);
                    continue;
                }
                this.logger.log(Level.SEVERE, "cannot.find.sniffer", new Object[]{snifferType});
            }
            if (sniffers.isEmpty()) {
                this.logger.log(Level.SEVERE, "cannot.find.sniffer.for.app", new Object[]{app.getName()});
                return null;
            }
        } else {
            return null;
        }
        return sniffers;
    }

    private ExecutorService createExecutorService() {
        Runtime runtime = Runtime.getRuntime();
        int nrOfProcessors = runtime.availableProcessors();
        return Executors.newFixedThreadPool(nrOfProcessors, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("deployment-jar-scanner");
                t.setDaemon(true);
                return t;
            }
        });
    }

    public class DeploymentContextBuidlerImpl
    implements Deployment.DeploymentContextBuilder {
        private final Logger logger;
        private final ActionReport report;
        private final OpsParams params;
        private File sFile;
        private ReadableArchive sArchive;
        private ArchiveHandler handler;

        public DeploymentContextBuidlerImpl(Logger logger, OpsParams params, ActionReport report) {
            this.logger = logger;
            this.report = report;
            this.params = params;
        }

        public DeploymentContextBuidlerImpl(Deployment.DeploymentContextBuilder b) throws IOException {
            this.logger = b.logger();
            this.report = b.report();
            this.params = b.params();
            ReadableArchive archive = ApplicationLifecycle.this.getArchive(b);
            this.source(archive);
            this.handler = b.archiveHandler();
        }

        public Deployment.DeploymentContextBuilder source(File source) {
            this.sFile = source;
            return this;
        }

        public File sourceAsFile() {
            return this.sFile;
        }

        public ReadableArchive sourceAsArchive() {
            return this.sArchive;
        }

        public ArchiveHandler archiveHandler() {
            return this.handler;
        }

        public Deployment.DeploymentContextBuilder source(ReadableArchive archive) {
            this.sArchive = archive;
            return this;
        }

        public Deployment.DeploymentContextBuilder archiveHandler(ArchiveHandler handler) {
            this.handler = handler;
            return this;
        }

        public ExtendedDeploymentContext build() throws IOException {
            return this.build(null);
        }

        public Logger logger() {
            return this.logger;
        }

        public ActionReport report() {
            return this.report;
        }

        public OpsParams params() {
            return this.params;
        }

        public ExtendedDeploymentContext build(ExtendedDeploymentContext initialContext) throws IOException {
            return ApplicationLifecycle.this.getContext(initialContext, this);
        }
    }
}

