/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.admin.util.InstanceCommandExecutor;
import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.InstanceCommandResult;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterOperationUtil {
    private static final Logger logger = LogDomains.getLogger(ClusterOperationUtil.class, "javax.enterprise.system.tools.admin");
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(ClusterOperationUtil.class);
    private static List<Server> completedInstances = new ArrayList<Server>();

    public static List<Server> getCompletedInstances() {
        return completedInstances;
    }

    public static void clearInstanceList() {
        completedInstances.clear();
    }

    public static ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, List<Server> instancesForReplication, AdminCommandContext context, ParameterMap parameters, Habitat habitat) {
        return ClusterOperationUtil.replicateCommand(commandName, failPolicy, offlinePolicy, instancesForReplication, context, parameters, habitat, null);
    }

    public static ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, List<Server> instancesForReplication, AdminCommandContext context, ParameterMap parameters, Habitat habitat, File intermediateDownloadDir) {
        long maxWaitTime;
        HashMap<String, Future<InstanceCommandResult>> futures;
        InstanceStateService instanceState;
        ActionReport.ExitCode returnValue;
        block16: {
            returnValue = ActionReport.ExitCode.SUCCESS;
            instanceState = (InstanceStateService)habitat.getComponent(InstanceStateService.class);
            ClusterOperationUtil.validateIntermediateDownloadDir(intermediateDownloadDir);
            RemoteInstanceCommandHelper rich = new RemoteInstanceCommandHelper(habitat);
            futures = new HashMap<String, Future<InstanceCommandResult>>();
            try {
                for (Server svr : instancesForReplication) {
                    Future<InstanceCommandResult> f;
                    InstanceCommandResult aResult;
                    ActionReport aReport;
                    int port;
                    String host;
                    InstanceCommandExecutor ice = new InstanceCommandExecutor(habitat, commandName, failPolicy, offlinePolicy, svr, host = svr.getAdminHost(), port = rich.getAdminPort(svr), logger, parameters, aReport = context.getActionReport().addSubActionsReport(), aResult = new InstanceCommandResult());
                    if (CommandTarget.DAS.isValid(habitat, ice.getServer().getName())) continue;
                    if (intermediateDownloadDir != null) {
                        ice.setFileOutputDirectory(ClusterOperationUtil.subdirectoryForInstance(intermediateDownloadDir, ice));
                    }
                    if ((f = instanceState.submitJob(svr, ice, aResult)) == null) {
                        logger.severe(strings.getLocalString("clusterutil.instancehasnostate", "Could not find state of instance registered in the state service"));
                        continue;
                    }
                    futures.put(svr.getName(), f);
                    logger.fine(strings.getLocalString("dynamicreconfiguration.diagnostics.jobsubmitted", "Successfully submitted command {0} for execution at instance {1}", commandName, svr.getName()));
                }
            }
            catch (Exception ex) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                ActionReport.ExitCode finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)failPolicy, (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                aReport.setActionExitCode(finalResult);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.replicationfailed", "Error during command replication : {0}", ex.getMessage()));
                context.getLogger().severe("Error during command replication; Reason : " + ex.getLocalizedMessage());
                if (returnValue != ActionReport.ExitCode.SUCCESS) break block16;
                returnValue = finalResult;
            }
        }
        boolean gotFirstResponse = false;
        long timeBeforeAsadminTimeout = maxWaitTime = (long)RemoteAdminCommand.getReadTimeout();
        long waitStart = System.currentTimeMillis();
        for (String s : futures.keySet()) {
            ActionReport.ExitCode finalResult;
            try {
                InstanceCommandExecutor ice;
                logger.fine(strings.getLocalString("dynamicreconfiguration.diagnostics.waitingonjob", "Waiting for command {0} to be completed at instance {1}", commandName, s));
                Future aFuture = (Future)futures.get(s);
                InstanceCommandResult aResult = (InstanceCommandResult)aFuture.get(maxWaitTime, TimeUnit.MILLISECONDS);
                long elapsedTime = System.currentTimeMillis() - waitStart;
                timeBeforeAsadminTimeout -= elapsedTime;
                if (!gotFirstResponse) {
                    maxWaitTime = elapsedTime * 4L;
                    gotFirstResponse = true;
                }
                if (maxWaitTime > timeBeforeAsadminTimeout || maxWaitTime < 60000L) {
                    maxWaitTime = timeBeforeAsadminTimeout;
                }
                if ((ice = (InstanceCommandExecutor)aResult.getInstanceCommand()).getReport().getActionExitCode() != ActionReport.ExitCode.FAILURE) {
                    completedInstances.add(ice.getServer());
                }
                finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)failPolicy, (ActionReport.ExitCode)ice.getReport().getActionExitCode());
                if (returnValue == ActionReport.ExitCode.SUCCESS) {
                    returnValue = finalResult;
                }
                if (finalResult == ActionReport.ExitCode.SUCCESS) continue;
                instanceState.setState(s, InstanceState.StateType.RESTART_REQUIRED, false);
                instanceState.addFailedCommandToInstance(s, commandName, parameters);
            }
            catch (Exception ex) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                finalResult = ActionReport.ExitCode.FAILURE;
                finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)failPolicy, (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                if (finalResult == ActionReport.ExitCode.FAILURE) {
                    if (ex instanceof TimeoutException) {
                        aReport.setMessage(strings.getLocalString("clusterutil.timeoutwhilewaiting", "Timed out while waiting for result from instance {0}", s));
                    } else {
                        aReport.setMessage(strings.getLocalString("clusterutil.exceptionwhilewaiting", "Exception while waiting for result from instance {0} : {1}", s, ex.getLocalizedMessage()));
                    }
                }
                aReport.setActionExitCode(finalResult);
                if (returnValue == ActionReport.ExitCode.SUCCESS) {
                    returnValue = finalResult;
                }
                instanceState.setState(s, InstanceState.StateType.RESTART_REQUIRED, false);
                instanceState.addFailedCommandToInstance(s, commandName, parameters);
            }
        }
        return returnValue;
    }

    public static ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, Collection<String> targetNames, AdminCommandContext context, ParameterMap parameters, Habitat habitat) {
        return ClusterOperationUtil.replicateCommand(commandName, failPolicy, offlinePolicy, targetNames, context, parameters, habitat, null);
    }

    public static ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, Collection<String> targetNames, AdminCommandContext context, ParameterMap parameters, Habitat habitat, File intermediateDownloadDir) {
        ActionReport.ExitCode result = ActionReport.ExitCode.SUCCESS;
        Target targetService = (Target)habitat.getComponent(Target.class);
        for (String t : targetNames) {
            String dynRecfg;
            if (CommandTarget.DAS.isValid(habitat, t) || CommandTarget.DOMAIN.isValid(habitat, t)) continue;
            if (targetService.isCluster(t) && Boolean.FALSE.equals(Boolean.valueOf(dynRecfg = targetService.getClusterConfig(t).getDynamicReconfigurationEnabled()))) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                aReport.setActionExitCode(ActionReport.ExitCode.WARNING);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.dynrecfgdisabled", "WARNING : The command was not replicated to all cluster instances because the dynamic-reconfig-enabled flag is set to false for cluster {0}", t));
                InstanceStateService instanceState = (InstanceStateService)habitat.getComponent(InstanceStateService.class);
                for (Server s : targetService.getInstances(t)) {
                    instanceState.setState(s.getName(), InstanceState.StateType.RESTART_REQUIRED, false);
                    instanceState.addFailedCommandToInstance(s.getName(), commandName, parameters);
                }
                result = ActionReport.ExitCode.WARNING;
                continue;
            }
            parameters.set((Object)"target", (Object)t);
            ActionReport.ExitCode returnValue = ClusterOperationUtil.replicateCommand(commandName, failPolicy, offlinePolicy, targetService.getInstances(t), context, parameters, habitat, intermediateDownloadDir);
            if (returnValue.equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
            result = returnValue;
        }
        return result;
    }

    private static void validateIntermediateDownloadDir(File dir) {
        if (dir == null) {
            return;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        } else if (!dir.isDirectory() || !dir.canWrite()) {
            throw new IllegalArgumentException(dir.getAbsolutePath());
        }
    }

    private static File subdirectoryForInstance(File dir, InstanceCommandExecutor exec) {
        return new File(dir, exec.getServer().getName());
    }
}

