/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.config.serverbeans.customvalidators.NotDuplicateTargetName;
import com.sun.enterprise.config.serverbeans.customvalidators.NotTargetKeyword;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.Pattern;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.DeletionDecorator;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.TransactionFailure;

@Configured
@NotDuplicateTargetName
public interface Node
extends ConfigBeanProxy,
Injectable,
Named,
ReferenceContainer,
RefContainer {
    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @NotTargetKeyword
    @Pattern(regexp="[\\p{L}\\p{N}_][\\p{L}\\p{N}\\-_./;#]*", message="Invalid node name. Name must start with a letter or number and may contain only letters, numbers, and certain other characters.")
    public String getName();

    @Attribute
    public String getNodeDir();

    @Param(name="nodedir", optional=true)
    public void setNodeDir(String var1) throws PropertyVetoException;

    @Attribute
    @Pattern(regexp="[\\p{L}\\p{N}_][\\p{L}\\p{N}\\-_./;#]*")
    public String getNodeHost();

    @Param(name="nodehost", optional=true)
    public void setNodeHost(String var1) throws PropertyVetoException;

    @Attribute
    public String getInstallDir();

    @Param(name="installdir", optional=true)
    public void setInstallDir(String var1) throws PropertyVetoException;

    @Attribute
    public String getType();

    @Param(name="type", defaultValue="CONFIG")
    public void setType(String var1) throws PropertyVetoException;

    @Element
    public SshConnector getSshConnector();

    public void setSshConnector(SshConnector var1);

    @DuckTyped
    public String getInstallDirUnixStyle();

    @DuckTyped
    public String getNodeDirUnixStyle();

    @DuckTyped
    public String getNodeDirAbsolute();

    @DuckTyped
    public String getNodeDirAbsoluteUnixStyle();

    @DuckTyped
    public boolean nodeInUse();

    @DuckTyped
    public boolean isLocal();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class DeleteDecorator
    implements DeletionDecorator<Nodes, Node> {
        @Inject
        private Domain domain;
        @Inject
        Nodes nodes;
        @Inject
        Servers servers;
        @Inject
        private ServerEnvironment env;

        @Override
        public void decorate(AdminCommandContext context, Nodes parent, Node child) throws PropertyVetoException, TransactionFailure {
            Logger logger = LogDomains.getLogger(Node.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Node.class);
            ActionReport report = context.getActionReport();
            String nodeName = child.getName();
            if (nodeName.equals("localhost")) {
                String msg = localStrings.getLocalString("Node.localhost", "Cannot remove Node {0}. ", new Object[]{child.getName()});
                logger.log(Level.SEVERE, msg);
                throw new TransactionFailure(msg);
            }
            List<Node> nodeList = this.nodes.getNode();
            List<Server> serversOnNode = this.servers.getServersOnNode(child);
            int n = 0;
            if (serversOnNode != null && serversOnNode.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (Server server : serversOnNode) {
                    if (n > 0) {
                        sb.append(", ");
                    }
                    sb.append(server.getName());
                    ++n;
                }
                String msg = localStrings.getLocalString("Node.referencedByInstance", "Node {0} referenced in server instance(s): {1}.  Remove instances before removing node.", new Object[]{child.getName(), sb.toString()});
                logger.log(Level.SEVERE, msg);
                throw new TransactionFailure(msg);
            }
            nodeList.remove(child);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class Decorator
    implements CreationDecorator<Node> {
        @Param(name="nodedir", optional=true)
        String nodedir = null;
        @Param(name="nodehost", optional=true)
        String nodehost = null;
        @Param(name="installdir", optional=true)
        String installdir = null;
        @Param(name="type", optional=true, defaultValue="CONFIG")
        String type = "CONFIG";
        @Param(name="sshport", optional=true)
        String sshPort = "-1";
        @Param(name="sshnodehost", optional=true)
        String sshHost = null;
        @Param(name="sshuser", optional=true)
        String sshuser = null;
        @Param(name="sshkeyfile", optional=true)
        String sshkeyfile;
        @Param(name="sshpassword", optional=true)
        String sshpassword;
        @Param(name="sshkeypassphrase", optional=true)
        String sshkeypassphrase;
        @Inject
        Habitat habitat;
        @Inject
        ServerEnvironment env;
        @Inject
        Domain domain;

        @Override
        public void decorate(AdminCommandContext context, Node instance) throws TransactionFailure, PropertyVetoException {
            if (this.nodedir != null && this.nodedir != "") {
                instance.setNodeDir(this.nodedir);
            }
            if (this.installdir != null && this.installdir != "") {
                instance.setInstallDir(this.installdir);
            }
            if (this.nodehost != null && this.nodehost != "") {
                instance.setNodeHost(this.nodehost);
            }
            instance.setType(this.type);
            SshConnector sshC = instance.createChild(SshConnector.class);
            if (this.sshPort != "-1" && this.sshPort != "") {
                sshC.setSshPort(this.sshPort);
            }
            if (this.sshHost != null && this.sshHost != "") {
                sshC.setSshHost(this.sshHost);
            }
            if (this.sshuser != null || this.sshkeyfile != null || this.sshpassword != null || this.sshkeypassphrase != null) {
                SshAuth sshA = sshC.createChild(SshAuth.class);
                if (this.sshuser != null && this.sshuser != "") {
                    sshA.setUserName(this.sshuser);
                }
                if (this.sshkeyfile != null && this.sshkeyfile != "") {
                    sshA.setKeyfile(this.sshkeyfile);
                }
                if (this.sshpassword != null && this.sshpassword != "") {
                    sshA.setPassword(this.sshpassword);
                }
                if (this.sshkeypassphrase != null && this.sshkeypassphrase != "") {
                    sshA.setKeyPassphrase(this.sshkeypassphrase);
                }
                sshC.setSshAuth(sshA);
            }
            instance.setSshConnector(sshC);
        }
    }

    public static class Duck {
        public static String getInstallDirUnixStyle(Node node) {
            String installDir = node.getInstallDir();
            if (installDir == null) {
                return null;
            }
            return installDir.replaceAll("\\\\", "/");
        }

        public static String getNodeDirUnixStyle(Node node) {
            String nodeDir = node.getNodeDir();
            if (nodeDir == null) {
                return null;
            }
            return nodeDir.replaceAll("\\\\", "/");
        }

        public static String getNodeDirAbsolute(Node node) {
            String nodeDir = node.getNodeDir();
            if (nodeDir == null) {
                return null;
            }
            File nodeDirFile = new File(nodeDir);
            if (nodeDirFile.isAbsolute()) {
                return nodeDir;
            }
            String installDir = node.getInstallDir();
            File installRootFile = new File(installDir, "glassfish");
            File absoluteNodeDirFile = new File(installRootFile, nodeDir);
            return absoluteNodeDirFile.getPath();
        }

        public static String getNodeDirAbsoluteUnixStyle(Node node) {
            String nodeDirAbsolute = Duck.getNodeDirAbsolute(node);
            if (nodeDirAbsolute == null) {
                return null;
            }
            return nodeDirAbsolute.replaceAll("\\\\", "/");
        }

        public static boolean isLocal(Node node) {
            if (node.getName().equals("localhost")) {
                return true;
            }
            String nodeHost = node.getNodeHost();
            if (nodeHost == null || nodeHost.length() == 0) {
                return false;
            }
            return NetUtils.isThisHostLocal((String)nodeHost);
        }

        public static boolean nodeInUse(Node node) {
            String nodeName = node.getName();
            Dom serverDom = Dom.unwrap(node);
            Servers servers = (Servers)serverDom.getHabitat().getComponent(Servers.class);
            List<Server> serverList = servers.getServer();
            if (serverList != null) {
                for (Server server : serverList) {
                    if (!nodeName.equals(server.getNodeRef())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

