/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-application-ref")
@I18n(value="delete.application.ref.command")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class DeleteApplicationRefCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteApplicationRefCommand.class);
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true, defaultValue="false")
    public Boolean cascade;
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    Applications applications;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    VersioningService versioningService;
    @Inject(name="default-instance-name")
    protected Server server;
    @Inject
    ServerEnvironment env;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        List matchedVersions = null;
        try {
            matchedVersions = this.versioningService.getMatchedVersions(this.name, this.target);
        }
        catch (VersioningException e) {
            report.failure(logger, e.getMessage());
            return;
        }
        if (matchedVersions.isEmpty()) {
            if (this.env.isDas()) {
                report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", new Object[]{this.name, this.target}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            return;
        }
        UndeployCommandParameters commandParams = new UndeployCommandParameters();
        commandParams.origin = this.server.isDas() ? OpsParams.Origin.unload : OpsParams.Origin.undeploy;
        for (String appName : matchedVersions) {
            Application application = this.applications.getApplication(appName);
            if (application == null) {
                if (this.env.isDas()) {
                    report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{appName}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                }
                return;
            }
            ApplicationRef applicationRef = this.domain.getApplicationRefInTarget(appName, this.target);
            if (applicationRef == null) {
                if (this.env.isDas()) {
                    report.setMessage(localStrings.getLocalString("appref.not.exists", "Target {1} does not have a reference to application {0}.", new Object[]{appName, this.target}));
                    report.setActionExitCode(ActionReport.ExitCode.WARNING);
                }
                return;
            }
            if (application.isLifecycleModule()) {
                try {
                    this.deployment.unregisterAppFromDomainXML(appName, this.target, true);
                }
                catch (Exception e) {
                    report.failure(logger, e.getMessage());
                }
                return;
            }
            try {
                ReadableArchive source = null;
                ApplicationInfo appInfo = this.deployment.get(appName);
                if (appInfo != null) {
                    source = appInfo.getSource();
                } else {
                    File location = new File(new URI(application.getLocation()));
                    source = this.archiveFactory.openArchive(location);
                }
                commandParams.name = appName;
                commandParams.cascade = this.cascade;
                ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger, (OpsParams)commandParams, report).source(source).build();
                deploymentContext.getAppProps().putAll((Map<?, ?>)application.getDeployProperties());
                deploymentContext.setModulePropsMap(application.getModulePropertiesMap());
                if (this.domain.isCurrentInstanceMatchingTarget(this.target, appName, this.server.getName(), null) && appInfo != null) {
                    appInfo.stop(deploymentContext, deploymentContext.getLogger());
                    appInfo.unload(deploymentContext);
                }
                if (!report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
                try {
                    if (this.server.isInstance()) {
                        this.deployment.undeploy(appName, deploymentContext);
                        deploymentContext.clean();
                        if (!Boolean.valueOf(application.getDirectoryDeployed()).booleanValue() && source.exists()) {
                            FileUtils.whack((File)new File(source.getURI()));
                        }
                        this.deployment.unregisterAppFromDomainXML(appName, this.target);
                        continue;
                    }
                    this.deployment.unregisterAppFromDomainXML(appName, this.target, true);
                }
                catch (TransactionFailure e) {
                    logger.warning("failed to delete application ref for " + appName);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error during deleteing application ref ", e);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(e.getMessage());
            }
        }
    }
}

