/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.lang.annotation.ElementType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanInterceptor;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.Transactor;
import org.jvnet.hk2.config.ValidationException;

public class WriteableView
implements InvocationHandler,
Transactor,
ConfigView {
    private final ConfigBean bean;
    private final ConfigBeanProxy defaultView;
    private final Map<String, PropertyChangeEvent> changedAttributes;
    private final Map<String, ProtectedList> changedCollections;
    Transaction currentTx;
    private static Validator beanValidator = null;

    public Transaction getTransaction() {
        return this.currentTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteableView(ConfigBeanProxy readView) {
        this.bean = (ConfigBean)((ConfigView)Proxy.getInvocationHandler(readView)).getMasterView();
        this.defaultView = this.bean.createProxy();
        this.changedAttributes = new HashMap<String, PropertyChangeEvent>();
        this.changedCollections = new HashMap<String, ProtectedList>();
        if (beanValidator == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(null);
                TraversableResolver traversableResolver = new TraversableResolver(){

                    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
                        return true;
                    }

                    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
                        return true;
                    }
                };
                ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
                ValidatorContext validatorContext = validatorFactory.usingContext();
                beanValidator = validatorContext.traversableResolver(traversableResolver).getValidator();
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("hashCode")) {
            return super.hashCode();
        }
        if (method.getName().equals("equals")) {
            return super.equals(args[0]);
        }
        if (method.getAnnotation(DuckTyped.class) != null) {
            return this.bean.invokeDuckMethod(method, proxy, args);
        }
        ConfigModel.Property property = this.bean.model.toProperty(method);
        if (property == null) {
            throw new IllegalArgumentException("No corresponding property found for method: " + method);
        }
        if (args == null || args.length == 0) {
            if (this.changedAttributes.containsKey(property.xmlName())) {
                Object changedValue = this.changedAttributes.get(property.xmlName()).getNewValue();
                if (changedValue instanceof Dom) {
                    return ((Dom)changedValue).createProxy();
                }
                return changedValue;
            }
            return this.getter(property, method.getGenericReturnType());
        }
        this.setter(property, args[0], method.getGenericParameterTypes()[0]);
        return null;
    }

    public String getPropertyValue(String propertyName) {
        ConfigModel.Property prop = this.getProperty(propertyName);
        if (prop != null) {
            if (this.changedAttributes.containsKey(prop.xmlName())) {
                return (String)this.changedAttributes.get(prop.xmlName()).getNewValue();
            }
            return (String)this.getter(prop, (Type)((Object)String.class));
        }
        return null;
    }

    public Object getter(ConfigModel.Property property, Type t) {
        Object value = this.bean._getter(property, t);
        if (value instanceof List) {
            if (!this.changedCollections.containsKey(property.xmlName())) {
                this.changedCollections.put(property.xmlName(), new ProtectedList((List)List.class.cast(value), this.defaultView, property.xmlName()));
            }
            return this.changedCollections.get(property.xmlName());
        }
        return value;
    }

    public void setter(ConfigModel.Property property, Object newValue, Type t) {
        if (this.currentTx == null) {
            throw new IllegalStateException("Not part of a transation");
        }
        try {
            if (newValue != null) {
                this.handleValidation(property, newValue);
            }
        }
        catch (Exception v) {
            this.bean.getLock().unlock();
            throw new RuntimeException(v);
        }
        if (property instanceof ConfigModel.AttributeLeaf) {
            ConfigModel.AttributeLeaf al = (ConfigModel.AttributeLeaf)property;
            ConfigBean master = this.getMasterView();
            String key = master.model.key;
            if (key != null && key.substring(1).equals(property.xmlName)) {
                key = key.substring(1);
                String oldKeyValue = this.getPropertyValue(key);
                Dom thisview = Dom.unwrap(this.defaultView);
                Dom parent = thisview.parent();
                List<Dom> siblings = parent.domNodeByTypeElements(thisview.getProxyType());
                for (Dom sibling : siblings) {
                    String siblingKey = sibling.getKey();
                    if (!newValue.equals(siblingKey)) continue;
                    this.bean.getLock().unlock();
                    throw new IllegalArgumentException("Keys cannot be duplicate. Old value of this key property, " + oldKeyValue + "will be retained");
                }
            }
        }
        Object oldValue = this.bean.getter(property, t);
        if (newValue instanceof ConfigBeanProxy) {
            ConfigView bean = (ConfigView)Proxy.getInvocationHandler((ConfigBeanProxy)newValue);
            newValue = bean.getMasterView();
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.defaultView, property.xmlName(), oldValue, newValue);
        try {
            for (ConfigBeanInterceptor interceptor : this.bean.getOptionalFeatures()) {
                interceptor.beforeChange(evt);
            }
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException(e);
        }
        this.changedAttributes.put(property.xmlName(), evt);
        for (ConfigBeanInterceptor interceptor : this.bean.getOptionalFeatures()) {
            interceptor.afterChange(evt, System.currentTimeMillis());
        }
    }

    public ConfigModel.Property getProperty(String xmlName) {
        return this.bean.model.findIgnoreCase(xmlName);
    }

    @Override
    public synchronized boolean join(Transaction t) {
        if (this.currentTx == null) {
            this.currentTx = t;
            t.addParticipant(this);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean canCommit(Transaction t) throws TransactionFailure {
        Set constraintViolations = beanValidator.validate(this.getProxy(this.getProxyType()), new Class[0]);
        if (constraintViolations != null) {
            Iterator it = constraintViolations.iterator();
            boolean violated = false;
            String msg = "Constraints for this bean violated. \n Message = ";
            while (it.hasNext()) {
                violated = true;
                ConstraintViolation cv = (ConstraintViolation)it.next();
                msg = msg + cv.getPropertyPath() + " " + cv.getMessage();
            }
            if (violated) {
                this.bean.getLock().unlock();
                throw new TransactionFailure(msg);
            }
        }
        return this.currentTx == t;
    }

    public static String stripMarkers(String s) {
        if (s.startsWith("@")) {
            return s.substring(1);
        }
        if (s.startsWith("<")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    @Override
    public synchronized List<PropertyChangeEvent> commit(Transaction t) throws TransactionFailure {
        if (this.currentTx == t) {
            this.currentTx = null;
        }
        ConfigBean master = this.getMasterView();
        String keyStr = master.model.key;
        if (keyStr != null) {
            String key = WriteableView.stripMarkers(keyStr);
            String value = this.getPropertyValue(key);
            if (value == null) {
                throw new TransactionFailure("Key value cannot be null: " + key);
            }
            if (value.length() == 0) {
                throw new TransactionFailure("Key value cannot be empty string: " + key);
            }
        }
        try {
            ArrayList<PropertyChangeEvent> appliedChanges = new ArrayList<PropertyChangeEvent>();
            for (PropertyChangeEvent event : this.changedAttributes.values()) {
                ConfigModel.Property property = this.bean.model.findIgnoreCase(event.getPropertyName());
                ConfigBeanInterceptor interceptor = this.bean.getOptionalFeature(ConfigBeanInterceptor.class);
                try {
                    if (interceptor != null) {
                        interceptor.beforeChange(event);
                    }
                }
                catch (PropertyVetoException e) {
                    throw new TransactionFailure(e.getMessage(), e);
                }
                property.set(this.bean, event.getNewValue());
                if (interceptor != null) {
                    interceptor.afterChange(event, System.currentTimeMillis());
                }
                appliedChanges.add(event);
            }
            for (ProtectedList entry : this.changedCollections.values()) {
                List<Object> originalList = entry.readOnly;
                for (PropertyChangeEvent event : entry.changeEvents) {
                    if (event.getOldValue() == null) {
                        originalList.add(event.getNewValue());
                    } else {
                        int index;
                        Object toBeRemoved;
                        Object toBeRemovedObj = event.getOldValue();
                        if (toBeRemovedObj instanceof ConfigBeanProxy) {
                            toBeRemoved = Dom.unwrap((ConfigBeanProxy)toBeRemovedObj);
                            for (index = 0; index < originalList.size(); ++index) {
                                Object element = originalList.get(index);
                                Dom dom = Dom.unwrap((ConfigBeanProxy)element);
                                if (dom != toBeRemoved) continue;
                                originalList.remove(index);
                            }
                        } else if (toBeRemovedObj instanceof String) {
                            toBeRemoved = (String)toBeRemovedObj;
                            for (index = 0; index < originalList.size(); ++index) {
                                String item = (String)originalList.get(index);
                                if (!item.equals(toBeRemoved)) continue;
                                originalList.remove(index);
                            }
                        } else {
                            throw new IllegalArgumentException();
                        }
                    }
                    appliedChanges.add(event);
                }
            }
            this.changedAttributes.clear();
            ArrayList<PropertyChangeEvent> arrayList = appliedChanges;
            return arrayList;
        }
        catch (TransactionFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransactionFailure(e.getMessage(), e);
        }
        finally {
            this.bean.getLock().unlock();
        }
    }

    @Override
    public synchronized void abort(Transaction t) {
        this.currentTx = null;
        this.bean.getLock().unlock();
        this.changedAttributes.clear();
    }

    public <T extends ConfigBeanProxy> T allocateProxy(Class<T> type) throws TransactionFailure {
        if (this.currentTx == null) {
            throw new TransactionFailure("Not part of a transaction", null);
        }
        ConfigBean newBean = this.bean.allocate(type);
        ConfigSupport cfr_ignored_0 = (ConfigSupport)this.bean.getHabitat().getComponent(ConfigSupport.class);
        WriteableView writeableView = ConfigSupport.getWriteableView(newBean.getProxy(type), newBean);
        writeableView.join(this.currentTx);
        return writeableView.getProxy(type);
    }

    @Override
    public ConfigBean getMasterView() {
        return this.bean;
    }

    @Override
    public void setMasterView(ConfigView view) {
    }

    @Override
    public <T extends ConfigBeanProxy> Class<T> getProxyType() {
        return this.bean.getProxyType();
    }

    @Override
    public <T extends ConfigBeanProxy> T getProxy(Class<T> type) {
        ConfigBean sourceBean = this.getMasterView();
        if (!type.getName().equals(sourceBean.model.targetTypeName)) {
            throw new IllegalArgumentException("This config bean interface is " + sourceBean.model.targetTypeName + " not " + type.getName());
        }
        Class[] interfacesClasses = new Class[]{type};
        return (T)((ConfigBeanProxy)Proxy.newProxyInstance(type.getClassLoader(), interfacesClasses, (InvocationHandler)this));
    }

    private String toCamelCase(String xmlName) {
        StringTokenizer st = new StringTokenizer(xmlName, "-");
        StringBuffer camelCaseName = null;
        if (st.hasMoreTokens()) {
            camelCaseName = new StringBuffer(st.nextToken());
        }
        StringBuffer sb = null;
        while (st.hasMoreTokens()) {
            sb = new StringBuffer(st.nextToken());
            char startChar = sb.charAt(0);
            sb.setCharAt(0, Character.toUpperCase(startChar));
            camelCaseName.append(sb);
        }
        return camelCaseName.toString();
    }

    private void handleValidation(ConfigModel.Property property, Object value) throws ValidationException {
        Set constraintViolations;
        if (property instanceof ConfigModel.AttributeLeaf) {
            ConfigModel.AttributeLeaf al = (ConfigModel.AttributeLeaf)property;
            this.validateDataType(al, value.toString());
        }
        if ((constraintViolations = beanValidator.validateValue(this.bean.getProxyType(), this.toCamelCase(property.xmlName()), value, new Class[0])) != null) {
            Iterator it = constraintViolations.iterator();
            boolean violated = false;
            String msg = "Constraints for this bean violated. \n Message = ";
            while (it.hasNext()) {
                violated = true;
                ConstraintViolation cv = (ConstraintViolation)it.next();
                msg = msg + cv.getPropertyPath() + " " + cv.getMessage();
            }
            if (violated) {
                throw new ValidationException(msg);
            }
        }
    }

    private void validateDataType(ConfigModel.AttributeLeaf al, String value) throws ValidationException {
        if (value.startsWith("${") && value.endsWith("}")) {
            return;
        }
        boolean isValid = String.class.getName().equals(al.dataType);
        if ("int".equals(al.dataType) || "java.lang.Integer".equals(al.dataType)) {
            isValid = this.representsInteger(value);
        } else if ("boolean".equals(al.dataType) || "java.lang.Boolean".endsWith(al.dataType)) {
            isValid = this.representsBoolean(value);
        } else if ("char".equals(al.dataType) || "java.lang.Character".equals(al.dataType)) {
            isValid = this.representsChar(value);
        }
        if (!isValid) {
            String msg = "Validation Failed: " + value + " is not of data type: " + al.dataType;
            throw new ValidationException(msg);
        }
    }

    private boolean representsBoolean(String value) {
        boolean isBoolean = "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
        return isBoolean;
    }

    private boolean representsChar(String value) {
        return value.length() == 1;
    }

    private boolean representsInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException ne) {
            return false;
        }
    }

    private class ProtectedList
    extends AbstractList {
        final ConfigBeanProxy readView;
        final List<Object> readOnly;
        final String id;
        final List<PropertyChangeEvent> changeEvents = new ArrayList<PropertyChangeEvent>();
        final List proxied;

        ProtectedList(List<Object> readOnly, ConfigBeanProxy parent, String id) {
            this.proxied = Collections.synchronizedList(new ArrayList<Object>(readOnly));
            this.readView = parent;
            this.readOnly = readOnly;
            this.id = id;
        }

        @Override
        public int size() {
            return this.proxied.size();
        }

        @Override
        public Object get(int index) {
            return this.proxied.get(index);
        }

        @Override
        public synchronized boolean add(Object object) {
            Object param = object;
            InvocationHandler handler = null;
            try {
                handler = Proxy.getInvocationHandler(object);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (handler != null && handler instanceof WriteableView) {
                ConfigBean master = ((WriteableView)handler).getMasterView();
                String key = master.model.key;
                if (key != null) {
                    key = key.substring(1);
                    String keyValue = ((WriteableView)handler).getPropertyValue(key);
                    for (Object o : this.proxied) {
                        String value = null;
                        if (Proxy.getInvocationHandler(o) instanceof WriteableView) {
                            ConfigBean masterView = ((WriteableView)handler).getMasterView();
                            String masterViewKey = masterView.model.key;
                            if (masterViewKey != null && key.equals(masterViewKey.substring(1))) {
                                value = ((WriteableView)Proxy.getInvocationHandler(o)).getPropertyValue(key);
                            }
                        } else {
                            Dom cbo = Dom.unwrap((ConfigBeanProxy)o);
                            String cboKey = cbo.model.key;
                            if (cboKey != null && key.equals(cboKey.substring(1))) {
                                value = cbo.attribute(key);
                            }
                        }
                        if (keyValue == null || value == null || !keyValue.equals(value)) continue;
                        Dom parent = Dom.unwrap(this.readView);
                        throw new IllegalArgumentException("A " + master.getProxyType().getSimpleName() + " with the same key \"" + keyValue + "\" already exists in " + parent.getProxyType().getSimpleName() + " " + parent.getKey());
                    }
                }
                param = ((WriteableView)handler).getMasterView().createProxy(master.type());
            }
            this.changeEvents.add(new PropertyChangeEvent(WriteableView.this.defaultView, this.id, null, param));
            return this.proxied.add(object);
        }

        @Override
        public synchronized void clear() {
            ArrayList allItems = new ArrayList(this.proxied);
            for (Object item : allItems) {
                this.remove(item);
            }
        }

        @Override
        public synchronized boolean retainAll(Collection keepers) {
            ArrayList toRemoveList = new ArrayList();
            for (Object iffy : this.proxied) {
                if (keepers.contains(iffy)) continue;
                toRemoveList.add(iffy);
            }
            boolean changed = this.removeAll((Collection)toRemoveList);
            return changed;
        }

        @Override
        public synchronized boolean removeAll(Collection goners) {
            boolean listChanged = false;
            for (Object goner : goners) {
                if (!this.remove(goner)) continue;
                listChanged = true;
            }
            return listChanged;
        }

        @Override
        public synchronized boolean remove(Object object) {
            this.changeEvents.add(new PropertyChangeEvent(WriteableView.this.defaultView, this.id, object, null));
            try {
                ConfigView handler = ((ConfigView)Proxy.getInvocationHandler(object)).getMasterView();
                for (int index = 0; index < this.proxied.size(); ++index) {
                    Object target = this.proxied.get(index);
                    try {
                        ConfigView targetHandler = ((ConfigView)Proxy.getInvocationHandler(target)).getMasterView();
                        if (targetHandler != handler) continue;
                        return this.proxied.remove(index) != null;
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                }
            }
            catch (IllegalArgumentException e) {
                return this.proxied.remove(object);
            }
            return false;
        }
    }
}

