/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.hk2.component.InjectionResolver;
import com.sun.logging.LogDomains;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.common.util.admin.ParamTokenizer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Multiple;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.tiger_types.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericCrudCommand
implements CommandModelProvider,
PostConstruct {
    private InjectionResolver<Param> injector;
    @Inject
    Inhabitant<?> myself;
    protected static final Logger logger = LogDomains.getLogger(GenericCrudCommand.class, (String)"javax.enterprise.system.tools.admin");
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(GenericCrudCommand.class);
    String commandName;
    Class<ConfigBeanProxy> parentType = null;
    Class<ConfigBeanProxy> targetType = null;
    Method targetMethod;
    protected final Level level = Level.FINE;

    public void postConstruct() {
        List indexes = this.myself.metadata().get((Object)"index");
        if (indexes.size() != 1) {
            StringBuffer sb = new StringBuffer();
            for (String index : indexes) {
                sb.append(index).append(" ");
            }
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.too_many_indexes", "The metadata for this generic implementation has more than one index {0}", new Object[]{sb.toString()});
            Object[] params = new Object[]{sb.toString()};
            logger.log(Level.SEVERE, "GenericCrudCommand.too_many_indexes", params);
            throw new ComponentException(msg);
        }
        String index = (String)indexes.get(0);
        if (index.indexOf(":") == -1) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.unamed_service", "The service {0} is un-named, for generic command, the service name is the command name and must be provided", new Object[]{index});
            Object[] params = new Object[]{index};
            logger.log(Level.SEVERE, "GenericCrudCommand.unamed_service", params);
            throw new ComponentException(msg);
        }
        this.commandName = index.substring(index.indexOf(":") + 1);
        String parentTypeName = (String)this.myself.metadata().get((Object)"targetType").get(0);
        if (logger.isLoggable(this.level)) {
            logger.log(this.level, "Generic method parent targeted type is " + parentTypeName);
        }
        try {
            this.parentType = this.loadClass(parentTypeName);
        }
        catch (ClassNotFoundException e) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.configbean_not_found", "The Config Bean {0} cannot be loaded by the generic command implementation : {1}", new Object[]{parentTypeName, e.getMessage()});
            Object[] params = new Object[]{parentTypeName, e.getMessage()};
            logger.log(Level.SEVERE, "GenericCrudCommand.configbean_not_found", params);
            throw new ComponentException(msg, (Throwable)e);
        }
        String methodName = (String)this.myself.metadata().get((Object)"method-name").get(0);
        this.targetMethod = null;
        for (Method m : this.parentType.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            this.targetMethod = m;
            break;
        }
        if (this.targetMethod == null) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.configbean_not_found", "The Config Bean {0} cannot be loaded by the generic command implementation : {1}", new Object[]{parentTypeName, methodName});
            Object[] params = new Object[]{parentTypeName, methodName};
            logger.log(Level.SEVERE, "GenericCrudCommand.configbean_not_found", params);
            throw new ComponentException(msg);
        }
        this.targetType = this.targetMethod.getParameterTypes().length == 0 ? Types.erasure((Type)Types.getTypeArgument((Type)this.targetMethod.getGenericReturnType(), (int)0)) : this.targetMethod.getParameterTypes()[0];
    }

    protected <T extends Annotation> T getAnnotation(Method target, Class<T> type) {
        T annotation = this.targetMethod.getAnnotation(type);
        if (annotation == null) {
            for (Annotation a : this.targetMethod.getAnnotations()) {
                Multiple multiple = a.annotationType().getAnnotation(Multiple.class);
                if (multiple == null) continue;
                try {
                    Method m = a.getClass().getMethod("value", new Class[0]);
                    Annotation[] potentials = (Annotation[])m.invoke((Object)a, new Object[0]);
                    if (potentials == null) continue;
                    for (Annotation potential : potentials) {
                        String value;
                        if (!potential.annotationType().equals(type) || !(value = (String)(m = potential.getClass().getMethod("value", new Class[0])).invoke((Object)potential, new Object[0])).equals(this.commandName)) continue;
                        return (T)((Annotation)type.cast(potential));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.annotation_not_found", "Cannot find annotation {0} with value {1} on method {2}", new Object[]{type.getName(), this.commandName, this.targetMethod.toString()});
            throw new RuntimeException(msg);
        }
        return annotation;
    }

    public void setInjectionResolver(InjectionResolver<Param> injector) {
        this.injector = injector;
    }

    public InjectionResolver<Param> getInjectionResolver() {
        final InjectionResolver<Param> delegate = this.injector;
        return new InjectionResolver<Param>(Param.class){

            public <V> V getValue(Object component, Inhabitant<?> onBehalfOf, AnnotatedElement annotated, Type genericType, Class<V> type) throws ComponentException {
                if (type.isAssignableFrom(List.class)) {
                    BeanInfo beanInfo;
                    List values;
                    block18: {
                        try {
                            if (annotated instanceof Method) {
                                values = (List)((Method)annotated).invoke(component, new Object[0]);
                                break block18;
                            }
                            if (annotated instanceof Field) {
                                values = (List)((Field)annotated).get(component);
                                break block18;
                            }
                            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.invalid_type", "Invalid annotated type {0} passed to InjectionResolver:getValue()", new Object[]{annotated.getClass().toString()});
                            Object[] params = new Object[]{annotated.getClass().toString()};
                            logger.log(Level.SEVERE, "GenericCrudCommand.invalid_type", params);
                            throw new ComponentException(msg);
                        }
                        catch (IllegalAccessException e) {
                            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.invocation_failure", "Failure {0} while getting List<?> values from component", new Object[]{e.getMessage()});
                            Object[] params = new Object[]{e.getMessage()};
                            logger.log(Level.SEVERE, "GenericCrudCommand.invocation_failure", params);
                            throw new ComponentException(msg, (Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.invocation_failure", "Failure {0} while getting List<?> values from component", new Object[]{e.getMessage()});
                            Object[] params = new Object[]{e.getMessage()};
                            logger.log(Level.SEVERE, "GenericCrudCommand.invocation_failure", params);
                            throw new ComponentException(msg, (Throwable)e);
                        }
                    }
                    Object value = delegate.getValue(component, null, annotated, genericType, type);
                    if (value == null) {
                        if (logger.isLoggable(GenericCrudCommand.this.level)) {
                            logger.log(GenericCrudCommand.this.level, "Value of " + annotated.toString() + " is null");
                        }
                        return null;
                    }
                    Class itemType = Types.erasure((Type)Types.getTypeArgument((Type)(annotated instanceof Method ? ((Method)annotated).getGenericReturnType() : ((Field)annotated).getGenericType()), (int)0));
                    if (logger.isLoggable(GenericCrudCommand.this.level)) {
                        logger.log(GenericCrudCommand.this.level, "Found that List<?> really is a List<" + itemType.toString() + ">");
                    }
                    if (itemType == null) {
                        String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.nongeneric_type", "The List type returned by {0} must be a generic type", new Object[]{annotated.toString()});
                        Object[] params = new Object[]{annotated.toString()};
                        logger.log(Level.SEVERE, "GenericCrudCommand.nongeneric_type", params);
                        throw new ComponentException(msg);
                    }
                    if (!ConfigBeanProxy.class.isAssignableFrom(itemType)) {
                        String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.wrong_type", "The generic type {0} is not supported, only List<? extends ConfigBeanProxy> is", new Object[]{annotated.toString()});
                        Object[] params = new Object[]{annotated.toString()};
                        logger.log(Level.SEVERE, "GenericCrudCommand.wrong_type", params);
                        throw new ComponentException(msg);
                    }
                    Properties props = GenericCrudCommand.convertStringToProperties(value.toString(), ':');
                    if (logger.isLoggable(GenericCrudCommand.this.level)) {
                        for (Map.Entry<Object, Object> entry : props.entrySet()) {
                            logger.log(GenericCrudCommand.this.level, "Subtype " + itemType + " key:" + entry.getKey() + " value:" + entry.getValue());
                        }
                    }
                    try {
                        beanInfo = Introspector.getBeanInfo(itemType);
                    }
                    catch (IntrospectionException e) {
                        String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.introspection_failure", "Failure {0} while instrospecting {1} to find all getters and setters", new Object[]{e.getMessage(), itemType.getName()});
                        Object[] params = new Object[]{e.getMessage(), itemType.getName()};
                        logger.log(Level.SEVERE, "GenericCrudCommand.introspection_failure", params);
                        throw new ComponentException(msg, (Throwable)e);
                    }
                    for (final Map.Entry<Object, Object> entry : props.entrySet()) {
                        ConfigBeanProxy child = (ConfigBeanProxy)component;
                        try {
                            Object cc = child.createChild(itemType);
                            new InjectionManager().inject(cc, itemType, new InjectionResolver[]{new InjectionResolver<Attribute>(Attribute.class){

                                public boolean isOptional(AnnotatedElement annotated, Attribute annotation) {
                                    return true;
                                }

                                public Method getSetterMethod(Method annotated, Attribute annotation) {
                                    for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                                        if (!pd.getReadMethod().equals(annotated)) continue;
                                        return pd.getWriteMethod();
                                    }
                                    return annotated;
                                }

                                public <V> V getValue(Object component, Inhabitant<?> onBehalfOf, AnnotatedElement annotated, Type genericType, Class<V> type) throws ComponentException {
                                    String name = annotated.getAnnotation(Attribute.class).value();
                                    if (name == null || name.length() == 0) {
                                        name = ((Method)annotated).getName().substring(3);
                                        if (name.equalsIgnoreCase("name") || name.equalsIgnoreCase("key")) {
                                            return type.cast(entry.getKey());
                                        }
                                        if (name.equalsIgnoreCase("value")) {
                                            return type.cast(entry.getValue());
                                        }
                                    }
                                    return null;
                                }
                            }});
                            values.add(cc);
                        }
                        catch (TransactionFailure transactionFailure) {
                            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.transactionException", "Transaction exception {0} while injecting {1}", new Object[]{transactionFailure.getMessage(), itemType});
                            Object[] params = new Object[]{transactionFailure.getMessage(), itemType};
                            logger.log(Level.SEVERE, "GenericCrudCommand.transactionException", params);
                            throw new ComponentException(msg, (Throwable)transactionFailure);
                        }
                    }
                    return null;
                }
                return (V)delegate.getValue(component, null, annotated, genericType, type);
            }

            public boolean isOptional(AnnotatedElement annotated, Param annotation) {
                return annotation.optional();
            }
        };
    }

    protected Class loadClass(String type) throws ClassNotFoundException {
        return this.myself.type().getClassLoader().loadClass(type);
    }

    public static Properties convertStringToProperties(String propsString, char sep) {
        Properties properties = new Properties();
        if (propsString != null && !propsString.equals("[]")) {
            String unbracedString = propsString.substring(propsString.indexOf(91) + 1);
            ParamTokenizer stoken = new ParamTokenizer(unbracedString, sep);
            while (stoken.hasMoreTokens()) {
                String token = stoken.nextTokenKeepEscapes();
                ParamTokenizer nameTok = new ParamTokenizer(token, '=');
                String name = null;
                String value = null;
                if (nameTok.hasMoreTokens()) {
                    name = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens()) {
                    value = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens() || name == null || value == null) {
                    throw new IllegalArgumentException("TODO : i18n : Invalid property syntax." + propsString);
                }
                int index = value.indexOf(93);
                String unbracedValue = index > 0 ? value.substring(0, index) : value;
                properties.setProperty(name, unbracedValue);
            }
        }
        return properties;
    }

    public static String elementName(DomDocument document, Class<?> parent, Class<?> child) throws ClassNotFoundException {
        ConfigModel cm = document.buildModel(parent);
        for (String elementName : cm.getElementNames()) {
            ConfigModel.Property prop = cm.getElement(elementName);
            if (!(prop instanceof ConfigModel.Node)) continue;
            ConfigModel childCM = ((ConfigModel.Node)prop).getModel();
            String childTypeName = childCM.targetTypeName;
            if (childTypeName.equals(child.getName())) {
                return elementName;
            }
            List<ConfigModel> subChildrenModels = document.getAllModelsImplementing(((ClassLoader)childCM.classLoaderHolder.get()).loadClass(childTypeName));
            if (subChildrenModels == null) continue;
            for (ConfigModel subChildModel : subChildrenModels) {
                if (!subChildModel.targetTypeName.equals(child.getName())) continue;
                return elementName;
            }
        }
        return null;
    }
}

