/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class APIClassLoaderServiceImpl
implements PostConstruct {
    private ClassLoader theAPIClassLoader;
    @Inject
    ModulesRegistry mr;
    private static final String APIExporterModuleName = "GlassFish-Application-Common-Module";
    private static final String MAILCAP = "META-INF/mailcap";
    static final Logger logger = LogDomains.getLogger(APIClassLoaderServiceImpl.class, (String)"javax.enterprise.system.core.classloading");
    private Module APIModule;

    public void postConstruct() {
        try {
            this.createAPIClassLoader();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createAPIClassLoader() throws IOException {
        this.APIModule = this.mr.getModules(APIExporterModuleName).iterator().next();
        assert (this.APIModule != null);
        ClassLoader apiModuleLoader = this.APIModule.getClassLoader();
        this.theAPIClassLoader = new APIClassLoader(apiModuleLoader, this.getExtensionClassLoader());
        logger.logp(Level.FINE, "APIClassLoaderService", "createAPIClassLoader", "APIClassLoader = {0}", new Object[]{this.theAPIClassLoader});
    }

    private ClassLoader getExtensionClassLoader() {
        return ClassLoader.getSystemClassLoader().getParent();
    }

    public ClassLoader getAPIClassLoader() {
        return this.theAPIClassLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class APIClassLoader
    extends ClassLoader {
        private Set<String> blacklist;
        private final ClassLoader apiModuleLoader;

        public APIClassLoader(ClassLoader apiModuleLoader, ClassLoader parent) {
            super(parent);
            this.apiModuleLoader = apiModuleLoader;
            this.blacklist = new HashSet<String>();
            APIClassLoaderServiceImpl.this.mr.register(new ModuleLifecycleListener(){

                public void moduleInstalled(Module module) {
                    APIClassLoader.this.clearBlackList();
                }

                public void moduleResolved(Module module) {
                }

                public void moduleStarted(Module module) {
                }

                public void moduleStopped(Module module) {
                }

                public void moduleUpdated(Module module) {
                    APIClassLoader.this.clearBlackList();
                }
            });
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            String resourceName = this.convertToResourceName(name);
            if (this.isBlackListed(resourceName)) {
                throw new ClassNotFoundException(name);
            }
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                if (!name.startsWith("java.")) {
                    try {
                        c = this.apiModuleLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
                if (c == null) {
                    try {
                        c = super.loadClass(name, resolve);
                    }
                    catch (ClassNotFoundException e) {
                        this.addToBlackList(resourceName);
                        throw e;
                    }
                }
            }
            return c;
        }

        @Override
        public URL getResource(String name) {
            if (this.isBlackListed(name)) {
                return null;
            }
            URL url = null;
            if (!name.startsWith("java/")) {
                if (name.equals(APIClassLoaderServiceImpl.MAILCAP)) {
                    Module m;
                    Iterator<Module> i$ = APIClassLoaderServiceImpl.this.mr.getModules().iterator();
                    while (i$.hasNext() && (url = (m = i$.next()).getClassLoader().getResource(name)) == null) {
                    }
                } else {
                    url = this.apiModuleLoader.getResource(name);
                }
            }
            if (url == null) {
                url = super.getResource(name);
            }
            if (url == null) {
                this.addToBlackList(name);
            }
            return url;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
            if (!name.startsWith("java/")) {
                if (name.equals(APIClassLoaderServiceImpl.MAILCAP)) {
                    for (Module m : APIClassLoaderServiceImpl.this.mr.getModules()) {
                        enumerators.add(m.getClassLoader().getResources(name));
                    }
                } else {
                    enumerators.add(this.apiModuleLoader.getResources(name));
                }
            }
            enumerators.add(super.getResources(name));
            return new CompositeEnumeration(enumerators);
        }

        public String toString() {
            return "APIClassLoader";
        }

        private String convertToResourceName(String className) {
            return className.replace('.', '/').concat(".class");
        }

        private synchronized boolean isBlackListed(String name) {
            return this.blacklist.contains(name);
        }

        private synchronized void addToBlackList(String name) {
            this.blacklist.add(name);
        }

        private synchronized void clearBlackList() {
            this.blacklist.clear();
        }
    }
}

