/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.CopyConfig;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.hk2.component.InjectionResolver;
import java.beans.PropertyVetoException;
import java.lang.reflect.Proxy;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.common.util.admin.GenericCommandModel;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.config.support.Delete;
import org.glassfish.config.support.DeletionDecorator;
import org.glassfish.config.support.GenericCrudCommand;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.WriteableView;

@Scoped(value=PerLookup.class)
public class GenericDeleteCommand
extends GenericCrudCommand
implements AdminCommand,
PostConstruct,
CommandModelProvider {
    @Inject
    Habitat habitat;
    @Inject
    CommandRunner runner;
    Class<? extends CrudResolver> resolverType;
    CommandModel model;
    Delete delete;

    public CommandModel getModel() {
        return this.model;
    }

    public void postConstruct() {
        super.postConstruct();
        this.delete = this.targetMethod.getAnnotation(Delete.class);
        this.resolverType = this.delete.resolver();
        try {
            this.model = new GenericCommandModel(this.targetType, false, this.delete.cluster(), this.delete.i18n(), (LocalStringManager)new LocalStringManagerImpl(this.targetType), (DomDocument)this.habitat.getComponent(DomDocument.class), this.commandName, new Class[]{this.delete.resolver(), this.delete.decorator()});
            if (logger.isLoggable(this.level)) {
                for (String paramName : this.model.getParametersNames()) {
                    CommandModel.ParamModel param = this.model.getModelFor(paramName);
                    logger.fine("I take " + param.getName() + " parameters");
                }
            }
        }
        catch (Exception e) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCreateCommand.command_model_exception", "Exception while creating the command model for the generic command {0} : {1}", new Object[]{this.commandName, e.getMessage()});
            logger.severe(msg);
            throw new ComponentException(msg, (Throwable)e);
        }
    }

    public void execute(final AdminCommandContext context) {
        final ActionReport result = context.getActionReport();
        CopyConfig command = (CopyConfig)this.runner.getCommand("copy-config", context.getActionReport(), context.getLogger());
        if (command == null) {
            String msg = localStrings.getLocalString("cannot.execute.command", "Cluster software is not installed");
            result.failure(logger, msg);
            return;
        }
        final InjectionManager manager = new InjectionManager();
        CrudResolver resolver = (CrudResolver)this.habitat.getComponent(this.resolverType);
        final InjectionResolver<Param> paramResolver = this.getInjectionResolver();
        manager.inject((Object)resolver, new InjectionResolver[]{paramResolver});
        final Object target = resolver.resolve(context, this.targetType);
        if (target == null) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericDeleteCommand.target_object_not_found", "The CrudResolver {0} could not find the configuration object of type {1} where instances of {2} should be removed", new Object[]{resolver.getClass().toString(), this.parentType, this.targetType});
            result.failure(logger, msg);
            return;
        }
        final ConfigBean child = (ConfigBean)ConfigBean.unwrap(target);
        try {
            Object parentProxy = child.parent().createProxy();
            ConfigSupport.apply(new SingleConfigCode<ConfigBeanProxy>(){

                @Override
                public Object run(ConfigBeanProxy parentProxy) throws PropertyVetoException, TransactionFailure {
                    ConfigSupport._deleteChild(child.parent(), (WriteableView)Proxy.getInvocationHandler(parentProxy), child);
                    DeletionDecorator decorator = (DeletionDecorator)GenericDeleteCommand.this.habitat.getComponent(GenericDeleteCommand.this.delete.decorator());
                    if (decorator == null) {
                        String msg = GenericCrudCommand.localStrings.getLocalString(GenericCrudCommand.class, "GenericCreateCommand.deletion_decorator_not_found", "The DeletionDecorator {0} could not be found in the habitat,is it annotated with @Service ?", new Object[]{GenericDeleteCommand.this.delete.decorator().toString()});
                        result.failure(GenericCrudCommand.logger, msg);
                        throw new TransactionFailure(msg);
                    }
                    manager.inject((Object)decorator, new InjectionResolver[]{paramResolver});
                    decorator.decorate(context, parentProxy, target);
                    return null;
                }
            }, parentProxy);
        }
        catch (TransactionFailure e) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericDeleteCommand.transaction_exception", "Exception while deleting the configuration {0} :{1}", new Object[]{child.typeName(), e.getMessage()});
            result.failure(logger, msg);
        }
    }
}

